% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\alias{use_cluster}
\alias{status_cluster}
\alias{close_cluster}
\title{Run \code{heemod} on a Cluster}
\usage{
use_cluster(num_cores, cluster = NULL, close = TRUE)

status_cluster(verbose = TRUE)

close_cluster()
}
\arguments{
\item{num_cores}{Number of core.}

\item{cluster}{A custom cluster. See details.}

\item{close}{Close existing cluster before defining a new
one?}

\item{verbose}{Print cluster info.}
}
\value{
\code{use_cluster} and \code{close_cluster}
return \code{TRUE} invisibly in case of success.
\code{status_cluster} returns \code{TRUE} if a cluster
is defined, \code{FALSE} otherwise.
}
\description{
These functions create or delete a cluster for
\code{heemod}. When the cluster is created it is
automagically used by \code{heemod} functions.
}
\details{
The usual workflow is to create the cluster with
\code{use_cluster}, then run functions such as
\code{\link[=run_psa]{run_psa()}} that make use of the cluster. To
stop using the cluster run \code{\link[=close_cluster]{close_cluster()}}.

The cluster status is given by \code{status_cluster}.

A custom cluster can be passed to \code{use_cluster} with
the \code{cluster} argument. This custom cluster needs to
work with \code{\link[parallel:clusterApply]{parallel::parLapply()}}.
}
