% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-geometric-brownian-motion.R
\name{ts_geometric_brownian_motion}
\alias{ts_geometric_brownian_motion}
\title{Geometric Brownian Motion}
\usage{
ts_geometric_brownian_motion(
  .num_sims = 100,
  .time = 25,
  .mean = 0,
  .sigma = 0.1,
  .initial_value = 100,
  .delta_time = 1/365,
  .return_tibble = TRUE
)
}
\arguments{
\item{.num_sims}{Total number of simulations.}

\item{.time}{Total time of the simulation.}

\item{.mean}{Expected return}

\item{.sigma}{Volatility}

\item{.initial_value}{Integer representing the initial value.}

\item{.delta_time}{Time step size.}

\item{.return_tibble}{The default is TRUE. If set to FALSE then an object
of class matrix will be returned.}
}
\value{
A tibble/matrix
}
\description{
Create a Geometric Brownian Motion.
}
\details{
Geometric Brownian Motion (GBM) is a statistical method for modeling
the evolution of a given financial asset over time. It is a type of stochastic
process, which means that it is a system that undergoes random changes over
time.

GBM is widely used in the field of finance to model the behavior of stock
prices, foreign exchange rates, and other financial assets. It is based on
the assumption that the asset's price follows a random walk, meaning that it
is influenced by a number of unpredictable factors such as market trends,
news events, and investor sentiment.

The equation for GBM is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ dS/S = mdt + sdW
}\if{html}{\out{</div>}}

where S is the price of the asset, t is time, m is the expected return on the
asset, s is the volatility of the asset, and dW is a small random change in
the asset's price.

GBM can be used to estimate the likelihood of different outcomes for a given
asset, and it is often used in conjunction with other statistical methods to
make more accurate predictions about the future performance of an asset.

This function provides the ability of simulating and estimating the parameters
of a GBM process. It can be used to analyze the behavior of financial
assets and to make informed investment decisions.
}
\examples{
ts_geometric_brownian_motion()

}
\seealso{
Other Data Generator: 
\code{\link{tidy_fft}()},
\code{\link{ts_brownian_motion_augment}()},
\code{\link{ts_brownian_motion}()},
\code{\link{ts_geometric_brownian_motion_augment}()},
\code{\link{ts_random_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Generator}
