% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-event-analysis-tbl.R
\name{ts_time_event_analysis_tbl}
\alias{ts_time_event_analysis_tbl}
\title{Event Analysis}
\usage{
ts_time_event_analysis_tbl(
  .data,
  .date_col,
  .value_col,
  .percent_change = 0.05,
  .horizon = 12,
  .precision = 2,
  .direction = "forward",
  .filter_non_event_groups = TRUE
)
}
\arguments{
\item{.data}{The date.frame/tibble that holds the data.}

\item{.date_col}{The column with the date value.}

\item{.value_col}{The column with the value you are measuring.}

\item{.percent_change}{This defaults to 0.05 which is a 5\% increase in the
\code{.value_col}.}

\item{.horizon}{How far do you want to look back or ahead.}

\item{.precision}{The default is 2 which means it rounds the lagged 1 value
percent change to 2 decimal points. You may want more for more finely tuned
results, this will result in fewer groupings.}

\item{.direction}{The default is \code{forward}. You can supply either \code{forward},
\code{backwards} or \code{both}.}

\item{.filter_non_event_groups}{The default is TRUE, this drops groupings with
no events on the rare occasion it does occur.}
}
\value{
A tibble.
}
\description{
Given a tibble/data.frame, you can get information on what happens before, after,
or in both directions of some given event, where the event is defined by some
percentage increase/decrease in values from time \code{t} to \code{t+1}
}
\details{
This takes in a \code{data.frame}/\code{tibble} of a time series. It requires a date column,
and a value column. You can convert a \code{ts}/\code{xts}/\code{zoo}/\code{mts} object into a tibble by
using the \code{ts_to_tbl()} function.

You will provide the function with a percentage change in the form of -1 to 1
inclusive. You then provide a time horizon in which you want to see. For example
you may want to see what happens to \code{AirPassengers} after a 0.1 percent increase
in volume.

The next most important thing to supply is the direction. Do you want to see what
typically happens after such an event, what leads up to such an event, or both.
}
\examples{
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(ggplot2))

df_tbl <- ts_to_tbl(AirPassengers) \%>\% select(-index)

tst <- ts_time_event_analysis_tbl(df_tbl, date_col, value, .direction = "both",
.horizon = 6)

glimpse(tst)

tst \%>\%
  ggplot(aes(x = x, y = mean_event_change)) +
  geom_line() +
  geom_line(aes(y = event_change_ci_high), color = "blue", linetype = "dashed") +
  geom_line(aes(y = event_change_ci_low), color = "blue", linetype = "dashed") +
  geom_vline(xintercept = 7, color = "red", linetype = "dashed") +
  theme_minimal() +
  labs(
    title = "'AirPassengers' Event Analysis at 5\% Increase",
    subtitle = "Vertical Red line is normalized event epoch - Direction: Both",
    x = "",
    y = "Mean Event Change"
  )


}
\seealso{
Other Time_Filtering: 
\code{\link{ts_compare_data}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Time_Filtering}
