% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-feature-availability-profiler.R
\name{percentDataAvailableInDateRange}
\alias{percentDataAvailableInDateRange}
\title{Find the percent of a column that's filled}
\usage{
percentDataAvailableInDateRange(df, dateColumn = NULL,
  startInclusive = NULL, endExclusive = NULL)
}
\arguments{
\item{df}{A dataframe}

\item{dateColumn}{Optional string representing a date column of interest}

\item{startInclusive}{Optional string in the in this date style: 'YYYY-MM-DD'}

\item{endExclusive}{Optional string in the in this date style: 'YYYY-MM-DD'}
}
\value{
A labeled numeric vector, representing each column in input df
}
\description{
Shows what percentage of data is avilable (potentially within a specified 
date range)
}
\examples{
df <- data.frame(a = c(1,2,NA,NA),
                 b = c('m','f','m','f'),
                 c = c(0.7,NA,2.4,-4),
                 d = c(100,300,200,NA),
                 e = c(400,500,NA,504),
                 datecol = c('2012-01-01','2012-01-02',
                             '2012-01-03','2012-01-07'))

out <- percentDataAvailableInDateRange(df = df, # <- Only required argument
                                       dateColumn = 'datecol',
                                       startInclusive = '2012-01-01',
                                       endExclusive = '2012-01-08')
out
}
\references{
\url{http://healthcareai-r.readthedocs.io}
}
\seealso{
\code{\link{healthcareai}}
}
