% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_adjust.R
\name{p_adjust}
\alias{p_adjust}
\alias{p_adjust.rlassoEffects}
\alias{p_adjust.lm}
\alias{p_adjust.rlassoEffects}
\alias{p_adjust.lm}
\title{Multiple Testing Adjustment of p-values for S3 objects \code{rlassoEffects}
and \code{lm}}
\usage{
p_adjust(x, ...)

\method{p_adjust}{rlassoEffects}(x, method = "RW", B = 1000, ...)

\method{p_adjust}{lm}(x, method = "RW", B = 1000, test.index = NULL, ...)
}
\arguments{
\item{x}{an object of S3 class \code{rlassoEffects} or \code{lm}.}

\item{...}{further arguments passed on to methods.}

\item{method}{the method of p-value adjustment for multiple testing.
Romano-Wolf stepdown ('\code{RW}') is chosen by default.}

\item{B}{number of bootstrap repetitions (default 1000).}

\item{test.index}{vector of integers, logicals or variables names indicating
the position of coefficients (integer case), logical vector of length of the
coefficients (TRUE or FALSE) or the coefficient names of x which should be
tested simultaneously (only for S3 class \code{lm}). If missing, all
coefficients are considered.}
}
\value{
A matrix with the estimated coefficients and the p-values that are
 adjusted according to the specified method.
}
\description{
Multiple hypotheses testing adjustment of p-values from a high-dimensional
linear model.
}
\details{
Multiple testing adjustment is performed for S3 objects of class
\code{rlassoEffects} and \code{lm}. Implemented methods for multiple testing
adjustment are Romano-Wolf stepdown '\code{RW}' (default) and the adjustment
methods available in the \code{p.adjust} function of the \code{stats} package,
including the Bonferroni, Bonferroni-Holm, and Benjamini-Hochberg corrections,
see \code{\link{p.adjust.methods}}.

Objects of class \code{rlassoEffects} are constructed by
\code{\link{rlassoEffects}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{rlassoEffects}: \code{\link{rlassoEffects}}.

\item \code{lm}: \code{\link[stats]{lm}}.
}}

\examples{
library(hdm);
set.seed(1)
n = 100 #sample size
p = 25 # number of variables
s = 3 # nubmer of non-zero variables
X = matrix(rnorm(n*p), ncol=p)
colnames(X) <- paste("X", 1:p, sep="")
beta = c(rep(3,s), rep(0,p-s))
y = 1 + X\%*\%beta + rnorm(n)
data = data.frame(cbind(y,X))
colnames(data)[1] <- "y"
lasso.effect = rlassoEffects(X, y, index=c(1:20))
pvals.lasso.effect = p_adjust(lasso.effect, method = "RW", B = 1000)
ols = lm(y ~ -1 + X, data)
pvals.ols = p_adjust(ols, method = "RW", B = 1000)
pvals.ols = p_adjust(ols, method = "RW", B = 1000, test.index = c(1,2,5))
pvals.ols = p_adjust(ols, method = "RW", B = 1000, test.index = c(rep(TRUE, 5), rep(FALSE, p-5)))
}
\references{
J.P. Romano, M. Wolf (2005). Exact and approximate stepdown
 methods for multiple hypothesis testing. Journal of the American Statistical
 Association, 100(469), 94-108.

J.P. Romano, M. Wolf (2016). Efficient computation of adjusted
 p-values for resampling-based stepdown multiple testing. Statistics and
 Probability Letters, (113), 38-40.

A. Belloni, V. Chernozhukov, K. Kato (2015). Uniform
 post-selection inference for least absolute deviation regression and other
 Z-estimation problems. Biometrika, 102(1), 77-94.
}
