% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlassologitEffect.R
\name{rlassologitEffects}
\alias{rlassologitEffect}
\alias{rlassologitEffects}
\alias{rlassologitEffects.default}
\alias{rlassologitEffects.formula}
\title{rigorous Lasso for Logistic Models: Inference}
\usage{
rlassologitEffects(x, ...)

\method{rlassologitEffects}{default}(x, y, index = c(1:ncol(x)), I3 = NULL,
  post = TRUE, ...)

\method{rlassologitEffects}{formula}(formula, data, I, included = NULL,
  post = TRUE, ...)

rlassologitEffect(x, y, d, I3 = NULL, post = TRUE)
}
\arguments{
\item{x}{matrix of regressor variables serving as controls and potential
treatments.  For \code{rlassologitEffect} it contains only controls, for \code{rlassologitEffects} both controls and potential treatments. For  \code{rlassologitEffects} it must have at least two columns.}

\item{y}{outcome variable}

\item{index}{vector of integers, logical or names indicating the position (column) or name of
variables of x which should be used as treatment variables.}

\item{I3}{logical vector with same length as the number of controls;
indicates if variables (TRUE) should be included in any case.}

\item{post}{logical. If \code{TRUE}, post-Lasso estimation is conducted.}

\item{formula}{An element of class \code{formula} specifying the linear model.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. 
If not found in data, the variables are taken from environment(formula), typically the environment from which the function is called.}

\item{I}{An one-sided formula specifying the variables for which inference is conducted.}

\item{included}{One-sided formula of variables which should be included in any case.}

\item{d}{variable for which inference is conducted (treatment variable)}

\item{\dots}{additional parameters}
}
\value{
The function returns an object of class \code{rlassologitEffects} with the following entries: \item{coefficients}{estimated
value of the coefficients} \item{se}{standard errors}
\item{t}{t-statistics} \item{pval}{p-values} \item{samplesize}{sample size of the data set} \item{I}{index of variables of the union of the lasso regressions}
}
\description{
The function estimates (low-dimensional) target coefficients in a high-dimensional logistic model.
}
\details{
The functions estimates (low-dimensional) target coefficients in a high-dimensional logistic model.
An application is e.g. estimation of a treatment effect \eqn{\alpha_0} in a
setting of high-dimensional controls. The function is a wrap function for \code{rlassologitEffect} which does inference for only one variable (d).
}
\references{
A. Belloni, V. Chernozhukov, Y. Wei (2013). Honest confidence regions for a regression parameter in logistic regression with a loarge number of controls.
cemmap working paper CWP67/13.
}

