% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rlassotreatment.R
\name{rlassoATE}
\alias{ATE}
\alias{ATET}
\alias{LATE}
\alias{LATET}
\alias{ate}
\alias{atet}
\alias{late}
\alias{latet}
\alias{rlassoATE}
\alias{rlassoATET}
\alias{rlassoLATE}
\alias{rlassoLATET}
\title{Functions for estimation of treatment effects}
\usage{
rlassoATE(x, d, y, bootstrap = "none", nRep = 500, ...)

rlassoATET(x, d, y, bootstrap = "none", nRep = 500, ...)

rlassoLATE(x, d, y, z, bootstrap = "none", nRep = 500, post = TRUE,
  intercept = TRUE)

rlassoLATET(x, d, y, z, bootstrap = "none", nRep = 500, post = TRUE,
  intercept = TRUE)
}
\arguments{
\item{x}{exogenous variables}

\item{d}{treatment variable (binary)}

\item{y}{outcome variable / dependent variable}

\item{bootstrap}{boostrap method which should be employed: 'none', 'Bayes',
'normal', 'wild'}

\item{nRep}{number of replications for the bootstrap}

\item{...}{arguments passed, e.g. \code{intercept} and \code{post}}

\item{z}{instrumental variables (binary)}

\item{post}{logical. If \code{TRUE}, post-lasso estimation is conducted.}

\item{intercept}{logical. If \code{TRUE}, intercept is included which is not
penalized.}
}
\value{
Functions return an object of class \code{rlassoTE} with estimated effects, standard errors and
individual effects in the form of a \code{list}.
}
\description{
This class of functions estimates the average treatment effect (ATE), the ATE of the tretated (ATET), the local average treatment effects (LATE) and the LATE of
the tretated (LATET). The estimation methods rely on immunized / orthogonal moment
conditions which guarantee valid post-selection inference in a high-dimensional setting. Further details can be found in Belloni et al. (2014).
}
\details{
Details can be found in Belloni et al. (2014).
}
\references{
A. Belloni, V. Chernozhukov, I. Fernandez-Val, and C. Hansen
(2014). Program evaluation with high-dimensional data. Working Paper.
}
\keyword{average}
\keyword{effect}
\keyword{lasf}
\keyword{lasft}
\keyword{late}
\keyword{latt}
\keyword{local}
\keyword{structural}
\keyword{treatment}

