% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5T.R
\docType{class}
\name{H5T_VLEN-class}
\alias{H5T_VLEN-class}
\alias{H5T_VLEN}
\title{Class for HDF5 variable-length datatypes.}
\value{
Object of class \code{\link[=H5T_VLEN]{H5T_VLEN}}.
}
\description{
Inherits from class \code{\link[=H5T]{H5T}}. This can make any datatype a variable length datatype.
This would mostly be intended for storing ragged arrays.
}
\section{Methods}{

\describe{
\item{\code{new(dtype_base, id = NULL)}}{

Create a variable length datatype

\strong{Parameters}
\describe{
\item{dtype_base}{The basis-type of the variable length datatype}
\item{id}{Internal use only}
}}

\item{\code{get_super()}}{

This function implements the HDF5-API function H5Tget_super.
Please see the documentation at \url{https://portal.hdfgroup.org/display/HDF5/H5T_GET_SUPER} for details.}

\item{\code{describe()}}{

Print a detailed description of the datatype; this is experimental}
}}

\examples{
vlen_int <- H5T_VLEN$new(h5types$H5T_NATIVE_INT)
vlen_int
}
\seealso{
\code{\link[=H5T]{H5T}}
}
\author{
Holger Hoefling
}
