// (c) The HDF Group
#ifndef H5VLconnector_H
#define H5VLconnector_H
#include "H5public.h"
#include "H5Apublic.h"
#include "H5Dpublic.h"
#include "H5ESpublic.h"
#include "H5Fpublic.h"
#include "H5Ipublic.h"
#include "H5Lpublic.h"
#include "H5Opublic.h"
#include "H5Rpublic.h"
#include "H5VLpublic.h"
#define H5VL_CONTAINER_INFO_VERSION 0x01
#define H5VL_MAX_BLOB_ID_SIZE (16)
#define H5VL_RESERVED_NATIVE_OPTIONAL 1024
typedef enum H5VL_loc_type_t {
    H5VL_OBJECT_BY_SELF,
    H5VL_OBJECT_BY_NAME,
    H5VL_OBJECT_BY_IDX,
    H5VL_OBJECT_BY_TOKEN
} H5VL_loc_type_t;
typedef struct H5VL_loc_by_name {
    const char *name;
    hid_t       lapl_id;
} H5VL_loc_by_name_t;
typedef struct H5VL_loc_by_idx {
    const char     *name;
    H5_index_t      idx_type;
    H5_iter_order_t order;
    hsize_t         n;
    hid_t           lapl_id;
} H5VL_loc_by_idx_t;
typedef struct H5VL_loc_by_token {
    H5O_token_t *token;
} H5VL_loc_by_token_t;
typedef struct H5VL_loc_params_t {
    H5I_type_t      obj_type;
    H5VL_loc_type_t type;
    union {
        H5VL_loc_by_token_t loc_by_token;
        H5VL_loc_by_name_t  loc_by_name;
        H5VL_loc_by_idx_t   loc_by_idx;
    } loc_data;
} H5VL_loc_params_t;
typedef struct H5VL_optional_args_t {
    int   op_type;
    void *args;
} H5VL_optional_args_t;
typedef enum H5VL_attr_get_t {
    H5VL_ATTR_GET_ACPL,
    H5VL_ATTR_GET_INFO,
    H5VL_ATTR_GET_NAME,
    H5VL_ATTR_GET_SPACE,
    H5VL_ATTR_GET_STORAGE_SIZE,
    H5VL_ATTR_GET_TYPE
} H5VL_attr_get_t;
typedef struct H5VL_attr_get_name_args_t {
    H5VL_loc_params_t loc_params;
    size_t            buf_size;
    char             *buf;
    size_t           *attr_name_len;
} H5VL_attr_get_name_args_t;
typedef struct H5VL_attr_get_info_args_t {
    H5VL_loc_params_t loc_params;
    const char       *attr_name;
    H5A_info_t       *ainfo;
} H5VL_attr_get_info_args_t;
typedef struct H5VL_attr_get_args_t {
    H5VL_attr_get_t op_type;
    union {
        struct {
            hid_t acpl_id;
        } get_acpl;
        H5VL_attr_get_info_args_t get_info;
        H5VL_attr_get_name_args_t get_name;
        struct {
            hid_t space_id;
        } get_space;
        struct {
            hsize_t *data_size;
        } get_storage_size;
        struct {
            hid_t type_id;
        } get_type;
    } args;
} H5VL_attr_get_args_t;
typedef enum H5VL_attr_specific_t {
    H5VL_ATTR_DELETE,
    H5VL_ATTR_DELETE_BY_IDX,
    H5VL_ATTR_EXISTS,
    H5VL_ATTR_ITER,
    H5VL_ATTR_RENAME
} H5VL_attr_specific_t;
typedef struct H5VL_attr_iterate_args_t {
    H5_index_t      idx_type;
    H5_iter_order_t order;
    hsize_t        *idx;
    H5A_operator2_t op;
    void           *op_data;
} H5VL_attr_iterate_args_t;
typedef struct H5VL_attr_delete_by_idx_args_t {
    H5_index_t      idx_type;
    H5_iter_order_t order;
    hsize_t         n;
} H5VL_attr_delete_by_idx_args_t;
typedef struct H5VL_attr_specific_args_t {
    H5VL_attr_specific_t op_type;
    union {
        struct {
            const char *name;
        } del;
        H5VL_attr_delete_by_idx_args_t delete_by_idx;
        struct {
            const char *name;
            hbool_t    *exists;
        } exists;
        H5VL_attr_iterate_args_t iterate;
        struct {
            const char *old_name;
            const char *new_name;
        } rename;
    } args;
} H5VL_attr_specific_args_t;
typedef int H5VL_attr_optional_t;
typedef enum H5VL_dataset_get_t {
    H5VL_DATASET_GET_DAPL,
    H5VL_DATASET_GET_DCPL,
    H5VL_DATASET_GET_SPACE,
    H5VL_DATASET_GET_SPACE_STATUS,
    H5VL_DATASET_GET_STORAGE_SIZE,
    H5VL_DATASET_GET_TYPE
} H5VL_dataset_get_t;
typedef struct H5VL_dataset_get_args_t {
    H5VL_dataset_get_t op_type;
    union {
        struct {
            hid_t dapl_id;
        } get_dapl;
        struct {
            hid_t dcpl_id;
        } get_dcpl;
        struct {
            hid_t space_id;
        } get_space;
        struct {
            H5D_space_status_t *status;
        } get_space_status;
        struct {
            hsize_t *storage_size;
        } get_storage_size;
        struct {
            hid_t type_id;
        } get_type;
    } args;
} H5VL_dataset_get_args_t;
typedef enum H5VL_dataset_specific_t {
    H5VL_DATASET_SET_EXTENT,
    H5VL_DATASET_FLUSH,
    H5VL_DATASET_REFRESH
} H5VL_dataset_specific_t;
typedef struct H5VL_dataset_specific_args_t {
    H5VL_dataset_specific_t op_type;
    union {
        struct {
            const hsize_t *size;
        } set_extent;
        struct {
            hid_t dset_id;
        } flush;
        struct {
            hid_t dset_id;
        } refresh;
    } args;
} H5VL_dataset_specific_args_t;
typedef int H5VL_dataset_optional_t;
typedef enum H5VL_datatype_get_t {
    H5VL_DATATYPE_GET_BINARY_SIZE,
    H5VL_DATATYPE_GET_BINARY,
    H5VL_DATATYPE_GET_TCPL
} H5VL_datatype_get_t;
typedef struct H5VL_datatype_get_args_t {
    H5VL_datatype_get_t op_type;
    union {
        struct {
            size_t *size;
        } get_binary_size;
        struct {
            void  *buf;
            size_t buf_size;
        } get_binary;
        struct {
            hid_t tcpl_id;
        } get_tcpl;
    } args;
} H5VL_datatype_get_args_t;
typedef enum H5VL_datatype_specific_t {
    H5VL_DATATYPE_FLUSH,
    H5VL_DATATYPE_REFRESH
} H5VL_datatype_specific_t;
typedef struct H5VL_datatype_specific_args_t {
    H5VL_datatype_specific_t op_type;
    union {
        struct {
            hid_t type_id;
        } flush;
        struct {
            hid_t type_id;
        } refresh;
    } args;
} H5VL_datatype_specific_args_t;
typedef int H5VL_datatype_optional_t;
typedef struct H5VL_file_cont_info_t {
    unsigned version;
    uint64_t feature_flags;
    size_t token_size;
    size_t blob_id_size;
} H5VL_file_cont_info_t;
typedef enum H5VL_file_get_t {
    H5VL_FILE_GET_CONT_INFO,
    H5VL_FILE_GET_FAPL,
    H5VL_FILE_GET_FCPL,
    H5VL_FILE_GET_FILENO,
    H5VL_FILE_GET_INTENT,
    H5VL_FILE_GET_NAME,
    H5VL_FILE_GET_OBJ_COUNT,
    H5VL_FILE_GET_OBJ_IDS
} H5VL_file_get_t;
typedef struct H5VL_file_get_name_args_t {
    H5I_type_t type;
    size_t     buf_size;
    char      *buf;
    size_t    *file_name_len;
} H5VL_file_get_name_args_t;
typedef struct H5VL_file_get_obj_ids_args_t {
    unsigned types;
    size_t   max_objs;
    hid_t   *oid_list;
    size_t  *count;
} H5VL_file_get_obj_ids_args_t;
typedef struct H5VL_file_get_args_t {
    H5VL_file_get_t op_type;
    union {
        struct {
            H5VL_file_cont_info_t *info;
        } get_cont_info;
        struct {
            hid_t fapl_id;
        } get_fapl;
        struct {
            hid_t fcpl_id;
        } get_fcpl;
        struct {
            unsigned long *fileno;
        } get_fileno;
        struct {
            unsigned *flags;
        } get_intent;
        H5VL_file_get_name_args_t get_name;
        struct {
            unsigned types;
            size_t  *count;
        } get_obj_count;
        H5VL_file_get_obj_ids_args_t get_obj_ids;
    } args;
} H5VL_file_get_args_t;
typedef enum H5VL_file_specific_t {
    H5VL_FILE_FLUSH,
    H5VL_FILE_REOPEN,
    H5VL_FILE_IS_ACCESSIBLE,
    H5VL_FILE_DELETE,
    H5VL_FILE_IS_EQUAL
} H5VL_file_specific_t;
typedef struct H5VL_file_specific_args_t {
    H5VL_file_specific_t op_type;
    union {
        struct {
            H5I_type_t  obj_type;
            H5F_scope_t scope;
        } flush;
        struct {
            void **file;
        } reopen;
        struct {
            const char *filename;
            hid_t       fapl_id;
            hbool_t    *accessible;
        } is_accessible;
        struct {
            const char *filename;
            hid_t       fapl_id;
        } del;
        struct {
            void    *obj2;
            hbool_t *same_file;
        } is_equal;
    } args;
} H5VL_file_specific_args_t;
typedef int H5VL_file_optional_t;
typedef enum H5VL_group_get_t {
    H5VL_GROUP_GET_GCPL,
    H5VL_GROUP_GET_INFO
} H5VL_group_get_t;
typedef struct H5VL_group_get_info_args_t {
    H5VL_loc_params_t loc_params;
    H5G_info_t       *ginfo;
} H5VL_group_get_info_args_t;
typedef struct H5VL_group_get_args_t {
    H5VL_group_get_t op_type;
    union {
        struct {
            hid_t gcpl_id;
        } get_gcpl;
        H5VL_group_get_info_args_t get_info;
    } args;
} H5VL_group_get_args_t;
typedef enum H5VL_group_specific_t {
    H5VL_GROUP_MOUNT,
    H5VL_GROUP_UNMOUNT,
    H5VL_GROUP_FLUSH,
    H5VL_GROUP_REFRESH
} H5VL_group_specific_t;
typedef struct H5VL_group_spec_mount_args_t {
    const char *name;
    void       *child_file;
    hid_t       fmpl_id;
} H5VL_group_spec_mount_args_t;
typedef struct H5VL_group_specific_args_t {
    H5VL_group_specific_t op_type;
    union {
        H5VL_group_spec_mount_args_t mount;
        struct {
            const char *name;
        } unmount;
        struct {
            hid_t grp_id;
        } flush;
        struct {
            hid_t grp_id;
        } refresh;
    } args;
} H5VL_group_specific_args_t;
typedef int H5VL_group_optional_t;
typedef enum H5VL_link_create_t {
    H5VL_LINK_CREATE_HARD,
    H5VL_LINK_CREATE_SOFT,
    H5VL_LINK_CREATE_UD
} H5VL_link_create_t;
typedef struct H5VL_link_create_args_t {
    H5VL_link_create_t op_type;
    union {
        struct {
            void             *curr_obj;
            H5VL_loc_params_t curr_loc_params;
        } hard;
        struct {
            const char *target;
        } soft;
        struct {
            H5L_type_t  type;
            const void *buf;
            size_t      buf_size;
        } ud;
    } args;
} H5VL_link_create_args_t;
typedef enum H5VL_link_get_t {
    H5VL_LINK_GET_INFO,
    H5VL_LINK_GET_NAME,
    H5VL_LINK_GET_VAL
} H5VL_link_get_t;
typedef struct H5VL_link_get_args_t {
    H5VL_link_get_t op_type;
    union {
        struct {
            H5L_info2_t *linfo;
        } get_info;
        struct {
            size_t  name_size;
            char   *name;
            size_t *name_len;
        } get_name;
        struct {
            size_t buf_size;
            void  *buf;
        } get_val;
    } args;
} H5VL_link_get_args_t;
typedef enum H5VL_link_specific_t {
    H5VL_LINK_DELETE,
    H5VL_LINK_EXISTS,
    H5VL_LINK_ITER
} H5VL_link_specific_t;
typedef struct H5VL_link_iterate_args_t {
    hbool_t         recursive;
    H5_index_t      idx_type;
    H5_iter_order_t order;
    hsize_t        *idx_p;
    H5L_iterate2_t  op;
    void           *op_data;
} H5VL_link_iterate_args_t;
typedef struct H5VL_link_specific_args_t {
    H5VL_link_specific_t op_type;
    union {
        struct {
            hbool_t *exists;
        } exists;
        H5VL_link_iterate_args_t iterate;
    } args;
} H5VL_link_specific_args_t;
typedef int H5VL_link_optional_t;
typedef enum H5VL_object_get_t {
    H5VL_OBJECT_GET_FILE,
    H5VL_OBJECT_GET_NAME,
    H5VL_OBJECT_GET_TYPE,
    H5VL_OBJECT_GET_INFO
} H5VL_object_get_t;
typedef struct H5VL_object_get_args_t {
    H5VL_object_get_t op_type;
    union {
        struct {
            void **file;
        } get_file;
        struct {
            size_t  buf_size;
            char   *buf;
            size_t *name_len;
        } get_name;
        struct {
            H5O_type_t *obj_type;
        } get_type;
        struct {
            unsigned     fields;
            H5O_info2_t *oinfo;
        } get_info;
    } args;
} H5VL_object_get_args_t;
typedef enum H5VL_object_specific_t {
    H5VL_OBJECT_CHANGE_REF_COUNT,
    H5VL_OBJECT_EXISTS,
    H5VL_OBJECT_LOOKUP,
    H5VL_OBJECT_VISIT,
    H5VL_OBJECT_FLUSH,
    H5VL_OBJECT_REFRESH
} H5VL_object_specific_t;
typedef struct H5VL_object_visit_args_t {
    H5_index_t      idx_type;
    H5_iter_order_t order;
    unsigned        fields;
    H5O_iterate2_t  op;
    void           *op_data;
} H5VL_object_visit_args_t;
typedef struct H5VL_object_specific_args_t {
    H5VL_object_specific_t op_type;
    union {
        struct {
            int delta;
        } change_rc;
        struct {
            hbool_t *exists;
        } exists;
        struct {
            H5O_token_t *token_ptr;
        } lookup;
        H5VL_object_visit_args_t visit;
        struct {
            hid_t obj_id;
        } flush;
        struct {
            hid_t obj_id;
        } refresh;
    } args;
} H5VL_object_specific_args_t;
typedef int H5VL_object_optional_t;
typedef enum H5VL_request_status_t {
    H5VL_REQUEST_STATUS_IN_PROGRESS,
    H5VL_REQUEST_STATUS_SUCCEED,
    H5VL_REQUEST_STATUS_FAIL,
    H5VL_REQUEST_STATUS_CANT_CANCEL,
    H5VL_REQUEST_STATUS_CANCELED
} H5VL_request_status_t;
typedef enum H5VL_request_specific_t {
    H5VL_REQUEST_GET_ERR_STACK,
    H5VL_REQUEST_GET_EXEC_TIME
} H5VL_request_specific_t;
typedef struct H5VL_request_specific_args_t {
    H5VL_request_specific_t op_type;
    union {
        struct {
            hid_t err_stack_id;
        } get_err_stack;
        struct {
            uint64_t *exec_ts;
            uint64_t *exec_time;
        } get_exec_time;
    } args;
} H5VL_request_specific_args_t;
typedef int H5VL_request_optional_t;
typedef enum H5VL_blob_specific_t {
    H5VL_BLOB_DELETE,
    H5VL_BLOB_ISNULL,
    H5VL_BLOB_SETNULL
} H5VL_blob_specific_t;
typedef struct H5VL_blob_specific_args_t {
    H5VL_blob_specific_t op_type;
    union {
        struct {
            hbool_t *isnull;
        } is_null;
    } args;
} H5VL_blob_specific_args_t;
typedef int H5VL_blob_optional_t;
typedef struct H5VL_info_class_t {
    size_t size;
    void *(*copy)(const void *info);
    herr_t (*cmp)(int *cmp_value, const void *info1, const void *info2);
    herr_t (*free)(void *info);
    herr_t (*to_str)(const void *info, char **str);
    herr_t (*from_str)(const char *str,
                       void      **info);
} H5VL_info_class_t;
typedef struct H5VL_wrap_class_t {
    void *(*get_object)(const void *obj);
    herr_t (*get_wrap_ctx)(
        const void *obj,
        void      **wrap_ctx);
    void *(*wrap_object)(void *obj, H5I_type_t obj_type,
                         void *wrap_ctx);
    void *(*unwrap_object)(void *obj);
    herr_t (*free_wrap_ctx)(
        void *wrap_ctx);
} H5VL_wrap_class_t;
typedef struct H5VL_attr_class_t {
    void *(*create)(void *obj, const H5VL_loc_params_t *loc_params, const char *attr_name, hid_t type_id,
                    hid_t space_id, hid_t acpl_id, hid_t aapl_id, hid_t dxpl_id, void **req);
    void *(*open)(void *obj, const H5VL_loc_params_t *loc_params, const char *attr_name, hid_t aapl_id,
                  hid_t dxpl_id, void **req);
    herr_t (*read)(void *attr, hid_t mem_type_id, void *buf, hid_t dxpl_id, void **req);
    herr_t (*write)(void *attr, hid_t mem_type_id, const void *buf, hid_t dxpl_id, void **req);
    herr_t (*get)(void *obj, H5VL_attr_get_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*specific)(void *obj, const H5VL_loc_params_t *loc_params, H5VL_attr_specific_args_t *args,
                       hid_t dxpl_id, void **req);
    herr_t (*optional)(void *obj, H5VL_optional_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*close)(void *attr, hid_t dxpl_id, void **req);
} H5VL_attr_class_t;
typedef struct H5VL_dataset_class_t {
    void *(*create)(void *obj, const H5VL_loc_params_t *loc_params, const char *name, hid_t lcpl_id,
                    hid_t type_id, hid_t space_id, hid_t dcpl_id, hid_t dapl_id, hid_t dxpl_id, void **req);
    void *(*open)(void *obj, const H5VL_loc_params_t *loc_params, const char *name, hid_t dapl_id,
                  hid_t dxpl_id, void **req);
    herr_t (*read)(size_t count, void *dset[], hid_t mem_type_id[], hid_t mem_space_id[],
                   hid_t file_space_id[], hid_t dxpl_id, void *buf[], void **req);
    herr_t (*write)(size_t count, void *dset[], hid_t mem_type_id[], hid_t mem_space_id[],
                    hid_t file_space_id[], hid_t dxpl_id, const void *buf[], void **req);
    herr_t (*get)(void *obj, H5VL_dataset_get_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*specific)(void *obj, H5VL_dataset_specific_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*optional)(void *obj, H5VL_optional_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*close)(void *dset, hid_t dxpl_id, void **req);
} H5VL_dataset_class_t;
typedef struct H5VL_datatype_class_t {
    void *(*commit)(void *obj, const H5VL_loc_params_t *loc_params, const char *name, hid_t type_id,
                    hid_t lcpl_id, hid_t tcpl_id, hid_t tapl_id, hid_t dxpl_id, void **req);
    void *(*open)(void *obj, const H5VL_loc_params_t *loc_params, const char *name, hid_t tapl_id,
                  hid_t dxpl_id, void **req);
    herr_t (*get)(void *obj, H5VL_datatype_get_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*specific)(void *obj, H5VL_datatype_specific_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*optional)(void *obj, H5VL_optional_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*close)(void *dt, hid_t dxpl_id, void **req);
} H5VL_datatype_class_t;
typedef struct H5VL_file_class_t {
    void *(*create)(const char *name, unsigned flags, hid_t fcpl_id, hid_t fapl_id, hid_t dxpl_id,
                    void **req);
    void *(*open)(const char *name, unsigned flags, hid_t fapl_id, hid_t dxpl_id, void **req);
    herr_t (*get)(void *obj, H5VL_file_get_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*specific)(void *obj, H5VL_file_specific_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*optional)(void *obj, H5VL_optional_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*close)(void *file, hid_t dxpl_id, void **req);
} H5VL_file_class_t;
typedef struct H5VL_group_class_t {
    void *(*create)(void *obj, const H5VL_loc_params_t *loc_params, const char *name, hid_t lcpl_id,
                    hid_t gcpl_id, hid_t gapl_id, hid_t dxpl_id, void **req);
    void *(*open)(void *obj, const H5VL_loc_params_t *loc_params, const char *name, hid_t gapl_id,
                  hid_t dxpl_id, void **req);
    herr_t (*get)(void *obj, H5VL_group_get_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*specific)(void *obj, H5VL_group_specific_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*optional)(void *obj, H5VL_optional_args_t *args, hid_t dxpl_id, void **req);
    herr_t (*close)(void *grp, hid_t dxpl_id, void **req);
} H5VL_group_class_t;
typedef struct H5VL_link_class_t {
    herr_t (*create)(H5VL_link_create_args_t *args, void *obj, const H5VL_loc_params_t *loc_params,
                     hid_t lcpl_id, hid_t lapl_id, hid_t dxpl_id, void **req);
    herr_t (*copy)(void *src_obj, const H5VL_loc_params_t *loc_params1, void *dst_obj,
                   const H5VL_loc_params_t *loc_params2, hid_t lcpl_id, hid_t lapl_id, hid_t dxpl_id,
                   void **req);
    herr_t (*move)(void *src_obj, const H5VL_loc_params_t *loc_params1, void *dst_obj,
                   const H5VL_loc_params_t *loc_params2, hid_t lcpl_id, hid_t lapl_id, hid_t dxpl_id,
                   void **req);
    herr_t (*get)(void *obj, const H5VL_loc_params_t *loc_params, H5VL_link_get_args_t *args, hid_t dxpl_id,
                  void **req);
    herr_t (*specific)(void *obj, const H5VL_loc_params_t *loc_params, H5VL_link_specific_args_t *args,
                       hid_t dxpl_id, void **req);
    herr_t (*optional)(void *obj, const H5VL_loc_params_t *loc_params, H5VL_optional_args_t *args,
                       hid_t dxpl_id, void **req);
} H5VL_link_class_t;
typedef struct H5VL_object_class_t {
    void *(*open)(void *obj, const H5VL_loc_params_t *loc_params, H5I_type_t *opened_type, hid_t dxpl_id,
                  void **req);
    herr_t (*copy)(void *src_obj, const H5VL_loc_params_t *loc_params1, const char *src_name, void *dst_obj,
                   const H5VL_loc_params_t *loc_params2, const char *dst_name, hid_t ocpypl_id, hid_t lcpl_id,
                   hid_t dxpl_id, void **req);
    herr_t (*get)(void *obj, const H5VL_loc_params_t *loc_params, H5VL_object_get_args_t *args, hid_t dxpl_id,
                  void **req);
    herr_t (*specific)(void *obj, const H5VL_loc_params_t *loc_params, H5VL_object_specific_args_t *args,
                       hid_t dxpl_id, void **req);
    herr_t (*optional)(void *obj, const H5VL_loc_params_t *loc_params, H5VL_optional_args_t *args,
                       hid_t dxpl_id, void **req);
} H5VL_object_class_t;
typedef herr_t (*H5VL_request_notify_t)(void *ctx, H5VL_request_status_t status);
typedef enum H5VL_get_conn_lvl_t {
    H5VL_GET_CONN_LVL_CURR,
    H5VL_GET_CONN_LVL_TERM
} H5VL_get_conn_lvl_t;
struct H5VL_class_t;
typedef struct H5VL_introspect_class_t {
    herr_t (*get_conn_cls)(void *obj, H5VL_get_conn_lvl_t lvl, const struct H5VL_class_t **conn_cls);
    herr_t (*get_cap_flags)(const void *info, uint64_t *cap_flags);
    herr_t (*opt_query)(void *obj, H5VL_subclass_t cls, int opt_type, uint64_t *flags);
} H5VL_introspect_class_t;
typedef struct H5VL_request_class_t {
    herr_t (*wait)(void *req, uint64_t timeout, H5VL_request_status_t *status);
    herr_t (*notify)(void *req, H5VL_request_notify_t cb, void *ctx);
    herr_t (*cancel)(void *req, H5VL_request_status_t *status);
    herr_t (*specific)(void *req, H5VL_request_specific_args_t *args);
    herr_t (*optional)(void *req, H5VL_optional_args_t *args);
    herr_t (*free)(void *req);
} H5VL_request_class_t;
typedef struct H5VL_blob_class_t {
    herr_t (*put)(void *obj, const void *buf, size_t size, void *blob_id, void *ctx);
    herr_t (*get)(void *obj, const void *blob_id, void *buf, size_t size, void *ctx);
    herr_t (*specific)(void *obj, void *blob_id, H5VL_blob_specific_args_t *args);
    herr_t (*optional)(void *obj, void *blob_id, H5VL_optional_args_t *args);
} H5VL_blob_class_t;
typedef struct H5VL_token_class_t {
    herr_t (*cmp)(void *obj, const H5O_token_t *token1, const H5O_token_t *token2, int *cmp_value);
    herr_t (*to_str)(void *obj, H5I_type_t obj_type, const H5O_token_t *token, char **token_str);
    herr_t (*from_str)(void *obj, H5I_type_t obj_type, const char *token_str, H5O_token_t *token);
} H5VL_token_class_t;
//! <!-- [H5VL_class_t_snip] -->
typedef struct H5VL_class_t {
    unsigned           version;
    H5VL_class_value_t value;
    const char        *name;
    unsigned           conn_version;
    uint64_t           cap_flags;
    herr_t (*initialize)(hid_t vipl_id);
    herr_t (*terminate)(void);
    H5VL_info_class_t info_cls;
    H5VL_wrap_class_t wrap_cls;
    H5VL_attr_class_t     attr_cls;
    H5VL_dataset_class_t  dataset_cls;
    H5VL_datatype_class_t datatype_cls;
    H5VL_file_class_t     file_cls;
    H5VL_group_class_t    group_cls;
    H5VL_link_class_t     link_cls;
    H5VL_object_class_t   object_cls;
    H5VL_introspect_class_t introspect_cls;
    H5VL_request_class_t    request_cls;
    H5VL_blob_class_t       blob_cls;
    H5VL_token_class_t      token_cls;
    herr_t (*optional)(void *obj, H5VL_optional_args_t *args, hid_t dxpl_id,
                       void **req);
} H5VL_class_t;
//! <!-- [H5VL_class_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5VLregister_connector(const H5VL_class_t *cls, hid_t vipl_id);
H5_DLL void *H5VLobject(hid_t obj_id);
H5_DLL hid_t H5VLget_file_type(void *file_obj, hid_t connector_id, hid_t dtype_id);
H5_DLL hid_t H5VLpeek_connector_id_by_name(const char *name);
H5_DLL hid_t H5VLpeek_connector_id_by_value(H5VL_class_value_t value);
H5_DLL herr_t H5VLregister_opt_operation(H5VL_subclass_t subcls, const char *op_name, int *op_val);
H5_DLL herr_t H5VLfind_opt_operation(H5VL_subclass_t subcls, const char *op_name, int *op_val);
H5_DLL herr_t H5VLunregister_opt_operation(H5VL_subclass_t subcls, const char *op_name);
H5_DLL herr_t H5VLattr_optional_op(const char *app_file, const char *app_func, unsigned app_line,
                                   hid_t attr_id, H5VL_optional_args_t *args, hid_t dxpl_id, hid_t es_id);
H5_DLL herr_t H5VLdataset_optional_op(const char *app_file, const char *app_func, unsigned app_line,
                                      hid_t dset_id, H5VL_optional_args_t *args, hid_t dxpl_id, hid_t es_id);
H5_DLL herr_t H5VLdatatype_optional_op(const char *app_file, const char *app_func, unsigned app_line,
                                       hid_t type_id, H5VL_optional_args_t *args, hid_t dxpl_id, hid_t es_id);
H5_DLL herr_t H5VLfile_optional_op(const char *app_file, const char *app_func, unsigned app_line,
                                   hid_t file_id, H5VL_optional_args_t *args, hid_t dxpl_id, hid_t es_id);
H5_DLL herr_t H5VLgroup_optional_op(const char *app_file, const char *app_func, unsigned app_line,
                                    hid_t group_id, H5VL_optional_args_t *args, hid_t dxpl_id, hid_t es_id);
H5_DLL herr_t H5VLlink_optional_op(const char *app_file, const char *app_func, unsigned app_line,
                                   hid_t loc_id, const char *name, hid_t lapl_id, H5VL_optional_args_t *args,
                                   hid_t dxpl_id, hid_t es_id);
H5_DLL herr_t H5VLobject_optional_op(const char *app_file, const char *app_func, unsigned app_line,
                                     hid_t loc_id, const char *name, hid_t lapl_id,
                                     H5VL_optional_args_t *args, hid_t dxpl_id, hid_t es_id);
H5_DLL herr_t H5VLrequest_optional_op(void *req, hid_t connector_id, H5VL_optional_args_t *args);
#ifndef H5VL_MODULE
#define H5VLattr_optional_op(...)     H5VLattr_optional_op(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5VLdataset_optional_op(...)  H5VLdataset_optional_op(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5VLdatatype_optional_op(...) H5VLdatatype_optional_op(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5VLfile_optional_op(...)     H5VLfile_optional_op(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5VLgroup_optional_op(...)    H5VLgroup_optional_op(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5VLlink_optional_op(...)     H5VLlink_optional_op(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5VLobject_optional_op(...)   H5VLobject_optional_op(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5VLattr_optional_op_wrap     H5_NO_EXPAND(H5VLattr_optional_op)
#define H5VLdataset_optional_op_wrap  H5_NO_EXPAND(H5VLdataset_optional_op)
#define H5VLdatatype_optional_op_wrap H5_NO_EXPAND(H5VLdatatype_optional_op)
#define H5VLfile_optional_op_wrap     H5_NO_EXPAND(H5VLfile_optional_op)
#define H5VLgroup_optional_op_wrap    H5_NO_EXPAND(H5VLgroup_optional_op)
#define H5VLlink_optional_op_wrap     H5_NO_EXPAND(H5VLlink_optional_op)
#define H5VLobject_optional_op_wrap   H5_NO_EXPAND(H5VLobject_optional_op)
#endif
#ifdef __cplusplus
}
#endif
#endif
