% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{gen.input}
\alias{gen.input}
\title{Generating Haar wavelet transformation of time series}
\usage{
gen.input(x, scales, sq, diag, sgn = NULL)
}
\arguments{
\item{x}{input data matrix, with each row representing the component time series}

\item{scales}{negative integers for wavelet scales, with a small negative integer representing a fine scale}

\item{sq}{if \code{sq = TRUE}, squared root of wavelet periodograms are used for change-point analysis}

\item{diag}{if \code{diag = TRUE}, only changes in the diagonal elements of the autocovariance matrices are searched for}

\item{sgn}{if \code{diag = FALSE}, wavelet transformations of the cross-covariances are computed with the matching signs}
}
\value{
matrix of the square root of scaled Haar wavelet periodograms of \code{x}
}
\description{
Generate Haar wavelet transformation of time series containing information about possible change-points in the second-order structure of time series
}
\keyword{internal}
