% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvrnorm_cpp.R
\name{mvrnorm_cpp}
\alias{mvrnorm_cpp}
\title{Multivariate Normal Random Number Generator}
\usage{
mvrnorm_cpp(n = 1, mu, Sigma)
}
\arguments{
\item{n}{The number of random samples to generate. Defaults to 1.}

\item{mu}{The mean vector of the distribution.}

\item{Sigma}{The covariance matrix of the distribution.}
}
\value{
A numeric matrix where each row is a random sample from the multivariate normal distribution.
}
\description{
Generates random numbers from a multivariate normal distribution with specified mean and covariance matrix using a C++ implementation.
}
\examples{
# Example usage
mu <- c(0, 0)
Sigma <- matrix(c(1, 0.5, 0.5, 1), 2, 2)
mvrnorm_cpp(5, mu, Sigma)

}
