% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simKHCE.R
\name{simKHCE}
\alias{simKHCE}
\title{Simulate a kidney disease \code{hce} dataset}
\usage{
simKHCE(
  n,
  CM_A,
  CM_P = -4,
  n0 = n,
  TTE_A = 10,
  TTE_P = TTE_A,
  fixedfy = 2,
  Emin = 20,
  Emax = 100,
  sigma = 8,
  Sigma = 3,
  m = 10,
  theta = -0.23,
  phi = 0
)
}
\arguments{
\item{n}{sample size in the active treatment group.}

\item{CM_A}{annualized eGFR slope in the active group.}

\item{CM_P}{annualized eGFR slope in the control group.}

\item{n0}{sample size in the control treatment group.}

\item{TTE_A}{event rate per year in the active group for KFRT.}

\item{TTE_P}{event rate per year in the placebo group for KFRT.}

\item{fixedfy}{length of follow-up in years.}

\item{Emin}{lower limit of eGFR at baseline.}

\item{Emax}{upper limit of eGFR at baseline.}

\item{sigma}{within-patient standard deviation.}

\item{Sigma}{between-patient standard deviation.}

\item{m}{number of equidistant visits.}

\item{theta}{coefficient of dependence of eGFR values and the risk of KFRT.}

\item{phi}{coefficient of proportionality (between 0 and 1) of the treatment effect. The case of 0 corresponds to the uniform treatment effect.}
}
\value{
a list containing the dataset \code{GFR} for longitudinal measurements of eGFR and the competing KFRT events, the dataset \code{ADET} for the time-to-event kidney outcomes (sustained declines or sustained low levels of eGFR), and the combined \code{HCE} dataset for the kidney hierarhical composite endpoint.
}
\description{
Simulate a kidney disease \code{hce} dataset, capturing eGFR (Estimated Glomerular Filtration Rate) progression over time, along with
a competing and dependent terminal event: KFRT (Kidney Failure Replacement Therapy)
}
\examples{
# Example 1
set.seed(2022)
L <- simKHCE(n = 1000, CM_A = -3.25)
dat <- L$HCE
calcWO(dat)
}
\seealso{
\code{\link[=simHCE]{simHCE()}} for a general function of simulating \code{hce} datasets.
}
