% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propWINS.R
\name{propWINS}
\alias{propWINS}
\title{Proportion of wins/losses/ties given the win odds and the win ratio}
\usage{
propWINS(WO, WR, Overall = 1)
}
\arguments{
\item{WO}{win odds.}

\item{WR}{win ratio.}

\item{Overall}{number of comparisons, the sample size of
the active treatment multiplied by the sample size of the placebo.
The default is 1, hence gives the proportion.}
}
\value{
a data frame with a number (or proportion if \code{Overall = 1}) of wins/losses/ties.
}
\description{
Proportion of wins/losses/ties given the win odds and the win ratio
}
\details{
\figure{propWINS.png}{Calculation formula}
}
\examples{
# Example 1
propWINS(WR = 2, WO = 1.5)
# Example 2 - Back-calculation 
COVID19HCE <- hce(GROUP = COVID19$GROUP, TRTP = COVID19$TRTP)
res <- calcWINS(COVID19HCE)
WR <- res$WR1$WR
WO <- res$WO$WO
Overall <- res$summary$TOTAL
propWINS(WR = WR, WO = WO, Overall = Overall)
## Verify 
res$summary
}
