% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/papers_laid.R
\name{papers_laid}
\alias{papers_laid}
\alias{hansard_papers_laid}
\title{Papers laid}
\usage{
papers_laid(withdrawn = FALSE, house = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case", verbose = FALSE)

hansard_papers_laid(withdrawn = FALSE, house = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = FALSE)
}
\arguments{
\item{withdrawn}{If \code{TRUE}, only returns withdrawn papers. Defaults to \code{FALSE}.}

\item{house}{The house the paper was laid in. Accepts \code{'commons'} and \code{'lords'}. If \code{NULL}, returns both House of Commons and House of Lords. This parameter is case-insensitive. Defaults to \code{NULL}.}

\item{start_date}{Only includes papers laid before the House on or after this date. Accepts character values in \code{'YYYY-MM-DD'} format, and objects of class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything else than can be coerced to a date with \code{as.Date()}. Defaults to \code{'1900-01-01'}.}

\item{end_date}{Only includes papers laid before the House on or before this date. Accepts character values in \code{'YYYY-MM-DD'} format, and objects of class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything else than can be coerced to a date with \code{as.Date()}. Defaults to the current system date.}

\item{extra_args}{Additional parameters to pass to API. See the \href{http://explore.data.parliament.uk/}{API documentation} or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if \code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'} and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, returns data to console on the progress of the API request. Defaults to \code{FALSE}.}
}
\value{
A tibble with details on papers laid before the given House.
}
\description{
Imports data on papers laid before the House.
}
\examples{
\dontrun{
x <- papers_laid(withdrawn = FALSE, house = 'commons')

x <- papers_laid(withdrawn = TRUE, house = NULL)
}
}
