% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{plotLetter}
\alias{plotLetter}
\title{Plot Letter}
\usage{
plotLetter(
  doc,
  whichLetter,
  showPaths = TRUE,
  showCentroid = TRUE,
  showSlope = TRUE,
  showNodes = TRUE
)
}
\arguments{
\item{doc}{A document processed with \code{\link[=processHandwriting]{processHandwriting()}} or \code{\link[=processDocument]{processDocument()}}}

\item{whichLetter}{Single value in 1:length(letterList) denoting which letter
to plot.}

\item{showPaths}{Whether the calculated paths on the letter should be shown
with numbers.}

\item{showCentroid}{Whether the centroid should be shown}

\item{showSlope}{Whether the slope should be shown}

\item{showNodes}{Whether the nodes should be shown}
}
\value{
Plot of single letter.
}
\description{
This function returns a plot of a single graph extracted from a document. It
uses the letterList parameter from the \code{\link[=processHandwriting]{processHandwriting()}} or \code{\link[=processDocument]{processDocument()}} function and
accepts a single value as \code{whichLetter}. Dims requires the dimensions of the
entire document, since this isn't contained in \code{\link[=processHandwriting]{processHandwriting()}} or \code{\link[=processDocument]{processDocument()}}.
}
\examples{
twoSent_document = list()
twoSent_document$image = twoSent
twoSent_document$thin = thinImage(twoSent_document$image)
twoSent_document$process = processHandwriting(twoSent_document$thin, dim(twoSent_document$image))
plotLetter(twoSent_document, 1)
plotLetter(twoSent_document, 4, showPaths = FALSE)

}
