% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_gradient_flow.R
\name{analysis_gradient_flow}
\alias{analysis_gradient_flow}
\title{analysis_gradient_flow}
\usage{
analysis_gradient_flow(path, outputbasename, basename = "gradflow",
  read.data = TRUE, pl = FALSE, plotsize = 4, skip = 0, start = 0,
  scale = 1, dbg = FALSE)
}
\arguments{
\item{path}{string. path to data files}

\item{outputbasename}{string. basename of output files}

\item{basename}{string. basename of input files, for example "gradflow"}

\item{read.data}{boolean. Indicates whether to read data fresh from
data files or to use \code{basename.raw.gradflow.Rdata} instead}

\item{pl}{boolean. If set to \code{TRUE} plots will be generated}

\item{plotsize}{numeric. Plot sidelength, this is passed to
\code{tikz.init}.}

\item{skip}{integer. number of measurements to skip}

\item{start}{integer. start value for time}

\item{scale}{numeric. scale factor for the MD time, should be set to
the stridelength (in units of trajectories or configurations)
which was used to produce the gradient flow files, such that
the distance between measurements can be interpreted
correctly and the reported autocorrelation times scaled appropriately.}

\item{dbg}{boolean. If set to \code{TRUE} debugging output will be provided.}
}
\value{
Nothing is returned.
}
\description{
function to analyse the gradient flow output files generated by
the tmLQCD software, see references.
}
\references{
K. Jansen and C. Urbach, Comput.Phys.Commun. 180 (2009) 2717-2738
}
