% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgrm.R
\name{hgrm}
\alias{hgrm}
\title{Fitting Hierarchical Graded Response Models}
\usage{
hgrm(y, x = matrix(1, nrow(y), 1), z = matrix(1, nrow(y), 1),
  beta_set = 1, sign_set = TRUE, control = list())
}
\arguments{
\item{y}{A data frame or matrix of item responses.}

\item{x}{A matrix of covariates, including intercept, that predict the
mean of the latent preference.}

\item{z}{A matrix of covariates, including intercept, that predict the
variance of the latent preference.}

\item{beta_set}{The index of the item whose discrimination parameter is
restricted to be positive (or negative). It may take an integer value from
1 to \code{ncol(y)}.}

\item{sign_set}{Logical. Should the discrimination parameter of
the corresponding item (indexed by \code{beta_set}) be positive
(if \code{TRUE}) or negative (if \code{FALSE})?}

\item{control}{A list of control values
\describe{
 \item{max_iter}{The maximum number of iterations of the EM algorithm.
   Default 150.}
 \item{eps}{Tolerance parameter used to determine convergence of the
  EM algorithm. Specifically, iterations continue until the Euclidean
  distance between \eqn{\beta_{n}} and \eqn{\beta_{n-1}} falls under \code{eps},
  where \eqn{\beta} is the vector of item discrimination parameters.
  \code{eps}=1e-4 by default.}
 \item{max_iter2}{The maximum number of iterations of the conditional
   maximization procedures for updating \eqn{\gamma} and \eqn{\lambda}.
   Default 15.}
 \item{eps2}{Tolerance parameter used to determine convergence of the
   conditional maximization procedures for updating \eqn{\gamma} and
   \eqn{\lambda}. Specifically, iterations continue until the Euclidean
  distance between two consecutive log likelihoods falls under \code{eps2}.
  \code{eps2}=1e-3 by default.}
 \item{K}{Number of Gauss-Legendre quadrature points for the E-step. Default 21.}
 \item{C}{[-C, C] sets the range of integral in the E-step. \code{C}=5 by default.}
}}
}
\value{
An object of class \code{hgrm}.
 \item{coefficients}{A data frame of parameter estimates, standard errors,
  z values and p values.}
 \item{scores}{A data frame of EAP estimates of latent preferences and
  their approximate standard errors.}
 \item{vcov}{Variance-covariance matrix of parameter estimates.}
 \item{log_Lik}{The log-likelihood value at convergence.}
 \item{H}{A vector denoting the number of response categories for each item.}
 \item{p}{The number of predictors for the mean equation.}
 \item{q}{The number of predictors for the variance equation.}
 \item{item_names}{Names of items.}
 \item{call}{The matched call.}
}
\description{
\code{hgrm} fits a hierarchical graded response model in which both
the mean and the variance of the latent preference (ability parameter)
may depend on person-specific covariates (\code{x} and \code{z}).
Specifically, the mean is specified as a linear combination of \code{x}
and the log of the variance is specified as a linear combination of
\code{z}. Nonresponses are treated as missing at random.
}
\examples{
y <- nes_econ2008[, -(1:3)]
x <- model.matrix( ~ party * educ, nes_econ2008)
z <- model.matrix( ~ party, nes_econ2008)
nes_m1 <- hgrm(y, x, z)
print(nes_m1)
}
\references{
Zhou, Xiang. 2017. "Hierarchical Item Response Models for Analyzing Public Opinion."
  Working Paper.
}
