/*
    hBayesDM is distributed under the terms of the GNU General Public 
    License but without any warranty. See the GNU General Public 
    License for more details.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_bandit2arm_delta_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_bandit2arm_delta : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > choice;
    vector<vector<double> > rewlos;
    vector_d initV;
public:
    model_bandit2arm_delta(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_bandit2arm_delta(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_bandit2arm_delta_namespace::model_bandit2arm_delta";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
        validate_non_negative_index("choice", "N", N);
        validate_non_negative_index("choice", "T", T);
        choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("choice");
        pos__ = 0;
        size_t choice_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
            size_t choice_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                choice[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "rewlos", "double", context__.to_vec(N,T));
        validate_non_negative_index("rewlos", "N", N);
        validate_non_negative_index("rewlos", "T", T);
        rewlos = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("rewlos");
        pos__ = 0;
        size_t rewlos_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < rewlos_limit_1__; ++i_1__) {
            size_t rewlos_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < rewlos_limit_0__; ++i_0__) {
                rewlos[i_0__][i_1__] = vals_r__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
                check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],2);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "2", 2);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(2));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,2));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 2;
        num_params_r__ += 2;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_bandit2arm_delta() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(2));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(2));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("A_pr")))
            throw std::runtime_error("variable A_pr missing");
        vals_r__ = context__.vals_r("A_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "A_pr", "vector_d", context__.to_vec(N));
        // generate_declaration A_pr
        vector_d A_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            A_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(A_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable A_pr: ") + e.what());
        }

        if (!(context__.contains_r("tau_pr")))
            throw std::runtime_error("variable tau_pr missing");
        vals_r__ = context__.vals_r("tau_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau_pr", "vector_d", context__.to_vec(N));
        // generate_declaration tau_pr
        vector_d tau_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(2,lp__);
        else
            mu_p = in__.vector_constrain(2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,2,lp__);
        else
            sigma = in__.vector_lb_constrain(0,2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  A_pr;
        (void) A_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            A_pr = in__.vector_constrain(N,lp__);
        else
            A_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau_pr;
        (void) tau_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            tau_pr = in__.vector_constrain(N,lp__);
        else
            tau_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  A(static_cast<Eigen::VectorXd::Index>(N));
        (void) A;  // dummy to suppress unused var warning
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(A,i,"A",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))));
                stan::math::assign(get_base1_lhs(tau,i,"tau",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(A(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: A" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(tau(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"A",A,0);
        check_less_or_equal(function__,"A",A,1);
        check_greater_or_equal(function__,"tau",tau,0);
        check_less_or_equal(function__,"tau",tau,5);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(A_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(tau_pr, 0, 1));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, DUMMY_VAR__);
                    stan::math::fill(ev,DUMMY_VAR__);
                    T__ PE;
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, DUMMY_VAR__);
                    stan::math::fill(PE,DUMMY_VAR__);


                    stan::math::assign(ev, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        lp_accum__.add(categorical_logit_log<propto__>(get_base1(get_base1(choice,i,"choice",1),t,"choice",2), multiply(get_base1(tau,i,"tau",1),ev)));
                        stan::math::assign(PE, (get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2) - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1), (get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1) + (get_base1(A,i,"A",1) * PE)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("A_pr");
        names__.push_back("tau_pr");
        names__.push_back("A");
        names__.push_back("tau");
        names__.push_back("mu_A");
        names__.push_back("mu_tau");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_bandit2arm_delta_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(2);
        vector_d sigma = in__.vector_lb_constrain(0,2);
        vector_d A_pr = in__.vector_constrain(N);
        vector_d tau_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d A(static_cast<Eigen::VectorXd::Index>(N));
        (void) A;  // dummy to suppress unused var warning
        stan::math::initialize(A, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(A,DUMMY_VAR__);
        vector_d tau(static_cast<Eigen::VectorXd::Index>(N));
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(A,i,"A",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))));
                stan::math::assign(get_base1_lhs(tau,i,"tau",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"A",A,0);
        check_less_or_equal(function__,"A",A,1);
        check_greater_or_equal(function__,"tau",tau,0);
        check_less_or_equal(function__,"tau",tau,5);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_A(0.0);
        (void) mu_A;  // dummy to suppress unused var warning
        stan::math::initialize(mu_A, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_A,DUMMY_VAR__);
        double mu_tau(0.0);
        (void) mu_tau;  // dummy to suppress unused var warning
        stan::math::initialize(mu_tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_tau,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_A, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_tau, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 5));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d ev(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev,DUMMY_VAR__);
                    double PE(0.0);
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(PE,DUMMY_VAR__);


                    stan::math::assign(ev, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + categorical_logit_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),multiply(get_base1(tau,i,"tau",1),ev))));
                        stan::math::assign(PE, (get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2) - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1), (get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1) + (get_base1(A,i,"A",1) * PE)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_A",mu_A,0);
        check_less_or_equal(function__,"mu_A",mu_A,1);
        check_greater_or_equal(function__,"mu_tau",mu_tau,0);
        check_less_or_equal(function__,"mu_tau",mu_tau,5);

        // write generated quantities
        vars__.push_back(mu_A);
        vars__.push_back(mu_tau);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_bandit2arm_delta";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_dd_cs_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_dd_cs : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > delay_later;
    vector<vector<double> > amount_later;
    vector<vector<double> > delay_sooner;
    vector<vector<double> > amount_sooner;
    vector<vector<int> > choice;
public:
    model_dd_cs(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_dd_cs(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_dd_cs_namespace::model_dd_cs";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "delay_later", "double", context__.to_vec(N,T));
        validate_non_negative_index("delay_later", "N", N);
        validate_non_negative_index("delay_later", "T", T);
        delay_later = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("delay_later");
        pos__ = 0;
        size_t delay_later_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < delay_later_limit_1__; ++i_1__) {
            size_t delay_later_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < delay_later_limit_0__; ++i_0__) {
                delay_later[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "amount_later", "double", context__.to_vec(N,T));
        validate_non_negative_index("amount_later", "N", N);
        validate_non_negative_index("amount_later", "T", T);
        amount_later = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("amount_later");
        pos__ = 0;
        size_t amount_later_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < amount_later_limit_1__; ++i_1__) {
            size_t amount_later_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < amount_later_limit_0__; ++i_0__) {
                amount_later[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "delay_sooner", "double", context__.to_vec(N,T));
        validate_non_negative_index("delay_sooner", "N", N);
        validate_non_negative_index("delay_sooner", "T", T);
        delay_sooner = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("delay_sooner");
        pos__ = 0;
        size_t delay_sooner_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < delay_sooner_limit_1__; ++i_1__) {
            size_t delay_sooner_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < delay_sooner_limit_0__; ++i_0__) {
                delay_sooner[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "amount_sooner", "double", context__.to_vec(N,T));
        validate_non_negative_index("amount_sooner", "N", N);
        validate_non_negative_index("amount_sooner", "T", T);
        amount_sooner = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("amount_sooner");
        pos__ = 0;
        size_t amount_sooner_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < amount_sooner_limit_1__; ++i_1__) {
            size_t amount_sooner_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < amount_sooner_limit_0__; ++i_0__) {
                amount_sooner[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
        validate_non_negative_index("choice", "N", N);
        validate_non_negative_index("choice", "T", T);
        choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("choice");
        pos__ = 0;
        size_t choice_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
            size_t choice_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                choice[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"delay_later[k0__][k1__]",delay_later[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"amount_later[k0__][k1__]",amount_later[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"delay_sooner[k0__][k1__]",delay_sooner[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"amount_sooner[k0__][k1__]",amount_sooner[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],0);
                check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
            }
        }
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 3;
        num_params_r__ += 3;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_dd_cs() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(3));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("r_pr")))
            throw std::runtime_error("variable r_pr missing");
        vals_r__ = context__.vals_r("r_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "r_pr", "vector_d", context__.to_vec(N));
        // generate_declaration r_pr
        vector_d r_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            r_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(r_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable r_pr: ") + e.what());
        }

        if (!(context__.contains_r("s_pr")))
            throw std::runtime_error("variable s_pr missing");
        vals_r__ = context__.vals_r("s_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "s_pr", "vector_d", context__.to_vec(N));
        // generate_declaration s_pr
        vector_d s_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            s_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(s_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable s_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        // generate_declaration beta_pr
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(3,lp__);
        else
            mu_p = in__.vector_constrain(3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,3,lp__);
        else
            sigma = in__.vector_lb_constrain(0,3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  r_pr;
        (void) r_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            r_pr = in__.vector_constrain(N,lp__);
        else
            r_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  s_pr;
        (void) s_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            s_pr = in__.vector_constrain(N,lp__);
        else
            s_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_pr;
        (void) beta_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_pr = in__.vector_constrain(N,lp__);
        else
            beta_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  r(static_cast<Eigen::VectorXd::Index>(N));
        (void) r;  // dummy to suppress unused var warning
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  s(static_cast<Eigen::VectorXd::Index>(N));
        (void) s;  // dummy to suppress unused var warning
        stan::math::initialize(s, DUMMY_VAR__);
        stan::math::fill(s,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(r,i,"r",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(r_pr,i,"r_pr",1)))));
                stan::math::assign(get_base1_lhs(s,i,"s",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(s_pr,i,"s_pr",1)))) * 10));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(r(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: r" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(s(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: s" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"r",r,0);
        check_less_or_equal(function__,"r",r,1);
        check_greater_or_equal(function__,"s",s,0);
        check_less_or_equal(function__,"s",s,10);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,5);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(r_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(s_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            for (int i = 1; i <= N; ++i) {
                {
                    T__ ev_later;
                    (void) ev_later;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_later, DUMMY_VAR__);
                    stan::math::fill(ev_later,DUMMY_VAR__);
                    T__ ev_sooner;
                    (void) ev_sooner;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_sooner, DUMMY_VAR__);
                    stan::math::fill(ev_sooner,DUMMY_VAR__);


                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(ev_later, (get_base1(get_base1(amount_later,i,"amount_later",1),t,"amount_later",2) * exp((-(1) * pow((get_base1(r,i,"r",1) * get_base1(get_base1(delay_later,i,"delay_later",1),t,"delay_later",2)),get_base1(s,i,"s",1))))));
                        stan::math::assign(ev_sooner, (get_base1(get_base1(amount_sooner,i,"amount_sooner",1),t,"amount_sooner",2) * exp((-(1) * pow((get_base1(r,i,"r",1) * get_base1(get_base1(delay_sooner,i,"delay_sooner",1),t,"delay_sooner",2)),get_base1(s,i,"s",1))))));
                        lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(get_base1(choice,i,"choice",1),t,"choice",2), (get_base1(beta,i,"beta",1) * (ev_later - ev_sooner))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("r_pr");
        names__.push_back("s_pr");
        names__.push_back("beta_pr");
        names__.push_back("r");
        names__.push_back("s");
        names__.push_back("beta");
        names__.push_back("mu_r");
        names__.push_back("mu_s");
        names__.push_back("mu_beta");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_dd_cs_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d r_pr = in__.vector_constrain(N);
        vector_d s_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(r_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(s_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d r(static_cast<Eigen::VectorXd::Index>(N));
        (void) r;  // dummy to suppress unused var warning
        stan::math::initialize(r, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(r,DUMMY_VAR__);
        vector_d s(static_cast<Eigen::VectorXd::Index>(N));
        (void) s;  // dummy to suppress unused var warning
        stan::math::initialize(s, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(s,DUMMY_VAR__);
        vector_d beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(r,i,"r",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(r_pr,i,"r_pr",1)))));
                stan::math::assign(get_base1_lhs(s,i,"s",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(s_pr,i,"s_pr",1)))) * 10));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"r",r,0);
        check_less_or_equal(function__,"r",r,1);
        check_greater_or_equal(function__,"s",s,0);
        check_less_or_equal(function__,"s",s,10);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,5);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(r[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(s[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_r(0.0);
        (void) mu_r;  // dummy to suppress unused var warning
        stan::math::initialize(mu_r, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_r,DUMMY_VAR__);
        double mu_s(0.0);
        (void) mu_s;  // dummy to suppress unused var warning
        stan::math::initialize(mu_s, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_s,DUMMY_VAR__);
        double mu_beta(0.0);
        (void) mu_beta;  // dummy to suppress unused var warning
        stan::math::initialize(mu_beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_beta,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_r, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_s, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 10));
            stan::math::assign(mu_beta, (Phi_approx(get_base1(mu_p,3,"mu_p",1)) * 5));

            for (int i = 1; i <= N; ++i) {
                {
                    double ev_later(0.0);
                    (void) ev_later;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_later, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev_later,DUMMY_VAR__);
                    double ev_sooner(0.0);
                    (void) ev_sooner;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_sooner, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev_sooner,DUMMY_VAR__);


                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(ev_later, (get_base1(get_base1(amount_later,i,"amount_later",1),t,"amount_later",2) * exp((-(1) * pow((get_base1(r,i,"r",1) * get_base1(get_base1(delay_later,i,"delay_later",1),t,"delay_later",2)),get_base1(s,i,"s",1))))));
                        stan::math::assign(ev_sooner, (get_base1(get_base1(amount_sooner,i,"amount_sooner",1),t,"amount_sooner",2) * exp((-(1) * pow((get_base1(r,i,"r",1) * get_base1(get_base1(delay_sooner,i,"delay_sooner",1),t,"delay_sooner",2)),get_base1(s,i,"s",1))))));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_logit_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),(get_base1(beta,i,"beta",1) * (ev_later - ev_sooner)))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_r",mu_r,0);
        check_less_or_equal(function__,"mu_r",mu_r,1);
        check_greater_or_equal(function__,"mu_s",mu_s,0);
        check_less_or_equal(function__,"mu_s",mu_s,10);
        check_greater_or_equal(function__,"mu_beta",mu_beta,0);
        check_less_or_equal(function__,"mu_beta",mu_beta,5);

        // write generated quantities
        vars__.push_back(mu_r);
        vars__.push_back(mu_s);
        vars__.push_back(mu_beta);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_dd_cs";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "s_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "s" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_r";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_s";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "s_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "s" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_r";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_s";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_dd_exp_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_dd_exp : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > delay_later;
    vector<vector<double> > amount_later;
    vector<vector<double> > delay_sooner;
    vector<vector<double> > amount_sooner;
    vector<vector<int> > choice;
public:
    model_dd_exp(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_dd_exp(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_dd_exp_namespace::model_dd_exp";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "delay_later", "double", context__.to_vec(N,T));
        validate_non_negative_index("delay_later", "N", N);
        validate_non_negative_index("delay_later", "T", T);
        delay_later = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("delay_later");
        pos__ = 0;
        size_t delay_later_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < delay_later_limit_1__; ++i_1__) {
            size_t delay_later_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < delay_later_limit_0__; ++i_0__) {
                delay_later[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "amount_later", "double", context__.to_vec(N,T));
        validate_non_negative_index("amount_later", "N", N);
        validate_non_negative_index("amount_later", "T", T);
        amount_later = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("amount_later");
        pos__ = 0;
        size_t amount_later_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < amount_later_limit_1__; ++i_1__) {
            size_t amount_later_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < amount_later_limit_0__; ++i_0__) {
                amount_later[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "delay_sooner", "double", context__.to_vec(N,T));
        validate_non_negative_index("delay_sooner", "N", N);
        validate_non_negative_index("delay_sooner", "T", T);
        delay_sooner = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("delay_sooner");
        pos__ = 0;
        size_t delay_sooner_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < delay_sooner_limit_1__; ++i_1__) {
            size_t delay_sooner_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < delay_sooner_limit_0__; ++i_0__) {
                delay_sooner[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "amount_sooner", "double", context__.to_vec(N,T));
        validate_non_negative_index("amount_sooner", "N", N);
        validate_non_negative_index("amount_sooner", "T", T);
        amount_sooner = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("amount_sooner");
        pos__ = 0;
        size_t amount_sooner_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < amount_sooner_limit_1__; ++i_1__) {
            size_t amount_sooner_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < amount_sooner_limit_0__; ++i_0__) {
                amount_sooner[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
        validate_non_negative_index("choice", "N", N);
        validate_non_negative_index("choice", "T", T);
        choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("choice");
        pos__ = 0;
        size_t choice_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
            size_t choice_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                choice[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"delay_later[k0__][k1__]",delay_later[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"amount_later[k0__][k1__]",amount_later[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"delay_sooner[k0__][k1__]",delay_sooner[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"amount_sooner[k0__][k1__]",amount_sooner[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],0);
                check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
            }
        }
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 2;
        num_params_r__ += 2;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_dd_exp() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(2));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(2));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("r_pr")))
            throw std::runtime_error("variable r_pr missing");
        vals_r__ = context__.vals_r("r_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "r_pr", "vector_d", context__.to_vec(N));
        // generate_declaration r_pr
        vector_d r_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            r_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(r_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable r_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        // generate_declaration beta_pr
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(2,lp__);
        else
            mu_p = in__.vector_constrain(2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,2,lp__);
        else
            sigma = in__.vector_lb_constrain(0,2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  r_pr;
        (void) r_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            r_pr = in__.vector_constrain(N,lp__);
        else
            r_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_pr;
        (void) beta_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_pr = in__.vector_constrain(N,lp__);
        else
            beta_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  r(static_cast<Eigen::VectorXd::Index>(N));
        (void) r;  // dummy to suppress unused var warning
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(r,i,"r",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(r_pr,i,"r_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(r(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: r" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"r",r,0);
        check_less_or_equal(function__,"r",r,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,5);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(r_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            for (int i = 1; i <= N; ++i) {
                {
                    T__ ev_later;
                    (void) ev_later;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_later, DUMMY_VAR__);
                    stan::math::fill(ev_later,DUMMY_VAR__);
                    T__ ev_sooner;
                    (void) ev_sooner;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_sooner, DUMMY_VAR__);
                    stan::math::fill(ev_sooner,DUMMY_VAR__);


                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(ev_later, (get_base1(get_base1(amount_later,i,"amount_later",1),t,"amount_later",2) * exp(((-(1) * get_base1(r,i,"r",1)) * get_base1(get_base1(delay_later,i,"delay_later",1),t,"delay_later",2)))));
                        stan::math::assign(ev_sooner, (get_base1(get_base1(amount_sooner,i,"amount_sooner",1),t,"amount_sooner",2) * exp(((-(1) * get_base1(r,i,"r",1)) * get_base1(get_base1(delay_sooner,i,"delay_sooner",1),t,"delay_sooner",2)))));
                        lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(get_base1(choice,i,"choice",1),t,"choice",2), (get_base1(beta,i,"beta",1) * (ev_later - ev_sooner))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("r_pr");
        names__.push_back("beta_pr");
        names__.push_back("r");
        names__.push_back("beta");
        names__.push_back("mu_r");
        names__.push_back("mu_beta");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_dd_exp_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(2);
        vector_d sigma = in__.vector_lb_constrain(0,2);
        vector_d r_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(r_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d r(static_cast<Eigen::VectorXd::Index>(N));
        (void) r;  // dummy to suppress unused var warning
        stan::math::initialize(r, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(r,DUMMY_VAR__);
        vector_d beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(r,i,"r",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(r_pr,i,"r_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"r",r,0);
        check_less_or_equal(function__,"r",r,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,5);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(r[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_r(0.0);
        (void) mu_r;  // dummy to suppress unused var warning
        stan::math::initialize(mu_r, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_r,DUMMY_VAR__);
        double mu_beta(0.0);
        (void) mu_beta;  // dummy to suppress unused var warning
        stan::math::initialize(mu_beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_beta,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_r, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_beta, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 5));

            for (int i = 1; i <= N; ++i) {
                {
                    double ev_later(0.0);
                    (void) ev_later;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_later, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev_later,DUMMY_VAR__);
                    double ev_sooner(0.0);
                    (void) ev_sooner;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_sooner, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev_sooner,DUMMY_VAR__);


                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(ev_later, (get_base1(get_base1(amount_later,i,"amount_later",1),t,"amount_later",2) * exp(((-(1) * get_base1(r,i,"r",1)) * get_base1(get_base1(delay_later,i,"delay_later",1),t,"delay_later",2)))));
                        stan::math::assign(ev_sooner, (get_base1(get_base1(amount_sooner,i,"amount_sooner",1),t,"amount_sooner",2) * exp(((-(1) * get_base1(r,i,"r",1)) * get_base1(get_base1(delay_sooner,i,"delay_sooner",1),t,"delay_sooner",2)))));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_logit_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),(get_base1(beta,i,"beta",1) * (ev_later - ev_sooner)))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_r",mu_r,0);
        check_less_or_equal(function__,"mu_r",mu_r,1);
        check_greater_or_equal(function__,"mu_beta",mu_beta,0);
        check_less_or_equal(function__,"mu_beta",mu_beta,5);

        // write generated quantities
        vars__.push_back(mu_r);
        vars__.push_back(mu_beta);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_dd_exp";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_r";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_r";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_dd_hyperbolic_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_dd_hyperbolic : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > delay_later;
    vector<vector<double> > amount_later;
    vector<vector<double> > delay_sooner;
    vector<vector<double> > amount_sooner;
    vector<vector<int> > choice;
public:
    model_dd_hyperbolic(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_dd_hyperbolic(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_dd_hyperbolic_namespace::model_dd_hyperbolic";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "delay_later", "double", context__.to_vec(N,T));
        validate_non_negative_index("delay_later", "N", N);
        validate_non_negative_index("delay_later", "T", T);
        delay_later = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("delay_later");
        pos__ = 0;
        size_t delay_later_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < delay_later_limit_1__; ++i_1__) {
            size_t delay_later_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < delay_later_limit_0__; ++i_0__) {
                delay_later[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "amount_later", "double", context__.to_vec(N,T));
        validate_non_negative_index("amount_later", "N", N);
        validate_non_negative_index("amount_later", "T", T);
        amount_later = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("amount_later");
        pos__ = 0;
        size_t amount_later_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < amount_later_limit_1__; ++i_1__) {
            size_t amount_later_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < amount_later_limit_0__; ++i_0__) {
                amount_later[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "delay_sooner", "double", context__.to_vec(N,T));
        validate_non_negative_index("delay_sooner", "N", N);
        validate_non_negative_index("delay_sooner", "T", T);
        delay_sooner = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("delay_sooner");
        pos__ = 0;
        size_t delay_sooner_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < delay_sooner_limit_1__; ++i_1__) {
            size_t delay_sooner_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < delay_sooner_limit_0__; ++i_0__) {
                delay_sooner[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "amount_sooner", "double", context__.to_vec(N,T));
        validate_non_negative_index("amount_sooner", "N", N);
        validate_non_negative_index("amount_sooner", "T", T);
        amount_sooner = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("amount_sooner");
        pos__ = 0;
        size_t amount_sooner_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < amount_sooner_limit_1__; ++i_1__) {
            size_t amount_sooner_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < amount_sooner_limit_0__; ++i_0__) {
                amount_sooner[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
        validate_non_negative_index("choice", "N", N);
        validate_non_negative_index("choice", "T", T);
        choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("choice");
        pos__ = 0;
        size_t choice_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
            size_t choice_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                choice[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"delay_later[k0__][k1__]",delay_later[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"amount_later[k0__][k1__]",amount_later[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"delay_sooner[k0__][k1__]",delay_sooner[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"amount_sooner[k0__][k1__]",amount_sooner[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],0);
                check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
            }
        }
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 2;
        num_params_r__ += 2;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_dd_hyperbolic() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(2));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(2));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("k_pr")))
            throw std::runtime_error("variable k_pr missing");
        vals_r__ = context__.vals_r("k_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "k_pr", "vector_d", context__.to_vec(N));
        // generate_declaration k_pr
        vector_d k_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            k_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(k_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        // generate_declaration beta_pr
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(2,lp__);
        else
            mu_p = in__.vector_constrain(2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,2,lp__);
        else
            sigma = in__.vector_lb_constrain(0,2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  k_pr;
        (void) k_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            k_pr = in__.vector_constrain(N,lp__);
        else
            k_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_pr;
        (void) beta_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_pr = in__.vector_constrain(N,lp__);
        else
            beta_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  k(static_cast<Eigen::VectorXd::Index>(N));
        (void) k;  // dummy to suppress unused var warning
        stan::math::initialize(k, DUMMY_VAR__);
        stan::math::fill(k,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(k,i,"k",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(k_pr,i,"k_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(k(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: k" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"k",k,0);
        check_less_or_equal(function__,"k",k,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,5);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(k_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            for (int i = 1; i <= N; ++i) {
                {
                    T__ ev_later;
                    (void) ev_later;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_later, DUMMY_VAR__);
                    stan::math::fill(ev_later,DUMMY_VAR__);
                    T__ ev_sooner;
                    (void) ev_sooner;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_sooner, DUMMY_VAR__);
                    stan::math::fill(ev_sooner,DUMMY_VAR__);


                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(ev_later, (get_base1(get_base1(amount_later,i,"amount_later",1),t,"amount_later",2) / (1 + (get_base1(k,i,"k",1) * get_base1(get_base1(delay_later,i,"delay_later",1),t,"delay_later",2)))));
                        stan::math::assign(ev_sooner, (get_base1(get_base1(amount_sooner,i,"amount_sooner",1),t,"amount_sooner",2) / (1 + (get_base1(k,i,"k",1) * get_base1(get_base1(delay_sooner,i,"delay_sooner",1),t,"delay_sooner",2)))));
                        lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(get_base1(choice,i,"choice",1),t,"choice",2), (get_base1(beta,i,"beta",1) * (ev_later - ev_sooner))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("k_pr");
        names__.push_back("beta_pr");
        names__.push_back("k");
        names__.push_back("beta");
        names__.push_back("mu_k");
        names__.push_back("mu_beta");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_dd_hyperbolic_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(2);
        vector_d sigma = in__.vector_lb_constrain(0,2);
        vector_d k_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(k_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d k(static_cast<Eigen::VectorXd::Index>(N));
        (void) k;  // dummy to suppress unused var warning
        stan::math::initialize(k, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(k,DUMMY_VAR__);
        vector_d beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(k,i,"k",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(k_pr,i,"k_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"k",k,0);
        check_less_or_equal(function__,"k",k,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,5);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(k[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_k(0.0);
        (void) mu_k;  // dummy to suppress unused var warning
        stan::math::initialize(mu_k, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_k,DUMMY_VAR__);
        double mu_beta(0.0);
        (void) mu_beta;  // dummy to suppress unused var warning
        stan::math::initialize(mu_beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_beta,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_k, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_beta, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 5));

            for (int i = 1; i <= N; ++i) {
                {
                    double ev_later(0.0);
                    (void) ev_later;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_later, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev_later,DUMMY_VAR__);
                    double ev_sooner(0.0);
                    (void) ev_sooner;  // dummy to suppress unused var warning
                    stan::math::initialize(ev_sooner, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev_sooner,DUMMY_VAR__);


                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(ev_later, (get_base1(get_base1(amount_later,i,"amount_later",1),t,"amount_later",2) / (1 + (get_base1(k,i,"k",1) * get_base1(get_base1(delay_later,i,"delay_later",1),t,"delay_later",2)))));
                        stan::math::assign(ev_sooner, (get_base1(get_base1(amount_sooner,i,"amount_sooner",1),t,"amount_sooner",2) / (1 + (get_base1(k,i,"k",1) * get_base1(get_base1(delay_sooner,i,"delay_sooner",1),t,"delay_sooner",2)))));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_logit_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),(get_base1(beta,i,"beta",1) * (ev_later - ev_sooner)))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_k",mu_k,0);
        check_less_or_equal(function__,"mu_k",mu_k,1);
        check_greater_or_equal(function__,"mu_beta",mu_beta,0);
        check_less_or_equal(function__,"mu_beta",mu_beta,5);

        // write generated quantities
        vars__.push_back(mu_k);
        vars__.push_back(mu_beta);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_dd_hyperbolic";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_gng_m1_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_gng_m1 : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > outcome;
    vector<vector<int> > pressed;
    vector<vector<int> > cue;
    vector_d initV;
public:
    model_gng_m1(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_gng_m1(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_gng_m1_namespace::model_gng_m1";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
        validate_non_negative_index("outcome", "N", N);
        validate_non_negative_index("outcome", "T", T);
        outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("outcome");
        pos__ = 0;
        size_t outcome_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
            size_t outcome_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                outcome[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "pressed", "int", context__.to_vec(N,T));
        validate_non_negative_index("pressed", "N", N);
        validate_non_negative_index("pressed", "T", T);
        pressed = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("pressed");
        pos__ = 0;
        size_t pressed_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < pressed_limit_1__; ++i_1__) {
            size_t pressed_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < pressed_limit_0__; ++i_0__) {
                pressed[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cue", "int", context__.to_vec(N,T));
        validate_non_negative_index("cue", "N", N);
        validate_non_negative_index("cue", "T", T);
        cue = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("cue");
        pos__ = 0;
        size_t cue_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cue_limit_1__; ++i_1__) {
            size_t cue_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cue_limit_0__; ++i_0__) {
                cue[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],0);
                check_less_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],1);
                check_less_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],4);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 3;
        num_params_r__ += 3;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_gng_m1() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(3));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration xi_pr
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        // generate_declaration ep_pr
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("rho_pr")))
            throw std::runtime_error("variable rho_pr missing");
        vals_r__ = context__.vals_r("rho_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rho_pr
        vector_d rho_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(3,lp__);
        else
            mu_p = in__.vector_constrain(3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,3,lp__);
        else
            sigma = in__.vector_lb_constrain(0,3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi_pr;
        (void) xi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            xi_pr = in__.vector_constrain(N,lp__);
        else
            xi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep_pr;
        (void) ep_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            ep_pr = in__.vector_constrain(N,lp__);
        else
            ep_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho_pr;
        (void) rho_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rho_pr = in__.vector_constrain(N,lp__);
        else
            rho_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, DUMMY_VAR__);
        stan::math::fill(xi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, DUMMY_VAR__);
        stan::math::fill(ep,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, DUMMY_VAR__);
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(rho, exp(add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(xi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(ep(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rho(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rho_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, DUMMY_VAR__);
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, DUMMY_VAR__);
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, DUMMY_VAR__);
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, DUMMY_VAR__);
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, DUMMY_VAR__);
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2), get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1)));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("xi_pr");
        names__.push_back("ep_pr");
        names__.push_back("rho_pr");
        names__.push_back("xi");
        names__.push_back("ep");
        names__.push_back("rho");
        names__.push_back("mu_xi");
        names__.push_back("mu_ep");
        names__.push_back("mu_rho");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_gng_m1_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d xi_pr = in__.vector_constrain(N);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d rho_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(xi,DUMMY_VAR__);
        vector_d ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ep,DUMMY_VAR__);
        vector_d rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(rho, exp(add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_xi(0.0);
        (void) mu_xi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_xi,DUMMY_VAR__);
        double mu_ep(0.0);
        (void) mu_ep;  // dummy to suppress unused var warning
        stan::math::initialize(mu_ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_ep,DUMMY_VAR__);
        double mu_rho(0.0);
        (void) mu_rho;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rho,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_rho, exp(get_base1(mu_p,3,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    vector_d wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    vector_d qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    vector_d qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    vector_d pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2),get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1))));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_xi",mu_xi,0);
        check_less_or_equal(function__,"mu_xi",mu_xi,1);
        check_greater_or_equal(function__,"mu_ep",mu_ep,0);
        check_less_or_equal(function__,"mu_ep",mu_ep,1);
        check_greater_or_equal(function__,"mu_rho",mu_rho,0);

        // write generated quantities
        vars__.push_back(mu_xi);
        vars__.push_back(mu_ep);
        vars__.push_back(mu_rho);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gng_m1";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_gng_m1_reg_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_gng_m1_reg : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > outcome;
    vector<vector<int> > pressed;
    vector<vector<int> > cue;
    vector_d initV;
public:
    model_gng_m1_reg(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_gng_m1_reg(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_gng_m1_reg_namespace::model_gng_m1_reg";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
        validate_non_negative_index("outcome", "N", N);
        validate_non_negative_index("outcome", "T", T);
        outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("outcome");
        pos__ = 0;
        size_t outcome_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
            size_t outcome_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                outcome[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "pressed", "int", context__.to_vec(N,T));
        validate_non_negative_index("pressed", "N", N);
        validate_non_negative_index("pressed", "T", T);
        pressed = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("pressed");
        pos__ = 0;
        size_t pressed_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < pressed_limit_1__; ++i_1__) {
            size_t pressed_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < pressed_limit_0__; ++i_0__) {
                pressed[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cue", "int", context__.to_vec(N,T));
        validate_non_negative_index("cue", "N", N);
        validate_non_negative_index("cue", "T", T);
        cue = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("cue");
        pos__ = 0;
        size_t cue_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cue_limit_1__; ++i_1__) {
            size_t cue_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cue_limit_0__; ++i_0__) {
                cue[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],0);
                check_less_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],1);
                check_less_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],4);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 3;
        num_params_r__ += 3;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_gng_m1_reg() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(3));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration xi_pr
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        // generate_declaration ep_pr
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("rho_pr")))
            throw std::runtime_error("variable rho_pr missing");
        vals_r__ = context__.vals_r("rho_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rho_pr
        vector_d rho_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(3,lp__);
        else
            mu_p = in__.vector_constrain(3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,3,lp__);
        else
            sigma = in__.vector_lb_constrain(0,3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi_pr;
        (void) xi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            xi_pr = in__.vector_constrain(N,lp__);
        else
            xi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep_pr;
        (void) ep_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            ep_pr = in__.vector_constrain(N,lp__);
        else
            ep_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho_pr;
        (void) rho_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rho_pr = in__.vector_constrain(N,lp__);
        else
            rho_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, DUMMY_VAR__);
        stan::math::fill(xi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, DUMMY_VAR__);
        stan::math::fill(ep,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, DUMMY_VAR__);
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(rho, exp(add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(xi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(ep(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rho(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rho_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, DUMMY_VAR__);
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, DUMMY_VAR__);
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, DUMMY_VAR__);
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, DUMMY_VAR__);
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, DUMMY_VAR__);
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2), get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1)));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("xi_pr");
        names__.push_back("ep_pr");
        names__.push_back("rho_pr");
        names__.push_back("xi");
        names__.push_back("ep");
        names__.push_back("rho");
        names__.push_back("mu_xi");
        names__.push_back("mu_ep");
        names__.push_back("mu_rho");
        names__.push_back("log_lik");
        names__.push_back("Qgo");
        names__.push_back("Qnogo");
        names__.push_back("Wgo");
        names__.push_back("Wnogo");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_gng_m1_reg_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d xi_pr = in__.vector_constrain(N);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d rho_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(xi,DUMMY_VAR__);
        vector_d ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ep,DUMMY_VAR__);
        vector_d rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(rho, exp(add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_xi(0.0);
        (void) mu_xi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_xi,DUMMY_VAR__);
        double mu_ep(0.0);
        (void) mu_ep;  // dummy to suppress unused var warning
        stan::math::initialize(mu_ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_ep,DUMMY_VAR__);
        double mu_rho(0.0);
        (void) mu_rho;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rho,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);
        vector<vector<double> > Qgo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Qgo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Qgo,DUMMY_VAR__);
        vector<vector<double> > Qnogo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Qnogo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Qnogo,DUMMY_VAR__);
        vector<vector<double> > Wgo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Wgo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Wgo,DUMMY_VAR__);
        vector<vector<double> > Wnogo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Wnogo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Wnogo,DUMMY_VAR__);


        try {
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_rho, exp(get_base1(mu_p,3,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    vector_d wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    vector_d qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    vector_d qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    vector_d pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2),get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1))));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Qgo,i,"Qgo",1),t,"Qgo",2), get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Qnogo,i,"Qnogo",1),t,"Qnogo",2), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Wgo,i,"Wgo",1),t,"Wgo",2), get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Wnogo,i,"Wnogo",1),t,"Wnogo",2), get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_xi",mu_xi,0);
        check_less_or_equal(function__,"mu_xi",mu_xi,1);
        check_greater_or_equal(function__,"mu_ep",mu_ep,0);
        check_less_or_equal(function__,"mu_ep",mu_ep,1);
        check_greater_or_equal(function__,"mu_rho",mu_rho,0);

        // write generated quantities
        vars__.push_back(mu_xi);
        vars__.push_back(mu_ep);
        vars__.push_back(mu_rho);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qgo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qnogo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wgo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wnogo[k_0__][k_1__]);
            }
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gng_m1_reg";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_gng_m2_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_gng_m2 : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > outcome;
    vector<vector<int> > pressed;
    vector<vector<int> > cue;
    vector_d initV;
public:
    model_gng_m2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_gng_m2(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_gng_m2_namespace::model_gng_m2";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
        validate_non_negative_index("outcome", "N", N);
        validate_non_negative_index("outcome", "T", T);
        outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("outcome");
        pos__ = 0;
        size_t outcome_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
            size_t outcome_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                outcome[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "pressed", "int", context__.to_vec(N,T));
        validate_non_negative_index("pressed", "N", N);
        validate_non_negative_index("pressed", "T", T);
        pressed = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("pressed");
        pos__ = 0;
        size_t pressed_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < pressed_limit_1__; ++i_1__) {
            size_t pressed_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < pressed_limit_0__; ++i_0__) {
                pressed[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cue", "int", context__.to_vec(N,T));
        validate_non_negative_index("cue", "N", N);
        validate_non_negative_index("cue", "T", T);
        cue = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("cue");
        pos__ = 0;
        size_t cue_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cue_limit_1__; ++i_1__) {
            size_t cue_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cue_limit_0__; ++i_0__) {
                cue[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],0);
                check_less_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],1);
                check_less_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],4);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 4;
        num_params_r__ += 4;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_gng_m2() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(4));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(4));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration xi_pr
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        // generate_declaration ep_pr
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("b_pr")))
            throw std::runtime_error("variable b_pr missing");
        vals_r__ = context__.vals_r("b_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "b_pr", "vector_d", context__.to_vec(N));
        // generate_declaration b_pr
        vector_d b_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            b_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(b_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b_pr: ") + e.what());
        }

        if (!(context__.contains_r("rho_pr")))
            throw std::runtime_error("variable rho_pr missing");
        vals_r__ = context__.vals_r("rho_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rho_pr
        vector_d rho_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(4,lp__);
        else
            mu_p = in__.vector_constrain(4);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,4,lp__);
        else
            sigma = in__.vector_lb_constrain(0,4);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi_pr;
        (void) xi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            xi_pr = in__.vector_constrain(N,lp__);
        else
            xi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep_pr;
        (void) ep_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            ep_pr = in__.vector_constrain(N,lp__);
        else
            ep_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  b_pr;
        (void) b_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            b_pr = in__.vector_constrain(N,lp__);
        else
            b_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho_pr;
        (void) rho_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rho_pr = in__.vector_constrain(N,lp__);
        else
            rho_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, DUMMY_VAR__);
        stan::math::fill(xi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, DUMMY_VAR__);
        stan::math::fill(ep,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, DUMMY_VAR__);
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(rho, exp(add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(xi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(ep(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rho(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,1,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,2,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,3,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,4,"mu_p",1), 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(b_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rho_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, DUMMY_VAR__);
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, DUMMY_VAR__);
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, DUMMY_VAR__);
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, DUMMY_VAR__);
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, DUMMY_VAR__);
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2), get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1)));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("xi_pr");
        names__.push_back("ep_pr");
        names__.push_back("b_pr");
        names__.push_back("rho_pr");
        names__.push_back("xi");
        names__.push_back("ep");
        names__.push_back("b");
        names__.push_back("rho");
        names__.push_back("mu_xi");
        names__.push_back("mu_ep");
        names__.push_back("mu_b");
        names__.push_back("mu_rho");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_gng_m2_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(4);
        vector_d sigma = in__.vector_lb_constrain(0,4);
        vector_d xi_pr = in__.vector_constrain(N);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d b_pr = in__.vector_constrain(N);
        vector_d rho_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(xi,DUMMY_VAR__);
        vector_d ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ep,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(rho, exp(add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_xi(0.0);
        (void) mu_xi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_xi,DUMMY_VAR__);
        double mu_ep(0.0);
        (void) mu_ep;  // dummy to suppress unused var warning
        stan::math::initialize(mu_ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_ep,DUMMY_VAR__);
        double mu_b(0.0);
        (void) mu_b;  // dummy to suppress unused var warning
        stan::math::initialize(mu_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_b,DUMMY_VAR__);
        double mu_rho(0.0);
        (void) mu_rho;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rho,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_b, get_base1(mu_p,3,"mu_p",1));
            stan::math::assign(mu_rho, exp(get_base1(mu_p,4,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    vector_d wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    vector_d qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    vector_d qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    vector_d pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2),get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1))));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_xi",mu_xi,0);
        check_less_or_equal(function__,"mu_xi",mu_xi,1);
        check_greater_or_equal(function__,"mu_ep",mu_ep,0);
        check_less_or_equal(function__,"mu_ep",mu_ep,1);
        check_greater_or_equal(function__,"mu_rho",mu_rho,0);

        // write generated quantities
        vars__.push_back(mu_xi);
        vars__.push_back(mu_ep);
        vars__.push_back(mu_b);
        vars__.push_back(mu_rho);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gng_m2";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_gng_m2_reg_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_gng_m2_reg : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > outcome;
    vector<vector<int> > pressed;
    vector<vector<int> > cue;
    vector_d initV;
public:
    model_gng_m2_reg(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_gng_m2_reg(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_gng_m2_reg_namespace::model_gng_m2_reg";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
        validate_non_negative_index("outcome", "N", N);
        validate_non_negative_index("outcome", "T", T);
        outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("outcome");
        pos__ = 0;
        size_t outcome_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
            size_t outcome_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                outcome[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "pressed", "int", context__.to_vec(N,T));
        validate_non_negative_index("pressed", "N", N);
        validate_non_negative_index("pressed", "T", T);
        pressed = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("pressed");
        pos__ = 0;
        size_t pressed_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < pressed_limit_1__; ++i_1__) {
            size_t pressed_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < pressed_limit_0__; ++i_0__) {
                pressed[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cue", "int", context__.to_vec(N,T));
        validate_non_negative_index("cue", "N", N);
        validate_non_negative_index("cue", "T", T);
        cue = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("cue");
        pos__ = 0;
        size_t cue_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cue_limit_1__; ++i_1__) {
            size_t cue_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cue_limit_0__; ++i_0__) {
                cue[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],0);
                check_less_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],1);
                check_less_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],4);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 4;
        num_params_r__ += 4;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_gng_m2_reg() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(4));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(4));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration xi_pr
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        // generate_declaration ep_pr
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("b_pr")))
            throw std::runtime_error("variable b_pr missing");
        vals_r__ = context__.vals_r("b_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "b_pr", "vector_d", context__.to_vec(N));
        // generate_declaration b_pr
        vector_d b_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            b_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(b_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b_pr: ") + e.what());
        }

        if (!(context__.contains_r("rho_pr")))
            throw std::runtime_error("variable rho_pr missing");
        vals_r__ = context__.vals_r("rho_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rho_pr
        vector_d rho_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(4,lp__);
        else
            mu_p = in__.vector_constrain(4);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,4,lp__);
        else
            sigma = in__.vector_lb_constrain(0,4);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi_pr;
        (void) xi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            xi_pr = in__.vector_constrain(N,lp__);
        else
            xi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep_pr;
        (void) ep_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            ep_pr = in__.vector_constrain(N,lp__);
        else
            ep_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  b_pr;
        (void) b_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            b_pr = in__.vector_constrain(N,lp__);
        else
            b_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho_pr;
        (void) rho_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rho_pr = in__.vector_constrain(N,lp__);
        else
            rho_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, DUMMY_VAR__);
        stan::math::fill(xi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, DUMMY_VAR__);
        stan::math::fill(ep,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, DUMMY_VAR__);
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(rho, exp(add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(xi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(ep(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rho(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,1,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,2,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,3,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,4,"mu_p",1), 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(b_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rho_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, DUMMY_VAR__);
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, DUMMY_VAR__);
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, DUMMY_VAR__);
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, DUMMY_VAR__);
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, DUMMY_VAR__);
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2), get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1)));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("xi_pr");
        names__.push_back("ep_pr");
        names__.push_back("b_pr");
        names__.push_back("rho_pr");
        names__.push_back("xi");
        names__.push_back("ep");
        names__.push_back("b");
        names__.push_back("rho");
        names__.push_back("mu_xi");
        names__.push_back("mu_ep");
        names__.push_back("mu_b");
        names__.push_back("mu_rho");
        names__.push_back("log_lik");
        names__.push_back("Qgo");
        names__.push_back("Qnogo");
        names__.push_back("Wgo");
        names__.push_back("Wnogo");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_gng_m2_reg_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(4);
        vector_d sigma = in__.vector_lb_constrain(0,4);
        vector_d xi_pr = in__.vector_constrain(N);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d b_pr = in__.vector_constrain(N);
        vector_d rho_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(xi,DUMMY_VAR__);
        vector_d ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ep,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(rho, exp(add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_xi(0.0);
        (void) mu_xi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_xi,DUMMY_VAR__);
        double mu_ep(0.0);
        (void) mu_ep;  // dummy to suppress unused var warning
        stan::math::initialize(mu_ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_ep,DUMMY_VAR__);
        double mu_b(0.0);
        (void) mu_b;  // dummy to suppress unused var warning
        stan::math::initialize(mu_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_b,DUMMY_VAR__);
        double mu_rho(0.0);
        (void) mu_rho;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rho,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);
        vector<vector<double> > Qgo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Qgo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Qgo,DUMMY_VAR__);
        vector<vector<double> > Qnogo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Qnogo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Qnogo,DUMMY_VAR__);
        vector<vector<double> > Wgo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Wgo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Wgo,DUMMY_VAR__);
        vector<vector<double> > Wnogo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Wnogo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Wnogo,DUMMY_VAR__);


        try {
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_b, get_base1(mu_p,3,"mu_p",1));
            stan::math::assign(mu_rho, exp(get_base1(mu_p,4,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    vector_d wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    vector_d qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    vector_d qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    vector_d pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= T; ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2),get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1))));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Qgo,i,"Qgo",1),t,"Qgo",2), get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Qnogo,i,"Qnogo",1),t,"Qnogo",2), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Wgo,i,"Wgo",1),t,"Wgo",2), get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Wnogo,i,"Wnogo",1),t,"Wnogo",2), get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_xi",mu_xi,0);
        check_less_or_equal(function__,"mu_xi",mu_xi,1);
        check_greater_or_equal(function__,"mu_ep",mu_ep,0);
        check_less_or_equal(function__,"mu_ep",mu_ep,1);
        check_greater_or_equal(function__,"mu_rho",mu_rho,0);

        // write generated quantities
        vars__.push_back(mu_xi);
        vars__.push_back(mu_ep);
        vars__.push_back(mu_b);
        vars__.push_back(mu_rho);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qgo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qnogo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wgo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wnogo[k_0__][k_1__]);
            }
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gng_m2_reg";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_gng_m3_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_gng_m3 : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > outcome;
    vector<vector<int> > pressed;
    vector<vector<int> > cue;
    vector_d initV;
public:
    model_gng_m3(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_gng_m3(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_gng_m3_namespace::model_gng_m3";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
        validate_non_negative_index("outcome", "N", N);
        validate_non_negative_index("outcome", "T", T);
        outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("outcome");
        pos__ = 0;
        size_t outcome_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
            size_t outcome_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                outcome[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "pressed", "int", context__.to_vec(N,T));
        validate_non_negative_index("pressed", "N", N);
        validate_non_negative_index("pressed", "T", T);
        pressed = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("pressed");
        pos__ = 0;
        size_t pressed_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < pressed_limit_1__; ++i_1__) {
            size_t pressed_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < pressed_limit_0__; ++i_0__) {
                pressed[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cue", "int", context__.to_vec(N,T));
        validate_non_negative_index("cue", "N", N);
        validate_non_negative_index("cue", "T", T);
        cue = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("cue");
        pos__ = 0;
        size_t cue_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cue_limit_1__; ++i_1__) {
            size_t cue_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cue_limit_0__; ++i_0__) {
                cue[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],0);
                check_less_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],1);
                check_less_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],4);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 5;
        num_params_r__ += 5;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_gng_m3() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(5));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(5));
        for (int j1__ = 0U; j1__ < 5; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(5));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(5));
        for (int j1__ = 0U; j1__ < 5; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration xi_pr
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        // generate_declaration ep_pr
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("b_pr")))
            throw std::runtime_error("variable b_pr missing");
        vals_r__ = context__.vals_r("b_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "b_pr", "vector_d", context__.to_vec(N));
        // generate_declaration b_pr
        vector_d b_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            b_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(b_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b_pr: ") + e.what());
        }

        if (!(context__.contains_r("pi_pr")))
            throw std::runtime_error("variable pi_pr missing");
        vals_r__ = context__.vals_r("pi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "pi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration pi_pr
        vector_d pi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            pi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(pi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pi_pr: ") + e.what());
        }

        if (!(context__.contains_r("rho_pr")))
            throw std::runtime_error("variable rho_pr missing");
        vals_r__ = context__.vals_r("rho_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rho_pr
        vector_d rho_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(5,lp__);
        else
            mu_p = in__.vector_constrain(5);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,5,lp__);
        else
            sigma = in__.vector_lb_constrain(0,5);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi_pr;
        (void) xi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            xi_pr = in__.vector_constrain(N,lp__);
        else
            xi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep_pr;
        (void) ep_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            ep_pr = in__.vector_constrain(N,lp__);
        else
            ep_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  b_pr;
        (void) b_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            b_pr = in__.vector_constrain(N,lp__);
        else
            b_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  pi_pr;
        (void) pi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            pi_pr = in__.vector_constrain(N,lp__);
        else
            pi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho_pr;
        (void) rho_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rho_pr = in__.vector_constrain(N,lp__);
        else
            rho_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, DUMMY_VAR__);
        stan::math::fill(xi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, DUMMY_VAR__);
        stan::math::fill(ep,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
        (void) pi;  // dummy to suppress unused var warning
        stan::math::initialize(pi, DUMMY_VAR__);
        stan::math::fill(pi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, DUMMY_VAR__);
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(pi, add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            stan::math::assign(rho, exp(add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(xi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(ep(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(pi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rho(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,1,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,2,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,3,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,4,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,5,"mu_p",1), 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(b_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(pi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rho_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, DUMMY_VAR__);
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, DUMMY_VAR__);
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, DUMMY_VAR__);
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, DUMMY_VAR__);
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  sv(static_cast<Eigen::VectorXd::Index>(4));
                    (void) sv;  // dummy to suppress unused var warning
                    stan::math::initialize(sv, DUMMY_VAR__);
                    stan::math::fill(sv,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, DUMMY_VAR__);
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(sv, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2), get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1)));
                        stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("xi_pr");
        names__.push_back("ep_pr");
        names__.push_back("b_pr");
        names__.push_back("pi_pr");
        names__.push_back("rho_pr");
        names__.push_back("xi");
        names__.push_back("ep");
        names__.push_back("b");
        names__.push_back("pi");
        names__.push_back("rho");
        names__.push_back("mu_xi");
        names__.push_back("mu_ep");
        names__.push_back("mu_b");
        names__.push_back("mu_pi");
        names__.push_back("mu_rho");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(5);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(5);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_gng_m3_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(5);
        vector_d sigma = in__.vector_lb_constrain(0,5);
        vector_d xi_pr = in__.vector_constrain(N);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d b_pr = in__.vector_constrain(N);
        vector_d pi_pr = in__.vector_constrain(N);
        vector_d rho_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 5; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 5; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(xi,DUMMY_VAR__);
        vector_d ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ep,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d pi(static_cast<Eigen::VectorXd::Index>(N));
        (void) pi;  // dummy to suppress unused var warning
        stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pi,DUMMY_VAR__);
        vector_d rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(pi, add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            stan::math::assign(rho, exp(add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_xi(0.0);
        (void) mu_xi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_xi,DUMMY_VAR__);
        double mu_ep(0.0);
        (void) mu_ep;  // dummy to suppress unused var warning
        stan::math::initialize(mu_ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_ep,DUMMY_VAR__);
        double mu_b(0.0);
        (void) mu_b;  // dummy to suppress unused var warning
        stan::math::initialize(mu_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_b,DUMMY_VAR__);
        double mu_pi(0.0);
        (void) mu_pi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_pi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_pi,DUMMY_VAR__);
        double mu_rho(0.0);
        (void) mu_rho;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rho,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_b, get_base1(mu_p,3,"mu_p",1));
            stan::math::assign(mu_pi, get_base1(mu_p,4,"mu_p",1));
            stan::math::assign(mu_rho, exp(get_base1(mu_p,5,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    vector_d wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    vector_d qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    vector_d qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    vector_d sv(static_cast<Eigen::VectorXd::Index>(4));
                    (void) sv;  // dummy to suppress unused var warning
                    stan::math::initialize(sv, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(sv,DUMMY_VAR__);
                    vector_d pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(sv, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2),get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1))));
                        stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_xi",mu_xi,0);
        check_less_or_equal(function__,"mu_xi",mu_xi,1);
        check_greater_or_equal(function__,"mu_ep",mu_ep,0);
        check_less_or_equal(function__,"mu_ep",mu_ep,1);
        check_greater_or_equal(function__,"mu_rho",mu_rho,0);

        // write generated quantities
        vars__.push_back(mu_xi);
        vars__.push_back(mu_ep);
        vars__.push_back(mu_b);
        vars__.push_back(mu_pi);
        vars__.push_back(mu_rho);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gng_m3";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_gng_m3_reg_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_gng_m3_reg : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > outcome;
    vector<vector<int> > pressed;
    vector<vector<int> > cue;
    vector_d initV;
public:
    model_gng_m3_reg(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_gng_m3_reg(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_gng_m3_reg_namespace::model_gng_m3_reg";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
        validate_non_negative_index("outcome", "N", N);
        validate_non_negative_index("outcome", "T", T);
        outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("outcome");
        pos__ = 0;
        size_t outcome_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
            size_t outcome_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                outcome[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "pressed", "int", context__.to_vec(N,T));
        validate_non_negative_index("pressed", "N", N);
        validate_non_negative_index("pressed", "T", T);
        pressed = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("pressed");
        pos__ = 0;
        size_t pressed_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < pressed_limit_1__; ++i_1__) {
            size_t pressed_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < pressed_limit_0__; ++i_0__) {
                pressed[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cue", "int", context__.to_vec(N,T));
        validate_non_negative_index("cue", "N", N);
        validate_non_negative_index("cue", "T", T);
        cue = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("cue");
        pos__ = 0;
        size_t cue_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cue_limit_1__; ++i_1__) {
            size_t cue_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cue_limit_0__; ++i_0__) {
                cue[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],0);
                check_less_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],1);
                check_less_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],4);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 5;
        num_params_r__ += 5;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_gng_m3_reg() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(5));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(5));
        for (int j1__ = 0U; j1__ < 5; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(5));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(5));
        for (int j1__ = 0U; j1__ < 5; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration xi_pr
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        // generate_declaration ep_pr
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("b_pr")))
            throw std::runtime_error("variable b_pr missing");
        vals_r__ = context__.vals_r("b_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "b_pr", "vector_d", context__.to_vec(N));
        // generate_declaration b_pr
        vector_d b_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            b_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(b_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b_pr: ") + e.what());
        }

        if (!(context__.contains_r("pi_pr")))
            throw std::runtime_error("variable pi_pr missing");
        vals_r__ = context__.vals_r("pi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "pi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration pi_pr
        vector_d pi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            pi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(pi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pi_pr: ") + e.what());
        }

        if (!(context__.contains_r("rho_pr")))
            throw std::runtime_error("variable rho_pr missing");
        vals_r__ = context__.vals_r("rho_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rho_pr
        vector_d rho_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(5,lp__);
        else
            mu_p = in__.vector_constrain(5);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,5,lp__);
        else
            sigma = in__.vector_lb_constrain(0,5);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi_pr;
        (void) xi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            xi_pr = in__.vector_constrain(N,lp__);
        else
            xi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep_pr;
        (void) ep_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            ep_pr = in__.vector_constrain(N,lp__);
        else
            ep_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  b_pr;
        (void) b_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            b_pr = in__.vector_constrain(N,lp__);
        else
            b_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  pi_pr;
        (void) pi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            pi_pr = in__.vector_constrain(N,lp__);
        else
            pi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho_pr;
        (void) rho_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rho_pr = in__.vector_constrain(N,lp__);
        else
            rho_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, DUMMY_VAR__);
        stan::math::fill(xi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, DUMMY_VAR__);
        stan::math::fill(ep,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
        (void) pi;  // dummy to suppress unused var warning
        stan::math::initialize(pi, DUMMY_VAR__);
        stan::math::fill(pi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, DUMMY_VAR__);
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(pi, add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            stan::math::assign(rho, exp(add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(xi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(ep(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(pi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rho(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,1,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,2,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,3,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,4,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,5,"mu_p",1), 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(b_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(pi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rho_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, DUMMY_VAR__);
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, DUMMY_VAR__);
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, DUMMY_VAR__);
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, DUMMY_VAR__);
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  sv(static_cast<Eigen::VectorXd::Index>(4));
                    (void) sv;  // dummy to suppress unused var warning
                    stan::math::initialize(sv, DUMMY_VAR__);
                    stan::math::fill(sv,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, DUMMY_VAR__);
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(sv, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2), get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1)));
                        stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("xi_pr");
        names__.push_back("ep_pr");
        names__.push_back("b_pr");
        names__.push_back("pi_pr");
        names__.push_back("rho_pr");
        names__.push_back("xi");
        names__.push_back("ep");
        names__.push_back("b");
        names__.push_back("pi");
        names__.push_back("rho");
        names__.push_back("mu_xi");
        names__.push_back("mu_ep");
        names__.push_back("mu_b");
        names__.push_back("mu_pi");
        names__.push_back("mu_rho");
        names__.push_back("log_lik");
        names__.push_back("Qgo");
        names__.push_back("Qnogo");
        names__.push_back("Wgo");
        names__.push_back("Wnogo");
        names__.push_back("SV");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(5);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(5);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_gng_m3_reg_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(5);
        vector_d sigma = in__.vector_lb_constrain(0,5);
        vector_d xi_pr = in__.vector_constrain(N);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d b_pr = in__.vector_constrain(N);
        vector_d pi_pr = in__.vector_constrain(N);
        vector_d rho_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 5; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 5; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(xi,DUMMY_VAR__);
        vector_d ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ep,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d pi(static_cast<Eigen::VectorXd::Index>(N));
        (void) pi;  // dummy to suppress unused var warning
        stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pi,DUMMY_VAR__);
        vector_d rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(pi, add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            stan::math::assign(rho, exp(add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),rho_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rho",rho,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_xi(0.0);
        (void) mu_xi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_xi,DUMMY_VAR__);
        double mu_ep(0.0);
        (void) mu_ep;  // dummy to suppress unused var warning
        stan::math::initialize(mu_ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_ep,DUMMY_VAR__);
        double mu_b(0.0);
        (void) mu_b;  // dummy to suppress unused var warning
        stan::math::initialize(mu_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_b,DUMMY_VAR__);
        double mu_pi(0.0);
        (void) mu_pi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_pi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_pi,DUMMY_VAR__);
        double mu_rho(0.0);
        (void) mu_rho;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rho,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);
        vector<vector<double> > Qgo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Qgo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Qgo,DUMMY_VAR__);
        vector<vector<double> > Qnogo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Qnogo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Qnogo,DUMMY_VAR__);
        vector<vector<double> > Wgo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Wgo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Wgo,DUMMY_VAR__);
        vector<vector<double> > Wnogo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Wnogo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Wnogo,DUMMY_VAR__);
        vector<vector<double> > SV(N, (vector<double>(T, 0.0)));
        stan::math::initialize(SV, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(SV,DUMMY_VAR__);


        try {
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_b, get_base1(mu_p,3,"mu_p",1));
            stan::math::assign(mu_pi, get_base1(mu_p,4,"mu_p",1));
            stan::math::assign(mu_rho, exp(get_base1(mu_p,5,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    vector_d wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    vector_d qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    vector_d qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    vector_d sv(static_cast<Eigen::VectorXd::Index>(4));
                    (void) sv;  // dummy to suppress unused var warning
                    stan::math::initialize(sv, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(sv,DUMMY_VAR__);
                    vector_d pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(sv, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2),get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1))));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Qgo,i,"Qgo",1),t,"Qgo",2), get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Qnogo,i,"Qnogo",1),t,"Qnogo",2), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Wgo,i,"Wgo",1),t,"Wgo",2), get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Wnogo,i,"Wnogo",1),t,"Wnogo",2), get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(SV,i,"SV",1),t,"SV",2), get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1));
                        stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rho,i,"rho",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_xi",mu_xi,0);
        check_less_or_equal(function__,"mu_xi",mu_xi,1);
        check_greater_or_equal(function__,"mu_ep",mu_ep,0);
        check_less_or_equal(function__,"mu_ep",mu_ep,1);
        check_greater_or_equal(function__,"mu_rho",mu_rho,0);

        // write generated quantities
        vars__.push_back(mu_xi);
        vars__.push_back(mu_ep);
        vars__.push_back(mu_b);
        vars__.push_back(mu_pi);
        vars__.push_back(mu_rho);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qgo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qnogo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wgo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wnogo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(SV[k_0__][k_1__]);
            }
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gng_m3_reg";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SV" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 5; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SV" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_gng_m4_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_gng_m4 : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > outcome;
    vector<vector<int> > pressed;
    vector<vector<int> > cue;
    vector_d initV;
public:
    model_gng_m4(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_gng_m4(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_gng_m4_namespace::model_gng_m4";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
        validate_non_negative_index("outcome", "N", N);
        validate_non_negative_index("outcome", "T", T);
        outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("outcome");
        pos__ = 0;
        size_t outcome_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
            size_t outcome_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                outcome[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "pressed", "int", context__.to_vec(N,T));
        validate_non_negative_index("pressed", "N", N);
        validate_non_negative_index("pressed", "T", T);
        pressed = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("pressed");
        pos__ = 0;
        size_t pressed_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < pressed_limit_1__; ++i_1__) {
            size_t pressed_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < pressed_limit_0__; ++i_0__) {
                pressed[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cue", "int", context__.to_vec(N,T));
        validate_non_negative_index("cue", "N", N);
        validate_non_negative_index("cue", "T", T);
        cue = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("cue");
        pos__ = 0;
        size_t cue_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cue_limit_1__; ++i_1__) {
            size_t cue_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cue_limit_0__; ++i_0__) {
                cue[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],0);
                check_less_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],1);
                check_less_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],4);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 6;
        num_params_r__ += 6;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_gng_m4() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(6));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(6));
        for (int j1__ = 0U; j1__ < 6; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(6));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(6));
        for (int j1__ = 0U; j1__ < 6; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration xi_pr
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        // generate_declaration ep_pr
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("b_pr")))
            throw std::runtime_error("variable b_pr missing");
        vals_r__ = context__.vals_r("b_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "b_pr", "vector_d", context__.to_vec(N));
        // generate_declaration b_pr
        vector_d b_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            b_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(b_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b_pr: ") + e.what());
        }

        if (!(context__.contains_r("pi_pr")))
            throw std::runtime_error("variable pi_pr missing");
        vals_r__ = context__.vals_r("pi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "pi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration pi_pr
        vector_d pi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            pi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(pi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pi_pr: ") + e.what());
        }

        if (!(context__.contains_r("rhoRew_pr")))
            throw std::runtime_error("variable rhoRew_pr missing");
        vals_r__ = context__.vals_r("rhoRew_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rhoRew_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rhoRew_pr
        vector_d rhoRew_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rhoRew_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rhoRew_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rhoRew_pr: ") + e.what());
        }

        if (!(context__.contains_r("rhoPun_pr")))
            throw std::runtime_error("variable rhoPun_pr missing");
        vals_r__ = context__.vals_r("rhoPun_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rhoPun_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rhoPun_pr
        vector_d rhoPun_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rhoPun_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rhoPun_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rhoPun_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(6,lp__);
        else
            mu_p = in__.vector_constrain(6);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,6,lp__);
        else
            sigma = in__.vector_lb_constrain(0,6);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi_pr;
        (void) xi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            xi_pr = in__.vector_constrain(N,lp__);
        else
            xi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep_pr;
        (void) ep_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            ep_pr = in__.vector_constrain(N,lp__);
        else
            ep_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  b_pr;
        (void) b_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            b_pr = in__.vector_constrain(N,lp__);
        else
            b_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  pi_pr;
        (void) pi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            pi_pr = in__.vector_constrain(N,lp__);
        else
            pi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rhoRew_pr;
        (void) rhoRew_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rhoRew_pr = in__.vector_constrain(N,lp__);
        else
            rhoRew_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rhoPun_pr;
        (void) rhoPun_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rhoPun_pr = in__.vector_constrain(N,lp__);
        else
            rhoPun_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, DUMMY_VAR__);
        stan::math::fill(xi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, DUMMY_VAR__);
        stan::math::fill(ep,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
        (void) pi;  // dummy to suppress unused var warning
        stan::math::initialize(pi, DUMMY_VAR__);
        stan::math::fill(pi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rhoRew(static_cast<Eigen::VectorXd::Index>(N));
        (void) rhoRew;  // dummy to suppress unused var warning
        stan::math::initialize(rhoRew, DUMMY_VAR__);
        stan::math::fill(rhoRew,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rhoPun(static_cast<Eigen::VectorXd::Index>(N));
        (void) rhoPun;  // dummy to suppress unused var warning
        stan::math::initialize(rhoPun, DUMMY_VAR__);
        stan::math::fill(rhoPun,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(pi, add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            stan::math::assign(rhoRew, exp(add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),rhoRew_pr))));
            stan::math::assign(rhoPun, exp(add(get_base1(mu_p,6,"mu_p",1),multiply(get_base1(sigma,6,"sigma",1),rhoPun_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(xi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(ep(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(pi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rhoRew(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rhoRew" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rhoPun(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rhoPun" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rhoRew",rhoRew,0);
        check_greater_or_equal(function__,"rhoPun",rhoPun,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,1,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,2,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,3,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,4,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,5,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,6,"mu_p",1), 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(b_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(pi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rhoRew_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rhoPun_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, DUMMY_VAR__);
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, DUMMY_VAR__);
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, DUMMY_VAR__);
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, DUMMY_VAR__);
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  sv(static_cast<Eigen::VectorXd::Index>(4));
                    (void) sv;  // dummy to suppress unused var warning
                    stan::math::initialize(sv, DUMMY_VAR__);
                    stan::math::fill(sv,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, DUMMY_VAR__);
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(sv, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2), get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1)));
                        if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                            stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        }
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                                stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                            } else {

                                stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                            }
                        } else {

                            if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                                stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                            } else {

                                stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                            }
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("xi_pr");
        names__.push_back("ep_pr");
        names__.push_back("b_pr");
        names__.push_back("pi_pr");
        names__.push_back("rhoRew_pr");
        names__.push_back("rhoPun_pr");
        names__.push_back("xi");
        names__.push_back("ep");
        names__.push_back("b");
        names__.push_back("pi");
        names__.push_back("rhoRew");
        names__.push_back("rhoPun");
        names__.push_back("mu_xi");
        names__.push_back("mu_ep");
        names__.push_back("mu_b");
        names__.push_back("mu_pi");
        names__.push_back("mu_rhoRew");
        names__.push_back("mu_rhoPun");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_gng_m4_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(6);
        vector_d sigma = in__.vector_lb_constrain(0,6);
        vector_d xi_pr = in__.vector_constrain(N);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d b_pr = in__.vector_constrain(N);
        vector_d pi_pr = in__.vector_constrain(N);
        vector_d rhoRew_pr = in__.vector_constrain(N);
        vector_d rhoPun_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rhoRew_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rhoPun_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(xi,DUMMY_VAR__);
        vector_d ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ep,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d pi(static_cast<Eigen::VectorXd::Index>(N));
        (void) pi;  // dummy to suppress unused var warning
        stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pi,DUMMY_VAR__);
        vector_d rhoRew(static_cast<Eigen::VectorXd::Index>(N));
        (void) rhoRew;  // dummy to suppress unused var warning
        stan::math::initialize(rhoRew, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rhoRew,DUMMY_VAR__);
        vector_d rhoPun(static_cast<Eigen::VectorXd::Index>(N));
        (void) rhoPun;  // dummy to suppress unused var warning
        stan::math::initialize(rhoPun, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rhoPun,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(pi, add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            stan::math::assign(rhoRew, exp(add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),rhoRew_pr))));
            stan::math::assign(rhoPun, exp(add(get_base1(mu_p,6,"mu_p",1),multiply(get_base1(sigma,6,"sigma",1),rhoPun_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rhoRew",rhoRew,0);
        check_greater_or_equal(function__,"rhoPun",rhoPun,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rhoRew[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rhoPun[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_xi(0.0);
        (void) mu_xi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_xi,DUMMY_VAR__);
        double mu_ep(0.0);
        (void) mu_ep;  // dummy to suppress unused var warning
        stan::math::initialize(mu_ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_ep,DUMMY_VAR__);
        double mu_b(0.0);
        (void) mu_b;  // dummy to suppress unused var warning
        stan::math::initialize(mu_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_b,DUMMY_VAR__);
        double mu_pi(0.0);
        (void) mu_pi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_pi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_pi,DUMMY_VAR__);
        double mu_rhoRew(0.0);
        (void) mu_rhoRew;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rhoRew, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rhoRew,DUMMY_VAR__);
        double mu_rhoPun(0.0);
        (void) mu_rhoPun;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rhoPun, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rhoPun,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_b, get_base1(mu_p,3,"mu_p",1));
            stan::math::assign(mu_pi, get_base1(mu_p,4,"mu_p",1));
            stan::math::assign(mu_rhoRew, exp(get_base1(mu_p,5,"mu_p",1)));
            stan::math::assign(mu_rhoPun, exp(get_base1(mu_p,6,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    vector_d wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    vector_d qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    vector_d qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    vector_d sv(static_cast<Eigen::VectorXd::Index>(4));
                    (void) sv;  // dummy to suppress unused var warning
                    stan::math::initialize(sv, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(sv,DUMMY_VAR__);
                    vector_d pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(sv, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2),get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1))));
                        if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                            stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        }
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                                stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                            } else {

                                stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                            }
                        } else {

                            if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                                stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                            } else {

                                stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                            }
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_xi",mu_xi,0);
        check_less_or_equal(function__,"mu_xi",mu_xi,1);
        check_greater_or_equal(function__,"mu_ep",mu_ep,0);
        check_less_or_equal(function__,"mu_ep",mu_ep,1);
        check_greater_or_equal(function__,"mu_rhoRew",mu_rhoRew,0);
        check_greater_or_equal(function__,"mu_rhoPun",mu_rhoPun,0);

        // write generated quantities
        vars__.push_back(mu_xi);
        vars__.push_back(mu_ep);
        vars__.push_back(mu_b);
        vars__.push_back(mu_pi);
        vars__.push_back(mu_rhoRew);
        vars__.push_back(mu_rhoPun);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gng_m4";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoRew_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoPun_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoRew" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoPun" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rhoRew";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rhoPun";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoRew_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoPun_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoRew" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoPun" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rhoRew";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rhoPun";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_gng_m4_reg_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_gng_m4_reg : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > outcome;
    vector<vector<int> > pressed;
    vector<vector<int> > cue;
    vector_d initV;
public:
    model_gng_m4_reg(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_gng_m4_reg(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_gng_m4_reg_namespace::model_gng_m4_reg";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
        validate_non_negative_index("outcome", "N", N);
        validate_non_negative_index("outcome", "T", T);
        outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("outcome");
        pos__ = 0;
        size_t outcome_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
            size_t outcome_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                outcome[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "pressed", "int", context__.to_vec(N,T));
        validate_non_negative_index("pressed", "N", N);
        validate_non_negative_index("pressed", "T", T);
        pressed = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("pressed");
        pos__ = 0;
        size_t pressed_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < pressed_limit_1__; ++i_1__) {
            size_t pressed_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < pressed_limit_0__; ++i_0__) {
                pressed[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cue", "int", context__.to_vec(N,T));
        validate_non_negative_index("cue", "N", N);
        validate_non_negative_index("cue", "T", T);
        cue = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("cue");
        pos__ = 0;
        size_t cue_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cue_limit_1__; ++i_1__) {
            size_t cue_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cue_limit_0__; ++i_0__) {
                cue[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],0);
                check_less_or_equal(function__,"pressed[k0__][k1__]",pressed[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],1);
                check_less_or_equal(function__,"cue[k0__][k1__]",cue[k0__][k1__],4);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 6;
        num_params_r__ += 6;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_gng_m4_reg() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(6));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(6));
        for (int j1__ = 0U; j1__ < 6; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(6));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(6));
        for (int j1__ = 0U; j1__ < 6; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("xi_pr")))
            throw std::runtime_error("variable xi_pr missing");
        vals_r__ = context__.vals_r("xi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "xi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration xi_pr
        vector_d xi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            xi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(xi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable xi_pr: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        // generate_declaration ep_pr
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("b_pr")))
            throw std::runtime_error("variable b_pr missing");
        vals_r__ = context__.vals_r("b_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "b_pr", "vector_d", context__.to_vec(N));
        // generate_declaration b_pr
        vector_d b_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            b_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(b_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b_pr: ") + e.what());
        }

        if (!(context__.contains_r("pi_pr")))
            throw std::runtime_error("variable pi_pr missing");
        vals_r__ = context__.vals_r("pi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "pi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration pi_pr
        vector_d pi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            pi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(pi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pi_pr: ") + e.what());
        }

        if (!(context__.contains_r("rhoRew_pr")))
            throw std::runtime_error("variable rhoRew_pr missing");
        vals_r__ = context__.vals_r("rhoRew_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rhoRew_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rhoRew_pr
        vector_d rhoRew_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rhoRew_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rhoRew_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rhoRew_pr: ") + e.what());
        }

        if (!(context__.contains_r("rhoPun_pr")))
            throw std::runtime_error("variable rhoPun_pr missing");
        vals_r__ = context__.vals_r("rhoPun_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rhoPun_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rhoPun_pr
        vector_d rhoPun_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rhoPun_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rhoPun_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rhoPun_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(6,lp__);
        else
            mu_p = in__.vector_constrain(6);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,6,lp__);
        else
            sigma = in__.vector_lb_constrain(0,6);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi_pr;
        (void) xi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            xi_pr = in__.vector_constrain(N,lp__);
        else
            xi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep_pr;
        (void) ep_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            ep_pr = in__.vector_constrain(N,lp__);
        else
            ep_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  b_pr;
        (void) b_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            b_pr = in__.vector_constrain(N,lp__);
        else
            b_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  pi_pr;
        (void) pi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            pi_pr = in__.vector_constrain(N,lp__);
        else
            pi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rhoRew_pr;
        (void) rhoRew_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rhoRew_pr = in__.vector_constrain(N,lp__);
        else
            rhoRew_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rhoPun_pr;
        (void) rhoPun_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rhoPun_pr = in__.vector_constrain(N,lp__);
        else
            rhoPun_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, DUMMY_VAR__);
        stan::math::fill(xi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, DUMMY_VAR__);
        stan::math::fill(ep,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  pi(static_cast<Eigen::VectorXd::Index>(N));
        (void) pi;  // dummy to suppress unused var warning
        stan::math::initialize(pi, DUMMY_VAR__);
        stan::math::fill(pi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rhoRew(static_cast<Eigen::VectorXd::Index>(N));
        (void) rhoRew;  // dummy to suppress unused var warning
        stan::math::initialize(rhoRew, DUMMY_VAR__);
        stan::math::fill(rhoRew,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rhoPun(static_cast<Eigen::VectorXd::Index>(N));
        (void) rhoPun;  // dummy to suppress unused var warning
        stan::math::initialize(rhoPun, DUMMY_VAR__);
        stan::math::fill(rhoPun,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(pi, add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            stan::math::assign(rhoRew, exp(add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),rhoRew_pr))));
            stan::math::assign(rhoPun, exp(add(get_base1(mu_p,6,"mu_p",1),multiply(get_base1(sigma,6,"sigma",1),rhoPun_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(xi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: xi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(ep(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(b(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(pi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rhoRew(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rhoRew" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rhoPun(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rhoPun" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rhoRew",rhoRew,0);
        check_greater_or_equal(function__,"rhoPun",rhoPun,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,1,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,2,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,3,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,4,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,5,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,6,"mu_p",1), 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(xi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(b_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(pi_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rhoRew_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(rhoPun_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, DUMMY_VAR__);
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, DUMMY_VAR__);
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, DUMMY_VAR__);
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, DUMMY_VAR__);
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  sv(static_cast<Eigen::VectorXd::Index>(4));
                    (void) sv;  // dummy to suppress unused var warning
                    stan::math::initialize(sv, DUMMY_VAR__);
                    stan::math::fill(sv,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, DUMMY_VAR__);
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(sv, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2), get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1)));
                        if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                            stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        }
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                                stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                            } else {

                                stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                            }
                        } else {

                            if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                                stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                            } else {

                                stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                            }
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("xi_pr");
        names__.push_back("ep_pr");
        names__.push_back("b_pr");
        names__.push_back("pi_pr");
        names__.push_back("rhoRew_pr");
        names__.push_back("rhoPun_pr");
        names__.push_back("xi");
        names__.push_back("ep");
        names__.push_back("b");
        names__.push_back("pi");
        names__.push_back("rhoRew");
        names__.push_back("rhoPun");
        names__.push_back("mu_xi");
        names__.push_back("mu_ep");
        names__.push_back("mu_b");
        names__.push_back("mu_pi");
        names__.push_back("mu_rhoRew");
        names__.push_back("mu_rhoPun");
        names__.push_back("log_lik");
        names__.push_back("Qgo");
        names__.push_back("Qnogo");
        names__.push_back("Wgo");
        names__.push_back("Wnogo");
        names__.push_back("SV");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_gng_m4_reg_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(6);
        vector_d sigma = in__.vector_lb_constrain(0,6);
        vector_d xi_pr = in__.vector_constrain(N);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d b_pr = in__.vector_constrain(N);
        vector_d pi_pr = in__.vector_constrain(N);
        vector_d rhoRew_pr = in__.vector_constrain(N);
        vector_d rhoPun_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rhoRew_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rhoPun_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d xi(static_cast<Eigen::VectorXd::Index>(N));
        (void) xi;  // dummy to suppress unused var warning
        stan::math::initialize(xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(xi,DUMMY_VAR__);
        vector_d ep(static_cast<Eigen::VectorXd::Index>(N));
        (void) ep;  // dummy to suppress unused var warning
        stan::math::initialize(ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ep,DUMMY_VAR__);
        vector_d b(static_cast<Eigen::VectorXd::Index>(N));
        (void) b;  // dummy to suppress unused var warning
        stan::math::initialize(b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(b,DUMMY_VAR__);
        vector_d pi(static_cast<Eigen::VectorXd::Index>(N));
        (void) pi;  // dummy to suppress unused var warning
        stan::math::initialize(pi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pi,DUMMY_VAR__);
        vector_d rhoRew(static_cast<Eigen::VectorXd::Index>(N));
        (void) rhoRew;  // dummy to suppress unused var warning
        stan::math::initialize(rhoRew, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rhoRew,DUMMY_VAR__);
        vector_d rhoPun(static_cast<Eigen::VectorXd::Index>(N));
        (void) rhoPun;  // dummy to suppress unused var warning
        stan::math::initialize(rhoPun, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rhoPun,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(xi,i,"xi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(xi_pr,i,"xi_pr",1)))));
                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
            }
            stan::math::assign(b, add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),b_pr)));
            stan::math::assign(pi, add(get_base1(mu_p,4,"mu_p",1),multiply(get_base1(sigma,4,"sigma",1),pi_pr)));
            stan::math::assign(rhoRew, exp(add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),rhoRew_pr))));
            stan::math::assign(rhoPun, exp(add(get_base1(mu_p,6,"mu_p",1),multiply(get_base1(sigma,6,"sigma",1),rhoPun_pr))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"xi",xi,0);
        check_less_or_equal(function__,"xi",xi,1);
        check_greater_or_equal(function__,"ep",ep,0);
        check_less_or_equal(function__,"ep",ep,1);
        check_greater_or_equal(function__,"rhoRew",rhoRew,0);
        check_greater_or_equal(function__,"rhoPun",rhoPun,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(xi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(pi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rhoRew[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rhoPun[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_xi(0.0);
        (void) mu_xi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_xi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_xi,DUMMY_VAR__);
        double mu_ep(0.0);
        (void) mu_ep;  // dummy to suppress unused var warning
        stan::math::initialize(mu_ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_ep,DUMMY_VAR__);
        double mu_b(0.0);
        (void) mu_b;  // dummy to suppress unused var warning
        stan::math::initialize(mu_b, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_b,DUMMY_VAR__);
        double mu_pi(0.0);
        (void) mu_pi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_pi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_pi,DUMMY_VAR__);
        double mu_rhoRew(0.0);
        (void) mu_rhoRew;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rhoRew, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rhoRew,DUMMY_VAR__);
        double mu_rhoPun(0.0);
        (void) mu_rhoPun;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rhoPun, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rhoPun,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);
        vector<vector<double> > Qgo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Qgo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Qgo,DUMMY_VAR__);
        vector<vector<double> > Qnogo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Qnogo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Qnogo,DUMMY_VAR__);
        vector<vector<double> > Wgo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Wgo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Wgo,DUMMY_VAR__);
        vector<vector<double> > Wnogo(N, (vector<double>(T, 0.0)));
        stan::math::initialize(Wnogo, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Wnogo,DUMMY_VAR__);
        vector<vector<double> > SV(N, (vector<double>(T, 0.0)));
        stan::math::initialize(SV, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(SV,DUMMY_VAR__);


        try {
            stan::math::assign(mu_xi, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_b, get_base1(mu_p,3,"mu_p",1));
            stan::math::assign(mu_pi, get_base1(mu_p,4,"mu_p",1));
            stan::math::assign(mu_rhoRew, exp(get_base1(mu_p,5,"mu_p",1)));
            stan::math::assign(mu_rhoPun, exp(get_base1(mu_p,6,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d wv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_g,DUMMY_VAR__);
                    vector_d wv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) wv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(wv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(wv_ng,DUMMY_VAR__);
                    vector_d qv_g(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_g;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_g, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_g,DUMMY_VAR__);
                    vector_d qv_ng(static_cast<Eigen::VectorXd::Index>(4));
                    (void) qv_ng;  // dummy to suppress unused var warning
                    stan::math::initialize(qv_ng, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(qv_ng,DUMMY_VAR__);
                    vector_d sv(static_cast<Eigen::VectorXd::Index>(4));
                    (void) sv;  // dummy to suppress unused var warning
                    stan::math::initialize(sv, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(sv,DUMMY_VAR__);
                    vector_d pGo(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pGo;  // dummy to suppress unused var warning
                    stan::math::initialize(pGo, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pGo,DUMMY_VAR__);


                    stan::math::assign(wv_g, initV);
                    stan::math::assign(wv_ng, initV);
                    stan::math::assign(qv_g, initV);
                    stan::math::assign(qv_ng, initV);
                    stan::math::assign(sv, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1), ((get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + get_base1(b,i,"b",1)) + (get_base1(pi,i,"pi",1) * get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1))));
                        stan::math::assign(get_base1_lhs(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), inv_logit((get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1) - get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1))));
                        stan::math::assign(get_base1_lhs(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1), ((get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1) * (1 - get_base1(xi,i,"xi",1))) + (get_base1(xi,i,"xi",1) / 2)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2),get_base1(pGo,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"pGo",1))));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Qgo,i,"Qgo",1),t,"Qgo",2), get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Qnogo,i,"Qnogo",1),t,"Qnogo",2), get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Wgo,i,"Wgo",1),t,"Wgo",2), get_base1(wv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_g",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(Wnogo,i,"Wnogo",1),t,"Wnogo",2), get_base1(wv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"wv_ng",1));
                        stan::math::assign(get_base1_lhs(get_base1_lhs(SV,i,"SV",1),t,"SV",2), get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1));
                        if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                            stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        } else {

                            stan::math::assign(get_base1_lhs(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1), (get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(sv,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"sv",1)))));
                        }
                        if (as_bool(get_base1(get_base1(pressed,i,"pressed",1),t,"pressed",2))) {

                            if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                                stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                            } else {

                                stan::math::assign(get_base1_lhs(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1), (get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_g,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_g",1)))));
                            }
                        } else {

                            if (as_bool(logical_gte(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),0))) {

                                stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoRew,i,"rhoRew",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                            } else {

                                stan::math::assign(get_base1_lhs(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1), (get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1) + (get_base1(ep,i,"ep",1) * ((get_base1(rhoPun,i,"rhoPun",1) * get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(qv_ng,get_base1(get_base1(cue,i,"cue",1),t,"cue",2),"qv_ng",1)))));
                            }
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_xi",mu_xi,0);
        check_less_or_equal(function__,"mu_xi",mu_xi,1);
        check_greater_or_equal(function__,"mu_ep",mu_ep,0);
        check_less_or_equal(function__,"mu_ep",mu_ep,1);
        check_greater_or_equal(function__,"mu_rhoRew",mu_rhoRew,0);
        check_greater_or_equal(function__,"mu_rhoPun",mu_rhoPun,0);

        // write generated quantities
        vars__.push_back(mu_xi);
        vars__.push_back(mu_ep);
        vars__.push_back(mu_b);
        vars__.push_back(mu_pi);
        vars__.push_back(mu_rhoRew);
        vars__.push_back(mu_rhoPun);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qgo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Qnogo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wgo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(Wnogo[k_0__][k_1__]);
            }
        }
        for (int k_1__ = 0; k_1__ < T; ++k_1__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(SV[k_0__][k_1__]);
            }
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_gng_m4_reg";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoRew_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoPun_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoRew" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoPun" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rhoRew";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rhoPun";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SV" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoRew_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoPun_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoRew" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rhoPun" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_xi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_b";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_pi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rhoRew";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rhoPun";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Qnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wgo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Wnogo" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SV" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_igt_pvl_decay_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_igt_pvl_decay : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > rewlos;
    vector<vector<int> > ydata;
    vector_d initV;
public:
    model_igt_pvl_decay(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_igt_pvl_decay(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_igt_pvl_decay_namespace::model_igt_pvl_decay";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "rewlos", "double", context__.to_vec(N,T));
        validate_non_negative_index("rewlos", "N", N);
        validate_non_negative_index("rewlos", "T", T);
        rewlos = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("rewlos");
        pos__ = 0;
        size_t rewlos_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < rewlos_limit_1__; ++i_1__) {
            size_t rewlos_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < rewlos_limit_0__; ++i_0__) {
                rewlos[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "ydata", "int", context__.to_vec(N,T));
        validate_non_negative_index("ydata", "N", N);
        validate_non_negative_index("ydata", "T", T);
        ydata = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("ydata");
        pos__ = 0;
        size_t ydata_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < ydata_limit_1__; ++i_1__) {
            size_t ydata_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < ydata_limit_0__; ++i_0__) {
                ydata[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 4;
        num_params_r__ += 4;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_igt_pvl_decay() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(4));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(4));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("A_pr")))
            throw std::runtime_error("variable A_pr missing");
        vals_r__ = context__.vals_r("A_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "A_pr", "vector_d", context__.to_vec(N));
        // generate_declaration A_pr
        vector_d A_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            A_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(A_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable A_pr: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        // generate_declaration alpha_pr
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("cons_pr")))
            throw std::runtime_error("variable cons_pr missing");
        vals_r__ = context__.vals_r("cons_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "cons_pr", "vector_d", context__.to_vec(N));
        // generate_declaration cons_pr
        vector_d cons_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            cons_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(cons_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable cons_pr: ") + e.what());
        }

        if (!(context__.contains_r("lambda_pr")))
            throw std::runtime_error("variable lambda_pr missing");
        vals_r__ = context__.vals_r("lambda_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "lambda_pr", "vector_d", context__.to_vec(N));
        // generate_declaration lambda_pr
        vector_d lambda_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            lambda_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(lambda_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable lambda_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(4,lp__);
        else
            mu_p = in__.vector_constrain(4);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,4,lp__);
        else
            sigma = in__.vector_lb_constrain(0,4);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  A_pr;
        (void) A_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            A_pr = in__.vector_constrain(N,lp__);
        else
            A_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_pr;
        (void) alpha_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_pr = in__.vector_constrain(N,lp__);
        else
            alpha_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  cons_pr;
        (void) cons_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            cons_pr = in__.vector_constrain(N,lp__);
        else
            cons_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda_pr;
        (void) lambda_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            lambda_pr = in__.vector_constrain(N,lp__);
        else
            lambda_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  A(static_cast<Eigen::VectorXd::Index>(N));
        (void) A;  // dummy to suppress unused var warning
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  cons(static_cast<Eigen::VectorXd::Index>(N));
        (void) cons;  // dummy to suppress unused var warning
        stan::math::initialize(cons, DUMMY_VAR__);
        stan::math::fill(cons,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(A,i,"A",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 2));
                stan::math::assign(get_base1_lhs(cons,i,"cons",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(cons_pr,i,"cons_pr",1)))) * 5));
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,4,"mu_p",1) + (get_base1(sigma,4,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(A(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: A" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(alpha(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(cons(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: cons" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(lambda(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"A",A,0);
        check_less_or_equal(function__,"A",A,1);
        check_greater_or_equal(function__,"alpha",alpha,0);
        check_less_or_equal(function__,"alpha",alpha,2);
        check_greater_or_equal(function__,"cons",cons,0);
        check_less_or_equal(function__,"cons",cons,5);
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,10);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(A_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(cons_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(lambda_pr, 0, 1));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(4));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, DUMMY_VAR__);
                    stan::math::fill(ev,DUMMY_VAR__);
                    T__ curUtil;
                    (void) curUtil;  // dummy to suppress unused var warning
                    stan::math::initialize(curUtil, DUMMY_VAR__);
                    stan::math::fill(curUtil,DUMMY_VAR__);
                    T__ theta;
                    (void) theta;  // dummy to suppress unused var warning
                    stan::math::initialize(theta, DUMMY_VAR__);
                    stan::math::fill(theta,DUMMY_VAR__);


                    stan::math::assign(theta, (pow(3,get_base1(cons,i,"cons",1)) - 1));
                    stan::math::assign(ev, initV);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        if (as_bool(logical_gte(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),0))) {

                            stan::math::assign(curUtil, pow(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),get_base1(alpha,i,"alpha",1)));
                        } else {

                            stan::math::assign(curUtil, ((-(1) * get_base1(lambda,i,"lambda",1)) * pow((-(1) * get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)),get_base1(alpha,i,"alpha",1))));
                        }
                        stan::math::assign(ev, multiply(ev,get_base1(A,i,"A",1)));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1), (get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1) + curUtil));
                        lp_accum__.add(categorical_logit_log<propto__>(get_base1(get_base1(ydata,i,"ydata",1),(t + 1),"ydata",2), multiply(theta,ev)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("A_pr");
        names__.push_back("alpha_pr");
        names__.push_back("cons_pr");
        names__.push_back("lambda_pr");
        names__.push_back("A");
        names__.push_back("alpha");
        names__.push_back("cons");
        names__.push_back("lambda");
        names__.push_back("mu_A");
        names__.push_back("mu_alpha");
        names__.push_back("mu_cons");
        names__.push_back("mu_lambda");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_igt_pvl_decay_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(4);
        vector_d sigma = in__.vector_lb_constrain(0,4);
        vector_d A_pr = in__.vector_constrain(N);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d cons_pr = in__.vector_constrain(N);
        vector_d lambda_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(cons_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d A(static_cast<Eigen::VectorXd::Index>(N));
        (void) A;  // dummy to suppress unused var warning
        stan::math::initialize(A, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(A,DUMMY_VAR__);
        vector_d alpha(static_cast<Eigen::VectorXd::Index>(N));
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        vector_d cons(static_cast<Eigen::VectorXd::Index>(N));
        (void) cons;  // dummy to suppress unused var warning
        stan::math::initialize(cons, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cons,DUMMY_VAR__);
        vector_d lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lambda,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(A,i,"A",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 2));
                stan::math::assign(get_base1_lhs(cons,i,"cons",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(cons_pr,i,"cons_pr",1)))) * 5));
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,4,"mu_p",1) + (get_base1(sigma,4,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"A",A,0);
        check_less_or_equal(function__,"A",A,1);
        check_greater_or_equal(function__,"alpha",alpha,0);
        check_less_or_equal(function__,"alpha",alpha,2);
        check_greater_or_equal(function__,"cons",cons,0);
        check_less_or_equal(function__,"cons",cons,5);
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,10);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(cons[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_A(0.0);
        (void) mu_A;  // dummy to suppress unused var warning
        stan::math::initialize(mu_A, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_A,DUMMY_VAR__);
        double mu_alpha(0.0);
        (void) mu_alpha;  // dummy to suppress unused var warning
        stan::math::initialize(mu_alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_alpha,DUMMY_VAR__);
        double mu_cons(0.0);
        (void) mu_cons;  // dummy to suppress unused var warning
        stan::math::initialize(mu_cons, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_cons,DUMMY_VAR__);
        double mu_lambda(0.0);
        (void) mu_lambda;  // dummy to suppress unused var warning
        stan::math::initialize(mu_lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_lambda,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_A, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_alpha, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 2));
            stan::math::assign(mu_cons, (Phi_approx(get_base1(mu_p,3,"mu_p",1)) * 5));
            stan::math::assign(mu_lambda, (Phi_approx(get_base1(mu_p,4,"mu_p",1)) * 10));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d ev(static_cast<Eigen::VectorXd::Index>(4));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev,DUMMY_VAR__);
                    double curUtil(0.0);
                    (void) curUtil;  // dummy to suppress unused var warning
                    stan::math::initialize(curUtil, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(curUtil,DUMMY_VAR__);
                    double theta(0.0);
                    (void) theta;  // dummy to suppress unused var warning
                    stan::math::initialize(theta, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(theta,DUMMY_VAR__);


                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    stan::math::assign(theta, (pow(3,get_base1(cons,i,"cons",1)) - 1));
                    stan::math::assign(ev, initV);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        if (as_bool(logical_gte(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),0))) {

                            stan::math::assign(curUtil, pow(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),get_base1(alpha,i,"alpha",1)));
                        } else {

                            stan::math::assign(curUtil, ((-(1) * get_base1(lambda,i,"lambda",1)) * pow((-(1) * get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)),get_base1(alpha,i,"alpha",1))));
                        }
                        stan::math::assign(ev, multiply(ev,get_base1(A,i,"A",1)));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1), (get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1) + curUtil));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + categorical_logit_log(get_base1(get_base1(ydata,i,"ydata",1),(t + 1),"ydata",2),multiply(theta,ev))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_A",mu_A,0);
        check_less_or_equal(function__,"mu_A",mu_A,1);
        check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
        check_less_or_equal(function__,"mu_alpha",mu_alpha,2);
        check_greater_or_equal(function__,"mu_cons",mu_cons,0);
        check_less_or_equal(function__,"mu_cons",mu_cons,5);
        check_greater_or_equal(function__,"mu_lambda",mu_lambda,0);
        check_less_or_equal(function__,"mu_lambda",mu_lambda,10);

        // write generated quantities
        vars__.push_back(mu_A);
        vars__.push_back(mu_alpha);
        vars__.push_back(mu_cons);
        vars__.push_back(mu_lambda);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_igt_pvl_decay";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_cons";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_cons";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_igt_pvl_delta_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_igt_pvl_delta : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > rewlos;
    vector<vector<int> > ydata;
    vector_d initV;
public:
    model_igt_pvl_delta(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_igt_pvl_delta(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_igt_pvl_delta_namespace::model_igt_pvl_delta";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "rewlos", "double", context__.to_vec(N,T));
        validate_non_negative_index("rewlos", "N", N);
        validate_non_negative_index("rewlos", "T", T);
        rewlos = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("rewlos");
        pos__ = 0;
        size_t rewlos_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < rewlos_limit_1__; ++i_1__) {
            size_t rewlos_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < rewlos_limit_0__; ++i_0__) {
                rewlos[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "ydata", "int", context__.to_vec(N,T));
        validate_non_negative_index("ydata", "N", N);
        validate_non_negative_index("ydata", "T", T);
        ydata = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("ydata");
        pos__ = 0;
        size_t ydata_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < ydata_limit_1__; ++i_1__) {
            size_t ydata_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < ydata_limit_0__; ++i_0__) {
                ydata[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 4;
        num_params_r__ += 4;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_igt_pvl_delta() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(4));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(4));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("A_pr")))
            throw std::runtime_error("variable A_pr missing");
        vals_r__ = context__.vals_r("A_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "A_pr", "vector_d", context__.to_vec(N));
        // generate_declaration A_pr
        vector_d A_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            A_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(A_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable A_pr: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        // generate_declaration alpha_pr
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("cons_pr")))
            throw std::runtime_error("variable cons_pr missing");
        vals_r__ = context__.vals_r("cons_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "cons_pr", "vector_d", context__.to_vec(N));
        // generate_declaration cons_pr
        vector_d cons_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            cons_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(cons_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable cons_pr: ") + e.what());
        }

        if (!(context__.contains_r("lambda_pr")))
            throw std::runtime_error("variable lambda_pr missing");
        vals_r__ = context__.vals_r("lambda_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "lambda_pr", "vector_d", context__.to_vec(N));
        // generate_declaration lambda_pr
        vector_d lambda_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            lambda_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(lambda_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable lambda_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(4,lp__);
        else
            mu_p = in__.vector_constrain(4);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,4,lp__);
        else
            sigma = in__.vector_lb_constrain(0,4);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  A_pr;
        (void) A_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            A_pr = in__.vector_constrain(N,lp__);
        else
            A_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_pr;
        (void) alpha_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_pr = in__.vector_constrain(N,lp__);
        else
            alpha_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  cons_pr;
        (void) cons_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            cons_pr = in__.vector_constrain(N,lp__);
        else
            cons_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda_pr;
        (void) lambda_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            lambda_pr = in__.vector_constrain(N,lp__);
        else
            lambda_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  A(static_cast<Eigen::VectorXd::Index>(N));
        (void) A;  // dummy to suppress unused var warning
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  cons(static_cast<Eigen::VectorXd::Index>(N));
        (void) cons;  // dummy to suppress unused var warning
        stan::math::initialize(cons, DUMMY_VAR__);
        stan::math::fill(cons,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(A,i,"A",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 2));
                stan::math::assign(get_base1_lhs(cons,i,"cons",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(cons_pr,i,"cons_pr",1)))) * 5));
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,4,"mu_p",1) + (get_base1(sigma,4,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(A(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: A" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(alpha(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(cons(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: cons" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(lambda(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"A",A,0);
        check_less_or_equal(function__,"A",A,1);
        check_greater_or_equal(function__,"alpha",alpha,0);
        check_less_or_equal(function__,"alpha",alpha,2);
        check_greater_or_equal(function__,"cons",cons,0);
        check_less_or_equal(function__,"cons",cons,5);
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,10);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(A_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(cons_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(lambda_pr, 0, 1));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(4));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, DUMMY_VAR__);
                    stan::math::fill(ev,DUMMY_VAR__);
                    T__ curUtil;
                    (void) curUtil;  // dummy to suppress unused var warning
                    stan::math::initialize(curUtil, DUMMY_VAR__);
                    stan::math::fill(curUtil,DUMMY_VAR__);
                    T__ theta;
                    (void) theta;  // dummy to suppress unused var warning
                    stan::math::initialize(theta, DUMMY_VAR__);
                    stan::math::fill(theta,DUMMY_VAR__);


                    stan::math::assign(theta, (pow(3,get_base1(cons,i,"cons",1)) - 1));
                    stan::math::assign(ev, initV);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        if (as_bool(logical_gte(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),0))) {

                            stan::math::assign(curUtil, pow(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),get_base1(alpha,i,"alpha",1)));
                        } else {

                            stan::math::assign(curUtil, ((-(1) * get_base1(lambda,i,"lambda",1)) * pow((-(1) * get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)),get_base1(alpha,i,"alpha",1))));
                        }
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1), (get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1) + (get_base1(A,i,"A",1) * (curUtil - get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1)))));
                        lp_accum__.add(categorical_logit_log<propto__>(get_base1(get_base1(ydata,i,"ydata",1),(t + 1),"ydata",2), multiply(theta,ev)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("A_pr");
        names__.push_back("alpha_pr");
        names__.push_back("cons_pr");
        names__.push_back("lambda_pr");
        names__.push_back("A");
        names__.push_back("alpha");
        names__.push_back("cons");
        names__.push_back("lambda");
        names__.push_back("mu_A");
        names__.push_back("mu_alpha");
        names__.push_back("mu_cons");
        names__.push_back("mu_lambda");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_igt_pvl_delta_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(4);
        vector_d sigma = in__.vector_lb_constrain(0,4);
        vector_d A_pr = in__.vector_constrain(N);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d cons_pr = in__.vector_constrain(N);
        vector_d lambda_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(cons_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d A(static_cast<Eigen::VectorXd::Index>(N));
        (void) A;  // dummy to suppress unused var warning
        stan::math::initialize(A, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(A,DUMMY_VAR__);
        vector_d alpha(static_cast<Eigen::VectorXd::Index>(N));
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        vector_d cons(static_cast<Eigen::VectorXd::Index>(N));
        (void) cons;  // dummy to suppress unused var warning
        stan::math::initialize(cons, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cons,DUMMY_VAR__);
        vector_d lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lambda,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(A,i,"A",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 2));
                stan::math::assign(get_base1_lhs(cons,i,"cons",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(cons_pr,i,"cons_pr",1)))) * 5));
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,4,"mu_p",1) + (get_base1(sigma,4,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"A",A,0);
        check_less_or_equal(function__,"A",A,1);
        check_greater_or_equal(function__,"alpha",alpha,0);
        check_less_or_equal(function__,"alpha",alpha,2);
        check_greater_or_equal(function__,"cons",cons,0);
        check_less_or_equal(function__,"cons",cons,5);
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,10);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(cons[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_A(0.0);
        (void) mu_A;  // dummy to suppress unused var warning
        stan::math::initialize(mu_A, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_A,DUMMY_VAR__);
        double mu_alpha(0.0);
        (void) mu_alpha;  // dummy to suppress unused var warning
        stan::math::initialize(mu_alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_alpha,DUMMY_VAR__);
        double mu_cons(0.0);
        (void) mu_cons;  // dummy to suppress unused var warning
        stan::math::initialize(mu_cons, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_cons,DUMMY_VAR__);
        double mu_lambda(0.0);
        (void) mu_lambda;  // dummy to suppress unused var warning
        stan::math::initialize(mu_lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_lambda,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_A, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_alpha, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 2));
            stan::math::assign(mu_cons, (Phi_approx(get_base1(mu_p,3,"mu_p",1)) * 5));
            stan::math::assign(mu_lambda, (Phi_approx(get_base1(mu_p,4,"mu_p",1)) * 10));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d ev(static_cast<Eigen::VectorXd::Index>(4));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev,DUMMY_VAR__);
                    double curUtil(0.0);
                    (void) curUtil;  // dummy to suppress unused var warning
                    stan::math::initialize(curUtil, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(curUtil,DUMMY_VAR__);
                    double theta(0.0);
                    (void) theta;  // dummy to suppress unused var warning
                    stan::math::initialize(theta, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(theta,DUMMY_VAR__);


                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    stan::math::assign(theta, (pow(3,get_base1(cons,i,"cons",1)) - 1));
                    stan::math::assign(ev, initV);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        if (as_bool(logical_gte(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),0))) {

                            stan::math::assign(curUtil, pow(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),get_base1(alpha,i,"alpha",1)));
                        } else {

                            stan::math::assign(curUtil, ((-(1) * get_base1(lambda,i,"lambda",1)) * pow((-(1) * get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)),get_base1(alpha,i,"alpha",1))));
                        }
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1), (get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1) + (get_base1(A,i,"A",1) * (curUtil - get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1)))));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + categorical_logit_log(get_base1(get_base1(ydata,i,"ydata",1),(t + 1),"ydata",2),multiply(theta,ev))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_A",mu_A,0);
        check_less_or_equal(function__,"mu_A",mu_A,1);
        check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
        check_less_or_equal(function__,"mu_alpha",mu_alpha,2);
        check_greater_or_equal(function__,"mu_cons",mu_cons,0);
        check_less_or_equal(function__,"mu_cons",mu_cons,5);
        check_greater_or_equal(function__,"mu_lambda",mu_lambda,0);
        check_less_or_equal(function__,"mu_lambda",mu_lambda,10);

        // write generated quantities
        vars__.push_back(mu_A);
        vars__.push_back(mu_alpha);
        vars__.push_back(mu_cons);
        vars__.push_back(mu_lambda);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_igt_pvl_delta";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_cons";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_cons";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_igt_vpp_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_igt_vpp : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > rewlos;
    vector<vector<int> > ydata;
    vector_d initV;
public:
    model_igt_vpp(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_igt_vpp(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_igt_vpp_namespace::model_igt_vpp";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "rewlos", "double", context__.to_vec(N,T));
        validate_non_negative_index("rewlos", "N", N);
        validate_non_negative_index("rewlos", "T", T);
        rewlos = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("rewlos");
        pos__ = 0;
        size_t rewlos_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < rewlos_limit_1__; ++i_1__) {
            size_t rewlos_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < rewlos_limit_0__; ++i_0__) {
                rewlos[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "ydata", "int", context__.to_vec(N,T));
        validate_non_negative_index("ydata", "N", N);
        validate_non_negative_index("ydata", "T", T);
        ydata = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("ydata");
        pos__ = 0;
        size_t ydata_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < ydata_limit_1__; ++i_1__) {
            size_t ydata_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < ydata_limit_0__; ++i_0__) {
                ydata[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        // initialize data variables
        validate_non_negative_index("initV", "4", 4);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(4));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,4));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 8;
        num_params_r__ += 8;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_igt_vpp() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(8));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(8));
        for (int j1__ = 0U; j1__ < 8; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(8));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(8));
        for (int j1__ = 0U; j1__ < 8; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("A_pr")))
            throw std::runtime_error("variable A_pr missing");
        vals_r__ = context__.vals_r("A_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "A_pr", "vector_d", context__.to_vec(N));
        // generate_declaration A_pr
        vector_d A_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            A_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(A_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable A_pr: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        // generate_declaration alpha_pr
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("cons_pr")))
            throw std::runtime_error("variable cons_pr missing");
        vals_r__ = context__.vals_r("cons_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "cons_pr", "vector_d", context__.to_vec(N));
        // generate_declaration cons_pr
        vector_d cons_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            cons_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(cons_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable cons_pr: ") + e.what());
        }

        if (!(context__.contains_r("lambda_pr")))
            throw std::runtime_error("variable lambda_pr missing");
        vals_r__ = context__.vals_r("lambda_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "lambda_pr", "vector_d", context__.to_vec(N));
        // generate_declaration lambda_pr
        vector_d lambda_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            lambda_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(lambda_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable lambda_pr: ") + e.what());
        }

        if (!(context__.contains_r("epP_pr")))
            throw std::runtime_error("variable epP_pr missing");
        vals_r__ = context__.vals_r("epP_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "epP_pr", "vector_d", context__.to_vec(N));
        // generate_declaration epP_pr
        vector_d epP_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            epP_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(epP_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable epP_pr: ") + e.what());
        }

        if (!(context__.contains_r("epN_pr")))
            throw std::runtime_error("variable epN_pr missing");
        vals_r__ = context__.vals_r("epN_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "epN_pr", "vector_d", context__.to_vec(N));
        // generate_declaration epN_pr
        vector_d epN_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            epN_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(epN_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable epN_pr: ") + e.what());
        }

        if (!(context__.contains_r("K_pr")))
            throw std::runtime_error("variable K_pr missing");
        vals_r__ = context__.vals_r("K_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "K_pr", "vector_d", context__.to_vec(N));
        // generate_declaration K_pr
        vector_d K_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            K_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(K_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable K_pr: ") + e.what());
        }

        if (!(context__.contains_r("w_pr")))
            throw std::runtime_error("variable w_pr missing");
        vals_r__ = context__.vals_r("w_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "w_pr", "vector_d", context__.to_vec(N));
        // generate_declaration w_pr
        vector_d w_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            w_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(w_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable w_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(8,lp__);
        else
            mu_p = in__.vector_constrain(8);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,8,lp__);
        else
            sigma = in__.vector_lb_constrain(0,8);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  A_pr;
        (void) A_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            A_pr = in__.vector_constrain(N,lp__);
        else
            A_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_pr;
        (void) alpha_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_pr = in__.vector_constrain(N,lp__);
        else
            alpha_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  cons_pr;
        (void) cons_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            cons_pr = in__.vector_constrain(N,lp__);
        else
            cons_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda_pr;
        (void) lambda_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            lambda_pr = in__.vector_constrain(N,lp__);
        else
            lambda_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  epP_pr;
        (void) epP_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            epP_pr = in__.vector_constrain(N,lp__);
        else
            epP_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  epN_pr;
        (void) epN_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            epN_pr = in__.vector_constrain(N,lp__);
        else
            epN_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  K_pr;
        (void) K_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            K_pr = in__.vector_constrain(N,lp__);
        else
            K_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  w_pr;
        (void) w_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            w_pr = in__.vector_constrain(N,lp__);
        else
            w_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  A(static_cast<Eigen::VectorXd::Index>(N));
        (void) A;  // dummy to suppress unused var warning
        stan::math::initialize(A, DUMMY_VAR__);
        stan::math::fill(A,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  cons(static_cast<Eigen::VectorXd::Index>(N));
        (void) cons;  // dummy to suppress unused var warning
        stan::math::initialize(cons, DUMMY_VAR__);
        stan::math::fill(cons,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  epP(static_cast<Eigen::VectorXd::Index>(N));
        (void) epP;  // dummy to suppress unused var warning
        stan::math::initialize(epP, DUMMY_VAR__);
        stan::math::fill(epP,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  epN(static_cast<Eigen::VectorXd::Index>(N));
        (void) epN;  // dummy to suppress unused var warning
        stan::math::initialize(epN, DUMMY_VAR__);
        stan::math::fill(epN,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  K(static_cast<Eigen::VectorXd::Index>(N));
        (void) K;  // dummy to suppress unused var warning
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  w(static_cast<Eigen::VectorXd::Index>(N));
        (void) w;  // dummy to suppress unused var warning
        stan::math::initialize(w, DUMMY_VAR__);
        stan::math::fill(w,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(A,i,"A",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 2));
                stan::math::assign(get_base1_lhs(cons,i,"cons",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(cons_pr,i,"cons_pr",1)))) * 5));
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,4,"mu_p",1) + (get_base1(sigma,4,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 10));
                stan::math::assign(get_base1_lhs(K,i,"K",1), Phi_approx((get_base1(mu_p,7,"mu_p",1) + (get_base1(sigma,7,"sigma",1) * get_base1(K_pr,i,"K_pr",1)))));
                stan::math::assign(get_base1_lhs(w,i,"w",1), Phi_approx((get_base1(mu_p,8,"mu_p",1) + (get_base1(sigma,8,"sigma",1) * get_base1(w_pr,i,"w_pr",1)))));
            }
            stan::math::assign(epP, add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),epP_pr)));
            stan::math::assign(epN, add(get_base1(mu_p,6,"mu_p",1),multiply(get_base1(sigma,6,"sigma",1),epN_pr)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(A(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: A" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(alpha(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(cons(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: cons" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(lambda(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(epP(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: epP" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(epN(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: epN" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(K(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: K" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(w(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: w" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"A",A,0);
        check_less_or_equal(function__,"A",A,1);
        check_greater_or_equal(function__,"alpha",alpha,0);
        check_less_or_equal(function__,"alpha",alpha,2);
        check_greater_or_equal(function__,"cons",cons,0);
        check_less_or_equal(function__,"cons",cons,5);
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,10);
        check_greater_or_equal(function__,"K",K,0);
        check_less_or_equal(function__,"K",K,1);
        check_greater_or_equal(function__,"w",w,0);
        check_less_or_equal(function__,"w",w,1);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,1,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,2,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,3,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,4,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,5,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,6,"mu_p",1), 0, 10.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,7,"mu_p",1), 0, 1.0));
            lp_accum__.add(normal_log<propto__>(get_base1(mu_p,8,"mu_p",1), 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(A_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(cons_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(lambda_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(epP_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(epN_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(K_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(w_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(4));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, DUMMY_VAR__);
                    stan::math::fill(ev,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  p_next(static_cast<Eigen::VectorXd::Index>(4));
                    (void) p_next;  // dummy to suppress unused var warning
                    stan::math::initialize(p_next, DUMMY_VAR__);
                    stan::math::fill(p_next,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  str(static_cast<Eigen::VectorXd::Index>(4));
                    (void) str;  // dummy to suppress unused var warning
                    stan::math::initialize(str, DUMMY_VAR__);
                    stan::math::fill(str,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  pers(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pers;  // dummy to suppress unused var warning
                    stan::math::initialize(pers, DUMMY_VAR__);
                    stan::math::fill(pers,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  V(static_cast<Eigen::VectorXd::Index>(4));
                    (void) V;  // dummy to suppress unused var warning
                    stan::math::initialize(V, DUMMY_VAR__);
                    stan::math::fill(V,DUMMY_VAR__);
                    T__ curUtil;
                    (void) curUtil;  // dummy to suppress unused var warning
                    stan::math::initialize(curUtil, DUMMY_VAR__);
                    stan::math::fill(curUtil,DUMMY_VAR__);
                    T__ theta;
                    (void) theta;  // dummy to suppress unused var warning
                    stan::math::initialize(theta, DUMMY_VAR__);
                    stan::math::fill(theta,DUMMY_VAR__);


                    stan::math::assign(theta, (pow(3,get_base1(cons,i,"cons",1)) - 1));
                    stan::math::assign(ev, initV);
                    stan::math::assign(pers, initV);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        stan::math::assign(pers, multiply(pers,get_base1(K,i,"K",1)));
                        if (as_bool(logical_gte(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),0))) {

                            stan::math::assign(curUtil, pow(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),get_base1(alpha,i,"alpha",1)));
                            stan::math::assign(get_base1_lhs(pers,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"pers",1), (get_base1(pers,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"pers",1) + get_base1(epP,i,"epP",1)));
                        } else {

                            stan::math::assign(curUtil, ((-(1) * get_base1(lambda,i,"lambda",1)) * pow((-(1) * get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)),get_base1(alpha,i,"alpha",1))));
                            stan::math::assign(get_base1_lhs(pers,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"pers",1), (get_base1(pers,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"pers",1) + get_base1(epN,i,"epN",1)));
                        }
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1), (get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1) + (get_base1(A,i,"A",1) * (curUtil - get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1)))));
                        stan::math::assign(V, add(multiply(get_base1(w,i,"w",1),ev),multiply((1 - get_base1(w,i,"w",1)),pers)));
                        lp_accum__.add(categorical_logit_log<propto__>(get_base1(get_base1(ydata,i,"ydata",1),(t + 1),"ydata",2), multiply(theta,V)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("A_pr");
        names__.push_back("alpha_pr");
        names__.push_back("cons_pr");
        names__.push_back("lambda_pr");
        names__.push_back("epP_pr");
        names__.push_back("epN_pr");
        names__.push_back("K_pr");
        names__.push_back("w_pr");
        names__.push_back("A");
        names__.push_back("alpha");
        names__.push_back("cons");
        names__.push_back("lambda");
        names__.push_back("epP");
        names__.push_back("epN");
        names__.push_back("K");
        names__.push_back("w");
        names__.push_back("mu_A");
        names__.push_back("mu_alpha");
        names__.push_back("mu_cons");
        names__.push_back("mu_lambda");
        names__.push_back("mu_epP");
        names__.push_back("mu_epN");
        names__.push_back("mu_K");
        names__.push_back("mu_w");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(8);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(8);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_igt_vpp_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(8);
        vector_d sigma = in__.vector_lb_constrain(0,8);
        vector_d A_pr = in__.vector_constrain(N);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d cons_pr = in__.vector_constrain(N);
        vector_d lambda_pr = in__.vector_constrain(N);
        vector_d epP_pr = in__.vector_constrain(N);
        vector_d epN_pr = in__.vector_constrain(N);
        vector_d K_pr = in__.vector_constrain(N);
        vector_d w_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 8; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 8; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(cons_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(epP_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(epN_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(K_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d A(static_cast<Eigen::VectorXd::Index>(N));
        (void) A;  // dummy to suppress unused var warning
        stan::math::initialize(A, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(A,DUMMY_VAR__);
        vector_d alpha(static_cast<Eigen::VectorXd::Index>(N));
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        vector_d cons(static_cast<Eigen::VectorXd::Index>(N));
        (void) cons;  // dummy to suppress unused var warning
        stan::math::initialize(cons, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cons,DUMMY_VAR__);
        vector_d lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lambda,DUMMY_VAR__);
        vector_d epP(static_cast<Eigen::VectorXd::Index>(N));
        (void) epP;  // dummy to suppress unused var warning
        stan::math::initialize(epP, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(epP,DUMMY_VAR__);
        vector_d epN(static_cast<Eigen::VectorXd::Index>(N));
        (void) epN;  // dummy to suppress unused var warning
        stan::math::initialize(epN, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(epN,DUMMY_VAR__);
        vector_d K(static_cast<Eigen::VectorXd::Index>(N));
        (void) K;  // dummy to suppress unused var warning
        stan::math::initialize(K, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(K,DUMMY_VAR__);
        vector_d w(static_cast<Eigen::VectorXd::Index>(N));
        (void) w;  // dummy to suppress unused var warning
        stan::math::initialize(w, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(w,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(A,i,"A",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(A_pr,i,"A_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 2));
                stan::math::assign(get_base1_lhs(cons,i,"cons",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(cons_pr,i,"cons_pr",1)))) * 5));
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,4,"mu_p",1) + (get_base1(sigma,4,"sigma",1) * get_base1(lambda_pr,i,"lambda_pr",1)))) * 10));
                stan::math::assign(get_base1_lhs(K,i,"K",1), Phi_approx((get_base1(mu_p,7,"mu_p",1) + (get_base1(sigma,7,"sigma",1) * get_base1(K_pr,i,"K_pr",1)))));
                stan::math::assign(get_base1_lhs(w,i,"w",1), Phi_approx((get_base1(mu_p,8,"mu_p",1) + (get_base1(sigma,8,"sigma",1) * get_base1(w_pr,i,"w_pr",1)))));
            }
            stan::math::assign(epP, add(get_base1(mu_p,5,"mu_p",1),multiply(get_base1(sigma,5,"sigma",1),epP_pr)));
            stan::math::assign(epN, add(get_base1(mu_p,6,"mu_p",1),multiply(get_base1(sigma,6,"sigma",1),epN_pr)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"A",A,0);
        check_less_or_equal(function__,"A",A,1);
        check_greater_or_equal(function__,"alpha",alpha,0);
        check_less_or_equal(function__,"alpha",alpha,2);
        check_greater_or_equal(function__,"cons",cons,0);
        check_less_or_equal(function__,"cons",cons,5);
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,10);
        check_greater_or_equal(function__,"K",K,0);
        check_less_or_equal(function__,"K",K,1);
        check_greater_or_equal(function__,"w",w,0);
        check_less_or_equal(function__,"w",w,1);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(cons[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(epP[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(epN[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(K[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_A(0.0);
        (void) mu_A;  // dummy to suppress unused var warning
        stan::math::initialize(mu_A, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_A,DUMMY_VAR__);
        double mu_alpha(0.0);
        (void) mu_alpha;  // dummy to suppress unused var warning
        stan::math::initialize(mu_alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_alpha,DUMMY_VAR__);
        double mu_cons(0.0);
        (void) mu_cons;  // dummy to suppress unused var warning
        stan::math::initialize(mu_cons, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_cons,DUMMY_VAR__);
        double mu_lambda(0.0);
        (void) mu_lambda;  // dummy to suppress unused var warning
        stan::math::initialize(mu_lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_lambda,DUMMY_VAR__);
        double mu_epP(0.0);
        (void) mu_epP;  // dummy to suppress unused var warning
        stan::math::initialize(mu_epP, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_epP,DUMMY_VAR__);
        double mu_epN(0.0);
        (void) mu_epN;  // dummy to suppress unused var warning
        stan::math::initialize(mu_epN, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_epN,DUMMY_VAR__);
        double mu_K(0.0);
        (void) mu_K;  // dummy to suppress unused var warning
        stan::math::initialize(mu_K, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_K,DUMMY_VAR__);
        double mu_w(0.0);
        (void) mu_w;  // dummy to suppress unused var warning
        stan::math::initialize(mu_w, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_w,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_A, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_alpha, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 2));
            stan::math::assign(mu_cons, (Phi_approx(get_base1(mu_p,3,"mu_p",1)) * 5));
            stan::math::assign(mu_lambda, (Phi_approx(get_base1(mu_p,4,"mu_p",1)) * 10));
            stan::math::assign(mu_epP, get_base1(mu_p,5,"mu_p",1));
            stan::math::assign(mu_epN, get_base1(mu_p,6,"mu_p",1));
            stan::math::assign(mu_K, Phi_approx(get_base1(mu_p,7,"mu_p",1)));
            stan::math::assign(mu_w, Phi_approx(get_base1(mu_p,8,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d ev(static_cast<Eigen::VectorXd::Index>(4));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev,DUMMY_VAR__);
                    vector_d p_next(static_cast<Eigen::VectorXd::Index>(4));
                    (void) p_next;  // dummy to suppress unused var warning
                    stan::math::initialize(p_next, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(p_next,DUMMY_VAR__);
                    vector_d str(static_cast<Eigen::VectorXd::Index>(4));
                    (void) str;  // dummy to suppress unused var warning
                    stan::math::initialize(str, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(str,DUMMY_VAR__);
                    vector_d pers(static_cast<Eigen::VectorXd::Index>(4));
                    (void) pers;  // dummy to suppress unused var warning
                    stan::math::initialize(pers, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(pers,DUMMY_VAR__);
                    vector_d V(static_cast<Eigen::VectorXd::Index>(4));
                    (void) V;  // dummy to suppress unused var warning
                    stan::math::initialize(V, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(V,DUMMY_VAR__);
                    double curUtil(0.0);
                    (void) curUtil;  // dummy to suppress unused var warning
                    stan::math::initialize(curUtil, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(curUtil,DUMMY_VAR__);
                    double theta(0.0);
                    (void) theta;  // dummy to suppress unused var warning
                    stan::math::initialize(theta, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(theta,DUMMY_VAR__);


                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    stan::math::assign(theta, (pow(3,get_base1(cons,i,"cons",1)) - 1));
                    stan::math::assign(ev, initV);
                    stan::math::assign(pers, initV);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        stan::math::assign(pers, multiply(pers,get_base1(K,i,"K",1)));
                        if (as_bool(logical_gte(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),0))) {

                            stan::math::assign(curUtil, pow(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2),get_base1(alpha,i,"alpha",1)));
                            stan::math::assign(get_base1_lhs(pers,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"pers",1), (get_base1(pers,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"pers",1) + get_base1(epP,i,"epP",1)));
                        } else {

                            stan::math::assign(curUtil, ((-(1) * get_base1(lambda,i,"lambda",1)) * pow((-(1) * get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)),get_base1(alpha,i,"alpha",1))));
                            stan::math::assign(get_base1_lhs(pers,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"pers",1), (get_base1(pers,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"pers",1) + get_base1(epN,i,"epN",1)));
                        }
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1), (get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1) + (get_base1(A,i,"A",1) * (curUtil - get_base1(ev,get_base1(get_base1(ydata,i,"ydata",1),t,"ydata",2),"ev",1)))));
                        stan::math::assign(V, add(multiply(get_base1(w,i,"w",1),ev),multiply((1 - get_base1(w,i,"w",1)),pers)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + categorical_logit_log(get_base1(get_base1(ydata,i,"ydata",1),(t + 1),"ydata",2),multiply(theta,V))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_A",mu_A,0);
        check_less_or_equal(function__,"mu_A",mu_A,1);
        check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
        check_less_or_equal(function__,"mu_alpha",mu_alpha,2);
        check_greater_or_equal(function__,"mu_cons",mu_cons,0);
        check_less_or_equal(function__,"mu_cons",mu_cons,5);
        check_greater_or_equal(function__,"mu_lambda",mu_lambda,0);
        check_less_or_equal(function__,"mu_lambda",mu_lambda,10);
        check_greater_or_equal(function__,"mu_K",mu_K,0);
        check_less_or_equal(function__,"mu_K",mu_K,1);
        check_greater_or_equal(function__,"mu_w",mu_w,0);
        check_less_or_equal(function__,"mu_w",mu_w,1);

        // write generated quantities
        vars__.push_back(mu_A);
        vars__.push_back(mu_alpha);
        vars__.push_back(mu_cons);
        vars__.push_back(mu_lambda);
        vars__.push_back(mu_epP);
        vars__.push_back(mu_epN);
        vars__.push_back(mu_K);
        vars__.push_back(mu_w);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_igt_vpp";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 8; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 8; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epP_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epN_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "K_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epP" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epN" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "K" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_cons";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_epP";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_epN";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_K";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 8; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 8; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epP_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epN_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "K_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cons" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epP" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epN" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "K" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_cons";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_epP";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_epN";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_K";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_prl_ewa_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_prl_ewa : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > choice;
    vector<vector<double> > rewlos;
    vector_d init;
public:
    model_prl_ewa(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_prl_ewa(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_prl_ewa_namespace::model_prl_ewa";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
        validate_non_negative_index("choice", "N", N);
        validate_non_negative_index("choice", "T", T);
        choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("choice");
        pos__ = 0;
        size_t choice_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
            size_t choice_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                choice[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "rewlos", "double", context__.to_vec(N,T));
        validate_non_negative_index("rewlos", "N", N);
        validate_non_negative_index("rewlos", "T", T);
        rewlos = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("rewlos");
        pos__ = 0;
        size_t rewlos_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < rewlos_limit_1__; ++i_1__) {
            size_t rewlos_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < rewlos_limit_0__; ++i_0__) {
                rewlos[i_0__][i_1__] = vals_r__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
                check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],2);
            }
        }
        // initialize data variables
        validate_non_negative_index("init", "2", 2);
        init = vector_d(static_cast<Eigen::VectorXd::Index>(2));
        stan::math::fill(init,DUMMY_VAR__);

        try {
            stan::math::assign(init, rep_vector(0.0,2));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 3;
        num_params_r__ += 3;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_prl_ewa() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(3));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("phi_pr")))
            throw std::runtime_error("variable phi_pr missing");
        vals_r__ = context__.vals_r("phi_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "phi_pr", "vector_d", context__.to_vec(N));
        // generate_declaration phi_pr
        vector_d phi_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            phi_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(phi_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi_pr: ") + e.what());
        }

        if (!(context__.contains_r("rho_pr")))
            throw std::runtime_error("variable rho_pr missing");
        vals_r__ = context__.vals_r("rho_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho_pr", "vector_d", context__.to_vec(N));
        // generate_declaration rho_pr
        vector_d rho_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        // generate_declaration beta_pr
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(3,lp__);
        else
            mu_p = in__.vector_constrain(3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,3,lp__);
        else
            sigma = in__.vector_lb_constrain(0,3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  phi_pr;
        (void) phi_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            phi_pr = in__.vector_constrain(N,lp__);
        else
            phi_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho_pr;
        (void) rho_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            rho_pr = in__.vector_constrain(N,lp__);
        else
            rho_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_pr;
        (void) beta_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_pr = in__.vector_constrain(N,lp__);
        else
            beta_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  phi(static_cast<Eigen::VectorXd::Index>(N));
        (void) phi;  // dummy to suppress unused var warning
        stan::math::initialize(phi, DUMMY_VAR__);
        stan::math::fill(phi,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, DUMMY_VAR__);
        stan::math::fill(rho,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(phi,i,"phi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(phi_pr,i,"phi_pr",1)))));
                stan::math::assign(get_base1_lhs(rho,i,"rho",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(rho_pr,i,"rho_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(phi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: phi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rho(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"phi",phi,0);
        check_less_or_equal(function__,"phi",phi,1);
        check_greater_or_equal(function__,"rho",rho,0);
        check_less_or_equal(function__,"rho",rho,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,10);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(phi_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(rho_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, DUMMY_VAR__);
                    stan::math::fill(ev,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  ew(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ew;  // dummy to suppress unused var warning
                    stan::math::initialize(ew, DUMMY_VAR__);
                    stan::math::fill(ew,DUMMY_VAR__);
                    T__ ewt1;
                    (void) ewt1;  // dummy to suppress unused var warning
                    stan::math::initialize(ewt1, DUMMY_VAR__);
                    stan::math::fill(ewt1,DUMMY_VAR__);


                    stan::math::assign(ev, init);
                    stan::math::assign(ew, init);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        stan::math::assign(ewt1, get_base1(ew,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ew",1));
                        stan::math::assign(get_base1_lhs(ew,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ew",1), ((get_base1(ew,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ew",1) * get_base1(rho,i,"rho",1)) + 1));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1), ((((get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1) * get_base1(phi,i,"phi",1)) * ewt1) + get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)) / get_base1(ew,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ew",1)));
                        lp_accum__.add(categorical_logit_log<propto__>(get_base1(get_base1(choice,i,"choice",1),(t + 1),"choice",2), multiply(ev,get_base1(beta,i,"beta",1))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("phi_pr");
        names__.push_back("rho_pr");
        names__.push_back("beta_pr");
        names__.push_back("phi");
        names__.push_back("rho");
        names__.push_back("beta");
        names__.push_back("mu_phi");
        names__.push_back("mu_rho");
        names__.push_back("mu_beta");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_prl_ewa_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d phi_pr = in__.vector_constrain(N);
        vector_d rho_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(phi_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d phi(static_cast<Eigen::VectorXd::Index>(N));
        (void) phi;  // dummy to suppress unused var warning
        stan::math::initialize(phi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phi,DUMMY_VAR__);
        vector_d rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);
        vector_d beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(phi,i,"phi",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(phi_pr,i,"phi_pr",1)))));
                stan::math::assign(get_base1_lhs(rho,i,"rho",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(rho_pr,i,"rho_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"phi",phi,0);
        check_less_or_equal(function__,"phi",phi,1);
        check_greater_or_equal(function__,"rho",rho,0);
        check_less_or_equal(function__,"rho",rho,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,10);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(phi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_phi(0.0);
        (void) mu_phi;  // dummy to suppress unused var warning
        stan::math::initialize(mu_phi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_phi,DUMMY_VAR__);
        double mu_rho(0.0);
        (void) mu_rho;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rho,DUMMY_VAR__);
        double mu_beta(0.0);
        (void) mu_beta;  // dummy to suppress unused var warning
        stan::math::initialize(mu_beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_beta,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_phi, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_rho, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_beta, (Phi_approx(get_base1(mu_p,3,"mu_p",1)) * 10));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d ev(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev,DUMMY_VAR__);
                    vector_d ew(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ew;  // dummy to suppress unused var warning
                    stan::math::initialize(ew, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ew,DUMMY_VAR__);
                    double ewt1(0.0);
                    (void) ewt1;  // dummy to suppress unused var warning
                    stan::math::initialize(ewt1, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ewt1,DUMMY_VAR__);


                    stan::math::assign(ev, init);
                    stan::math::assign(ew, init);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        stan::math::assign(ewt1, get_base1(ew,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ew",1));
                        stan::math::assign(get_base1_lhs(ew,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ew",1), ((get_base1(ew,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ew",1) * get_base1(rho,i,"rho",1)) + 1));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1), ((((get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1) * get_base1(phi,i,"phi",1)) * ewt1) + get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)) / get_base1(ew,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ew",1)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + categorical_logit_log(get_base1(get_base1(choice,i,"choice",1),(t + 1),"choice",2),multiply(ev,get_base1(beta,i,"beta",1)))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_phi",mu_phi,0);
        check_less_or_equal(function__,"mu_phi",mu_phi,1);
        check_greater_or_equal(function__,"mu_rho",mu_rho,0);
        check_less_or_equal(function__,"mu_rho",mu_rho,1);
        check_greater_or_equal(function__,"mu_beta",mu_beta,0);
        check_less_or_equal(function__,"mu_beta",mu_beta,10);

        // write generated quantities
        vars__.push_back(mu_phi);
        vars__.push_back(mu_rho);
        vars__.push_back(mu_beta);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_prl_ewa";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_phi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_phi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_prl_fictitious_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_prl_fictitious : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > choice;
    vector<vector<double> > rewlos;
    vector_d initV;
public:
    model_prl_fictitious(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_prl_fictitious(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_prl_fictitious_namespace::model_prl_fictitious";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
        validate_non_negative_index("choice", "N", N);
        validate_non_negative_index("choice", "T", T);
        choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("choice");
        pos__ = 0;
        size_t choice_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
            size_t choice_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                choice[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "rewlos", "double", context__.to_vec(N,T));
        validate_non_negative_index("rewlos", "N", N);
        validate_non_negative_index("rewlos", "T", T);
        rewlos = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("rewlos");
        pos__ = 0;
        size_t rewlos_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < rewlos_limit_1__; ++i_1__) {
            size_t rewlos_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < rewlos_limit_0__; ++i_0__) {
                rewlos[i_0__][i_1__] = vals_r__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
                check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],2);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "2", 2);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(2));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,2));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 3;
        num_params_r__ += 3;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_prl_fictitious() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(3));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("eta_pr")))
            throw std::runtime_error("variable eta_pr missing");
        vals_r__ = context__.vals_r("eta_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "eta_pr", "vector_d", context__.to_vec(N));
        // generate_declaration eta_pr
        vector_d eta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            eta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(eta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable eta_pr: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        // generate_declaration alpha_pr
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        // generate_declaration beta_pr
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(3,lp__);
        else
            mu_p = in__.vector_constrain(3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,3,lp__);
        else
            sigma = in__.vector_lb_constrain(0,3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  eta_pr;
        (void) eta_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            eta_pr = in__.vector_constrain(N,lp__);
        else
            eta_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_pr;
        (void) alpha_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_pr = in__.vector_constrain(N,lp__);
        else
            alpha_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_pr;
        (void) beta_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_pr = in__.vector_constrain(N,lp__);
        else
            beta_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(N));
        (void) eta;  // dummy to suppress unused var warning
        stan::math::initialize(eta, DUMMY_VAR__);
        stan::math::fill(eta,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(eta,i,"eta",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(eta_pr,i,"eta_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(eta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: eta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(alpha(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"eta",eta,0);
        check_less_or_equal(function__,"eta",eta,1);
        check_greater_or_equal(function__,"alpha",alpha,0);
        check_less_or_equal(function__,"alpha",alpha,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,5);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(eta_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, DUMMY_VAR__);
                    stan::math::fill(ev,DUMMY_VAR__);
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  prob(static_cast<Eigen::VectorXd::Index>(2));
                    (void) prob;  // dummy to suppress unused var warning
                    stan::math::initialize(prob, DUMMY_VAR__);
                    stan::math::fill(prob,DUMMY_VAR__);
                    T__ PE;
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, DUMMY_VAR__);
                    stan::math::fill(PE,DUMMY_VAR__);
                    T__ PEnc;
                    (void) PEnc;  // dummy to suppress unused var warning
                    stan::math::initialize(PEnc, DUMMY_VAR__);
                    stan::math::fill(PEnc,DUMMY_VAR__);


                    stan::math::assign(ev, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(prob,1,"prob",1), (1 / (1 + exp((get_base1(beta,i,"beta",1) * (get_base1(alpha,i,"alpha",1) - (get_base1(ev,1,"ev",1) - get_base1(ev,2,"ev",1))))))));
                        stan::math::assign(get_base1_lhs(prob,2,"prob",1), (1 - get_base1(prob,1,"prob",1)));
                        lp_accum__.add(categorical_log<propto__>(get_base1(get_base1(choice,i,"choice",1),t,"choice",2), prob));
                        stan::math::assign(PE, (get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2) - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)));
                        stan::math::assign(PEnc, (-(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)) - get_base1(ev,(3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2)),"ev",1)));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1), (get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1) + (get_base1(eta,i,"eta",1) * PE)));
                        stan::math::assign(get_base1_lhs(ev,(3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2)),"ev",1), (get_base1(ev,(3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2)),"ev",1) + (get_base1(eta,i,"eta",1) * PEnc)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("eta_pr");
        names__.push_back("alpha_pr");
        names__.push_back("beta_pr");
        names__.push_back("eta");
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("mu_eta");
        names__.push_back("mu_alpha");
        names__.push_back("mu_beta");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_prl_fictitious_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d eta_pr = in__.vector_constrain(N);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(eta_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d eta(static_cast<Eigen::VectorXd::Index>(N));
        (void) eta;  // dummy to suppress unused var warning
        stan::math::initialize(eta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(eta,DUMMY_VAR__);
        vector_d alpha(static_cast<Eigen::VectorXd::Index>(N));
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        vector_d beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(eta,i,"eta",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(eta_pr,i,"eta_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 5));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"eta",eta,0);
        check_less_or_equal(function__,"eta",eta,1);
        check_greater_or_equal(function__,"alpha",alpha,0);
        check_less_or_equal(function__,"alpha",alpha,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,5);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(eta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_eta(0.0);
        (void) mu_eta;  // dummy to suppress unused var warning
        stan::math::initialize(mu_eta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_eta,DUMMY_VAR__);
        double mu_alpha(0.0);
        (void) mu_alpha;  // dummy to suppress unused var warning
        stan::math::initialize(mu_alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_alpha,DUMMY_VAR__);
        double mu_beta(0.0);
        (void) mu_beta;  // dummy to suppress unused var warning
        stan::math::initialize(mu_beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_beta,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_eta, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_alpha, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_beta, (Phi_approx(get_base1(mu_p,3,"mu_p",1)) * 5));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d ev(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev,DUMMY_VAR__);
                    vector_d prob(static_cast<Eigen::VectorXd::Index>(2));
                    (void) prob;  // dummy to suppress unused var warning
                    stan::math::initialize(prob, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(prob,DUMMY_VAR__);
                    double PE(0.0);
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(PE,DUMMY_VAR__);
                    double PEnc(0.0);
                    (void) PEnc;  // dummy to suppress unused var warning
                    stan::math::initialize(PEnc, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(PEnc,DUMMY_VAR__);


                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    stan::math::assign(ev, initV);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(get_base1_lhs(prob,1,"prob",1), (1 / (1 + exp((get_base1(beta,i,"beta",1) * (get_base1(alpha,i,"alpha",1) - (get_base1(ev,1,"ev",1) - get_base1(ev,2,"ev",1))))))));
                        stan::math::assign(get_base1_lhs(prob,2,"prob",1), (1 - get_base1(prob,1,"prob",1)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + categorical_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),prob)));
                        stan::math::assign(PE, (get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2) - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)));
                        stan::math::assign(PEnc, (-(get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)) - get_base1(ev,(3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2)),"ev",1)));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1), (get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1) + (get_base1(eta,i,"eta",1) * PE)));
                        stan::math::assign(get_base1_lhs(ev,(3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2)),"ev",1), (get_base1(ev,(3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2)),"ev",1) + (get_base1(eta,i,"eta",1) * PEnc)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_eta",mu_eta,0);
        check_less_or_equal(function__,"mu_eta",mu_eta,1);
        check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
        check_less_or_equal(function__,"mu_alpha",mu_alpha,1);
        check_greater_or_equal(function__,"mu_beta",mu_beta,0);
        check_less_or_equal(function__,"mu_beta",mu_beta,5);

        // write generated quantities
        vars__.push_back(mu_eta);
        vars__.push_back(mu_alpha);
        vars__.push_back(mu_beta);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_prl_fictitious";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_prl_rp_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_prl_rp : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > choice;
    vector<vector<double> > rewlos;
    vector_d initV;
public:
    model_prl_rp(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_prl_rp(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_prl_rp_namespace::model_prl_rp";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
        validate_non_negative_index("choice", "N", N);
        validate_non_negative_index("choice", "T", T);
        choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("choice");
        pos__ = 0;
        size_t choice_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
            size_t choice_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                choice[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "rewlos", "double", context__.to_vec(N,T));
        validate_non_negative_index("rewlos", "N", N);
        validate_non_negative_index("rewlos", "T", T);
        rewlos = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("rewlos");
        pos__ = 0;
        size_t rewlos_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < rewlos_limit_1__; ++i_1__) {
            size_t rewlos_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < rewlos_limit_0__; ++i_0__) {
                rewlos[i_0__][i_1__] = vals_r__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],1);
                check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],2);
            }
        }
        // initialize data variables
        validate_non_negative_index("initV", "2", 2);
        initV = vector_d(static_cast<Eigen::VectorXd::Index>(2));
        stan::math::fill(initV,DUMMY_VAR__);

        try {
            stan::math::assign(initV, rep_vector(0.0,2));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 3;
        num_params_r__ += 3;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_prl_rp() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(3));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("Apun_pr")))
            throw std::runtime_error("variable Apun_pr missing");
        vals_r__ = context__.vals_r("Apun_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "Apun_pr", "vector_d", context__.to_vec(N));
        // generate_declaration Apun_pr
        vector_d Apun_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            Apun_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(Apun_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable Apun_pr: ") + e.what());
        }

        if (!(context__.contains_r("Arew_pr")))
            throw std::runtime_error("variable Arew_pr missing");
        vals_r__ = context__.vals_r("Arew_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "Arew_pr", "vector_d", context__.to_vec(N));
        // generate_declaration Arew_pr
        vector_d Arew_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            Arew_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(Arew_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable Arew_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        // generate_declaration beta_pr
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(3,lp__);
        else
            mu_p = in__.vector_constrain(3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,3,lp__);
        else
            sigma = in__.vector_lb_constrain(0,3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  Apun_pr;
        (void) Apun_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            Apun_pr = in__.vector_constrain(N,lp__);
        else
            Apun_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  Arew_pr;
        (void) Arew_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            Arew_pr = in__.vector_constrain(N,lp__);
        else
            Arew_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta_pr;
        (void) beta_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            beta_pr = in__.vector_constrain(N,lp__);
        else
            beta_pr = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  Apun(static_cast<Eigen::VectorXd::Index>(N));
        (void) Apun;  // dummy to suppress unused var warning
        stan::math::initialize(Apun, DUMMY_VAR__);
        stan::math::fill(Apun,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  Arew(static_cast<Eigen::VectorXd::Index>(N));
        (void) Arew;  // dummy to suppress unused var warning
        stan::math::initialize(Arew, DUMMY_VAR__);
        stan::math::fill(Arew,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(Apun,i,"Apun",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(Apun_pr,i,"Apun_pr",1)))));
                stan::math::assign(get_base1_lhs(Arew,i,"Arew",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(Arew_pr,i,"Arew_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(Apun(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: Apun" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(Arew(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: Arew" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(beta(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"Apun",Apun,0);
        check_less_or_equal(function__,"Apun",Apun,1);
        check_greater_or_equal(function__,"Arew",Arew,0);
        check_less_or_equal(function__,"Arew",Arew,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,10);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(Apun_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(Arew_pr, 0, 1));
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            for (int i = 1; i <= N; ++i) {
                {
                    Eigen::Matrix<T__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, DUMMY_VAR__);
                    stan::math::fill(ev,DUMMY_VAR__);
                    T__ PE;
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, DUMMY_VAR__);
                    stan::math::fill(PE,DUMMY_VAR__);


                    stan::math::assign(ev, initV);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        stan::math::assign(PE, (get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2) - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1), ((get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1) + ((get_base1(Apun,i,"Apun",1) * (1 - get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2))) * PE)) + ((get_base1(Arew,i,"Arew",1) * get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)) * PE)));
                        lp_accum__.add(categorical_logit_log<propto__>(get_base1(get_base1(choice,i,"choice",1),(t + 1),"choice",2), multiply(ev,get_base1(beta,i,"beta",1))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("Apun_pr");
        names__.push_back("Arew_pr");
        names__.push_back("beta_pr");
        names__.push_back("Apun");
        names__.push_back("Arew");
        names__.push_back("beta");
        names__.push_back("mu_Apun");
        names__.push_back("mu_Arew");
        names__.push_back("mu_beta");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_prl_rp_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d Apun_pr = in__.vector_constrain(N);
        vector_d Arew_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Apun_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Arew_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d Apun(static_cast<Eigen::VectorXd::Index>(N));
        (void) Apun;  // dummy to suppress unused var warning
        stan::math::initialize(Apun, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Apun,DUMMY_VAR__);
        vector_d Arew(static_cast<Eigen::VectorXd::Index>(N));
        (void) Arew;  // dummy to suppress unused var warning
        stan::math::initialize(Arew, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Arew,DUMMY_VAR__);
        vector_d beta(static_cast<Eigen::VectorXd::Index>(N));
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(Apun,i,"Apun",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(Apun_pr,i,"Apun_pr",1)))));
                stan::math::assign(get_base1_lhs(Arew,i,"Arew",1), Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(Arew_pr,i,"Arew_pr",1)))));
                stan::math::assign(get_base1_lhs(beta,i,"beta",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"Apun",Apun,0);
        check_less_or_equal(function__,"Apun",Apun,1);
        check_greater_or_equal(function__,"Arew",Arew,0);
        check_less_or_equal(function__,"Arew",Arew,1);
        check_greater_or_equal(function__,"beta",beta,0);
        check_less_or_equal(function__,"beta",beta,10);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Apun[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Arew[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_Apun(0.0);
        (void) mu_Apun;  // dummy to suppress unused var warning
        stan::math::initialize(mu_Apun, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_Apun,DUMMY_VAR__);
        double mu_Arew(0.0);
        (void) mu_Arew;  // dummy to suppress unused var warning
        stan::math::initialize(mu_Arew, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_Arew,DUMMY_VAR__);
        double mu_beta(0.0);
        (void) mu_beta;  // dummy to suppress unused var warning
        stan::math::initialize(mu_beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_beta,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_Apun, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_Arew, Phi_approx(get_base1(mu_p,2,"mu_p",1)));
            stan::math::assign(mu_beta, (Phi_approx(get_base1(mu_p,3,"mu_p",1)) * 10));

            for (int i = 1; i <= N; ++i) {
                {
                    vector_d ev(static_cast<Eigen::VectorXd::Index>(2));
                    (void) ev;  // dummy to suppress unused var warning
                    stan::math::initialize(ev, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(ev,DUMMY_VAR__);
                    double PE(0.0);
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(PE,DUMMY_VAR__);


                    stan::math::assign(ev, initV);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= (get_base1(Tsubj,i,"Tsubj",1) - 1); ++t) {

                        stan::math::assign(PE, (get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2) - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)));
                        stan::math::assign(get_base1_lhs(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1), ((get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1) + ((get_base1(Apun,i,"Apun",1) * (1 - get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2))) * PE)) + ((get_base1(Arew,i,"Arew",1) * get_base1(get_base1(rewlos,i,"rewlos",1),t,"rewlos",2)) * PE)));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + categorical_logit_log(get_base1(get_base1(choice,i,"choice",1),(t + 1),"choice",2),multiply(ev,get_base1(beta,i,"beta",1)))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_Apun",mu_Apun,0);
        check_less_or_equal(function__,"mu_Apun",mu_Apun,1);
        check_greater_or_equal(function__,"mu_Arew",mu_Arew,0);
        check_less_or_equal(function__,"mu_Arew",mu_Arew,1);
        check_greater_or_equal(function__,"mu_beta",mu_beta,0);
        check_less_or_equal(function__,"mu_beta",mu_beta,10);

        // write generated quantities
        vars__.push_back(mu_Apun);
        vars__.push_back(mu_Arew);
        vars__.push_back(mu_beta);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_prl_rp";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Apun_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Arew_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Apun" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Arew" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Apun";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Arew";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Apun_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Arew_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Apun" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Arew" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Apun";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Arew";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_ra_noLA_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_ra_noLA : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > gamble;
    vector<vector<double> > gain;
    vector<vector<double> > cert;
    vector<vector<double> > loss;
public:
    model_ra_noLA(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_ra_noLA(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_ra_noLA_namespace::model_ra_noLA";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "gamble", "int", context__.to_vec(N,T));
        validate_non_negative_index("gamble", "N", N);
        validate_non_negative_index("gamble", "T", T);
        gamble = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("gamble");
        pos__ = 0;
        size_t gamble_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < gamble_limit_1__; ++i_1__) {
            size_t gamble_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < gamble_limit_0__; ++i_0__) {
                gamble[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "gain", "double", context__.to_vec(N,T));
        validate_non_negative_index("gain", "N", N);
        validate_non_negative_index("gain", "T", T);
        gain = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("gain");
        pos__ = 0;
        size_t gain_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < gain_limit_1__; ++i_1__) {
            size_t gain_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < gain_limit_0__; ++i_0__) {
                gain[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cert", "double", context__.to_vec(N,T));
        validate_non_negative_index("cert", "N", N);
        validate_non_negative_index("cert", "T", T);
        cert = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("cert");
        pos__ = 0;
        size_t cert_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cert_limit_1__; ++i_1__) {
            size_t cert_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cert_limit_0__; ++i_0__) {
                cert[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "loss", "double", context__.to_vec(N,T));
        validate_non_negative_index("loss", "N", N);
        validate_non_negative_index("loss", "T", T);
        loss = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("loss");
        pos__ = 0;
        size_t loss_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < loss_limit_1__; ++i_1__) {
            size_t loss_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < loss_limit_0__; ++i_0__) {
                loss[i_0__][i_1__] = vals_r__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],0);
                check_less_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"gain[k0__][k1__]",gain[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"loss[k0__][k1__]",loss[k0__][k1__],0);
            }
        }
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 2;
        num_params_r__ += 2;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_ra_noLA() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(2));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(2));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("rho_p")))
            throw std::runtime_error("variable rho_p missing");
        vals_r__ = context__.vals_r("rho_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho_p", "vector_d", context__.to_vec(N));
        // generate_declaration rho_p
        vector_d rho_p(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_p: ") + e.what());
        }

        if (!(context__.contains_r("tau_p")))
            throw std::runtime_error("variable tau_p missing");
        vals_r__ = context__.vals_r("tau_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau_p", "vector_d", context__.to_vec(N));
        // generate_declaration tau_p
        vector_d tau_p(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_p: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(2,lp__);
        else
            mu_p = in__.vector_constrain(2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,2,lp__);
        else
            sigma = in__.vector_lb_constrain(0,2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho_p;
        (void) rho_p;  // dummy to suppress unused var warning
        if (jacobian__)
            rho_p = in__.vector_constrain(N,lp__);
        else
            rho_p = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau_p;
        (void) tau_p;  // dummy to suppress unused var warning
        if (jacobian__)
            tau_p = in__.vector_constrain(N,lp__);
        else
            tau_p = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, DUMMY_VAR__);
        stan::math::fill(rho,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(rho,i,"rho",1), (Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(rho_p,i,"rho_p",1)))) * 2));
            }
            stan::math::assign(tau, exp(add(get_base1(mu_p,2,"mu_p",1),multiply(get_base1(sigma,2,"sigma",1),tau_p))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rho(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(tau(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"rho",rho,0);
        check_less_or_equal(function__,"rho",rho,2);
        check_greater_or_equal(function__,"tau",tau,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(rho_p, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(tau_p, 0, 1.0));
            for (int i = 1; i <= N; ++i) {

                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                        T__ evSafe;
                        (void) evSafe;  // dummy to suppress unused var warning
                        stan::math::initialize(evSafe, DUMMY_VAR__);
                        stan::math::fill(evSafe,DUMMY_VAR__);
                        T__ evGamble;
                        (void) evGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(evGamble, DUMMY_VAR__);
                        stan::math::fill(evGamble,DUMMY_VAR__);
                        T__ pGamble;
                        (void) pGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(pGamble, DUMMY_VAR__);
                        stan::math::fill(pGamble,DUMMY_VAR__);


                        stan::math::assign(evSafe, pow(get_base1(get_base1(cert,i,"cert",1),t,"cert",2),get_base1(rho,i,"rho",1)));
                        stan::math::assign(evGamble, (0.5 * (pow(get_base1(get_base1(gain,i,"gain",1),t,"gain",2),get_base1(rho,i,"rho",1)) - pow(get_base1(get_base1(loss,i,"loss",1),t,"loss",2),get_base1(rho,i,"rho",1)))));
                        stan::math::assign(pGamble, inv_logit((get_base1(tau,i,"tau",1) * (evGamble - evSafe))));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2), pGamble));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("rho_p");
        names__.push_back("tau_p");
        names__.push_back("rho");
        names__.push_back("tau");
        names__.push_back("mu_rho");
        names__.push_back("mu_tau");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_ra_noLA_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(2);
        vector_d sigma = in__.vector_lb_constrain(0,2);
        vector_d rho_p = in__.vector_constrain(N);
        vector_d tau_p = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_p[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);
        vector_d tau(static_cast<Eigen::VectorXd::Index>(N));
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(rho,i,"rho",1), (Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(rho_p,i,"rho_p",1)))) * 2));
            }
            stan::math::assign(tau, exp(add(get_base1(mu_p,2,"mu_p",1),multiply(get_base1(sigma,2,"sigma",1),tau_p))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"rho",rho,0);
        check_less_or_equal(function__,"rho",rho,2);
        check_greater_or_equal(function__,"tau",tau,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_rho(0.0);
        (void) mu_rho;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rho,DUMMY_VAR__);
        double mu_tau(0.0);
        (void) mu_tau;  // dummy to suppress unused var warning
        stan::math::initialize(mu_tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_tau,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_rho, (Phi_approx(get_base1(mu_p,1,"mu_p",1)) * 2));
            stan::math::assign(mu_tau, exp(get_base1(mu_p,2,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                        double evSafe(0.0);
                        (void) evSafe;  // dummy to suppress unused var warning
                        stan::math::initialize(evSafe, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(evSafe,DUMMY_VAR__);
                        double evGamble(0.0);
                        (void) evGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(evGamble, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(evGamble,DUMMY_VAR__);
                        double pGamble(0.0);
                        (void) pGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(pGamble, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(pGamble,DUMMY_VAR__);


                        stan::math::assign(evSafe, pow(get_base1(get_base1(cert,i,"cert",1),t,"cert",2),get_base1(rho,i,"rho",1)));
                        stan::math::assign(evGamble, (0.5 * (pow(get_base1(get_base1(gain,i,"gain",1),t,"gain",2),get_base1(rho,i,"rho",1)) - pow(get_base1(get_base1(loss,i,"loss",1),t,"loss",2),get_base1(rho,i,"rho",1)))));
                        stan::math::assign(pGamble, inv_logit((get_base1(tau,i,"tau",1) * (evGamble - evSafe))));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2),pGamble)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_rho",mu_rho,0);
        check_less_or_equal(function__,"mu_rho",mu_rho,2);
        check_greater_or_equal(function__,"mu_tau",mu_tau,0);

        // write generated quantities
        vars__.push_back(mu_rho);
        vars__.push_back(mu_tau);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ra_noLA";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_ra_noRA_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_ra_noRA : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > gamble;
    vector<vector<double> > gain;
    vector<vector<double> > cert;
    vector<vector<double> > loss;
public:
    model_ra_noRA(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_ra_noRA(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_ra_noRA_namespace::model_ra_noRA";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "gamble", "int", context__.to_vec(N,T));
        validate_non_negative_index("gamble", "N", N);
        validate_non_negative_index("gamble", "T", T);
        gamble = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("gamble");
        pos__ = 0;
        size_t gamble_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < gamble_limit_1__; ++i_1__) {
            size_t gamble_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < gamble_limit_0__; ++i_0__) {
                gamble[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "gain", "double", context__.to_vec(N,T));
        validate_non_negative_index("gain", "N", N);
        validate_non_negative_index("gain", "T", T);
        gain = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("gain");
        pos__ = 0;
        size_t gain_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < gain_limit_1__; ++i_1__) {
            size_t gain_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < gain_limit_0__; ++i_0__) {
                gain[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cert", "double", context__.to_vec(N,T));
        validate_non_negative_index("cert", "N", N);
        validate_non_negative_index("cert", "T", T);
        cert = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("cert");
        pos__ = 0;
        size_t cert_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cert_limit_1__; ++i_1__) {
            size_t cert_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cert_limit_0__; ++i_0__) {
                cert[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "loss", "double", context__.to_vec(N,T));
        validate_non_negative_index("loss", "N", N);
        validate_non_negative_index("loss", "T", T);
        loss = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("loss");
        pos__ = 0;
        size_t loss_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < loss_limit_1__; ++i_1__) {
            size_t loss_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < loss_limit_0__; ++i_0__) {
                loss[i_0__][i_1__] = vals_r__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],0);
                check_less_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"gain[k0__][k1__]",gain[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"loss[k0__][k1__]",loss[k0__][k1__],0);
            }
        }
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 2;
        num_params_r__ += 2;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_ra_noRA() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(2));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(2));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("lambda_p")))
            throw std::runtime_error("variable lambda_p missing");
        vals_r__ = context__.vals_r("lambda_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "lambda_p", "vector_d", context__.to_vec(N));
        // generate_declaration lambda_p
        vector_d lambda_p(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            lambda_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(lambda_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable lambda_p: ") + e.what());
        }

        if (!(context__.contains_r("tau_p")))
            throw std::runtime_error("variable tau_p missing");
        vals_r__ = context__.vals_r("tau_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau_p", "vector_d", context__.to_vec(N));
        // generate_declaration tau_p
        vector_d tau_p(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_p: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(2,lp__);
        else
            mu_p = in__.vector_constrain(2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,2,lp__);
        else
            sigma = in__.vector_lb_constrain(0,2);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda_p;
        (void) lambda_p;  // dummy to suppress unused var warning
        if (jacobian__)
            lambda_p = in__.vector_constrain(N,lp__);
        else
            lambda_p = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau_p;
        (void) tau_p;  // dummy to suppress unused var warning
        if (jacobian__)
            tau_p = in__.vector_constrain(N,lp__);
        else
            tau_p = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(lambda_p,i,"lambda_p",1)))) * 5));
            }
            stan::math::assign(tau, exp(add(get_base1(mu_p,2,"mu_p",1),multiply(get_base1(sigma,2,"sigma",1),tau_p))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(lambda(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(tau(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,5);
        check_greater_or_equal(function__,"tau",tau,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(lambda_p, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(tau_p, 0, 1.0));
            for (int i = 1; i <= N; ++i) {

                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                        T__ evSafe;
                        (void) evSafe;  // dummy to suppress unused var warning
                        stan::math::initialize(evSafe, DUMMY_VAR__);
                        stan::math::fill(evSafe,DUMMY_VAR__);
                        T__ evGamble;
                        (void) evGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(evGamble, DUMMY_VAR__);
                        stan::math::fill(evGamble,DUMMY_VAR__);
                        T__ pGamble;
                        (void) pGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(pGamble, DUMMY_VAR__);
                        stan::math::fill(pGamble,DUMMY_VAR__);


                        stan::math::assign(evSafe, get_base1(get_base1(cert,i,"cert",1),t,"cert",2));
                        stan::math::assign(evGamble, (0.5 * (get_base1(get_base1(gain,i,"gain",1),t,"gain",2) - (get_base1(lambda,i,"lambda",1) * get_base1(get_base1(loss,i,"loss",1),t,"loss",2)))));
                        stan::math::assign(pGamble, inv_logit((get_base1(tau,i,"tau",1) * (evGamble - evSafe))));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2), pGamble));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("lambda_p");
        names__.push_back("tau_p");
        names__.push_back("lambda");
        names__.push_back("tau");
        names__.push_back("mu_lambda");
        names__.push_back("mu_tau");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_ra_noRA_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(2);
        vector_d sigma = in__.vector_lb_constrain(0,2);
        vector_d lambda_p = in__.vector_constrain(N);
        vector_d tau_p = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_p[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lambda,DUMMY_VAR__);
        vector_d tau(static_cast<Eigen::VectorXd::Index>(N));
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(lambda_p,i,"lambda_p",1)))) * 5));
            }
            stan::math::assign(tau, exp(add(get_base1(mu_p,2,"mu_p",1),multiply(get_base1(sigma,2,"sigma",1),tau_p))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,5);
        check_greater_or_equal(function__,"tau",tau,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_lambda(0.0);
        (void) mu_lambda;  // dummy to suppress unused var warning
        stan::math::initialize(mu_lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_lambda,DUMMY_VAR__);
        double mu_tau(0.0);
        (void) mu_tau;  // dummy to suppress unused var warning
        stan::math::initialize(mu_tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_tau,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_lambda, (Phi_approx(get_base1(mu_p,1,"mu_p",1)) * 5));
            stan::math::assign(mu_tau, exp(get_base1(mu_p,2,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                        double evSafe(0.0);
                        (void) evSafe;  // dummy to suppress unused var warning
                        stan::math::initialize(evSafe, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(evSafe,DUMMY_VAR__);
                        double evGamble(0.0);
                        (void) evGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(evGamble, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(evGamble,DUMMY_VAR__);
                        double pGamble(0.0);
                        (void) pGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(pGamble, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(pGamble,DUMMY_VAR__);


                        stan::math::assign(evSafe, get_base1(get_base1(cert,i,"cert",1),t,"cert",2));
                        stan::math::assign(evGamble, (0.5 * (get_base1(get_base1(gain,i,"gain",1),t,"gain",2) - (get_base1(lambda,i,"lambda",1) * get_base1(get_base1(loss,i,"loss",1),t,"loss",2)))));
                        stan::math::assign(pGamble, inv_logit((get_base1(tau,i,"tau",1) * (evGamble - evSafe))));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2),pGamble)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_lambda",mu_lambda,0);
        check_less_or_equal(function__,"mu_lambda",mu_lambda,5);
        check_greater_or_equal(function__,"mu_tau",mu_tau,0);

        // write generated quantities
        vars__.push_back(mu_lambda);
        vars__.push_back(mu_tau);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ra_noRA";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_ra_prospect_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_ra_prospect : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > gamble;
    vector<vector<double> > gain;
    vector<vector<double> > cert;
    vector<vector<double> > loss;
public:
    model_ra_prospect(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_ra_prospect(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_ra_prospect_namespace::model_ra_prospect";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "gamble", "int", context__.to_vec(N,T));
        validate_non_negative_index("gamble", "N", N);
        validate_non_negative_index("gamble", "T", T);
        gamble = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("gamble");
        pos__ = 0;
        size_t gamble_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < gamble_limit_1__; ++i_1__) {
            size_t gamble_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < gamble_limit_0__; ++i_0__) {
                gamble[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "gain", "double", context__.to_vec(N,T));
        validate_non_negative_index("gain", "N", N);
        validate_non_negative_index("gain", "T", T);
        gain = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("gain");
        pos__ = 0;
        size_t gain_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < gain_limit_1__; ++i_1__) {
            size_t gain_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < gain_limit_0__; ++i_0__) {
                gain[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "cert", "double", context__.to_vec(N,T));
        validate_non_negative_index("cert", "N", N);
        validate_non_negative_index("cert", "T", T);
        cert = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("cert");
        pos__ = 0;
        size_t cert_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < cert_limit_1__; ++i_1__) {
            size_t cert_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < cert_limit_0__; ++i_0__) {
                cert[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "loss", "double", context__.to_vec(N,T));
        validate_non_negative_index("loss", "N", N);
        validate_non_negative_index("loss", "T", T);
        loss = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("loss");
        pos__ = 0;
        size_t loss_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < loss_limit_1__; ++i_1__) {
            size_t loss_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < loss_limit_0__; ++i_0__) {
                loss[i_0__][i_1__] = vals_r__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],0);
                check_less_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],1);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"gain[k0__][k1__]",gain[k0__][k1__],0);
            }
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"loss[k0__][k1__]",loss[k0__][k1__],0);
            }
        }
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 3;
        num_params_r__ += 3;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_ra_prospect() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(3));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("rho_p")))
            throw std::runtime_error("variable rho_p missing");
        vals_r__ = context__.vals_r("rho_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "rho_p", "vector_d", context__.to_vec(N));
        // generate_declaration rho_p
        vector_d rho_p(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            rho_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(rho_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho_p: ") + e.what());
        }

        if (!(context__.contains_r("lambda_p")))
            throw std::runtime_error("variable lambda_p missing");
        vals_r__ = context__.vals_r("lambda_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "lambda_p", "vector_d", context__.to_vec(N));
        // generate_declaration lambda_p
        vector_d lambda_p(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            lambda_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(lambda_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable lambda_p: ") + e.what());
        }

        if (!(context__.contains_r("tau_p")))
            throw std::runtime_error("variable tau_p missing");
        vals_r__ = context__.vals_r("tau_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau_p", "vector_d", context__.to_vec(N));
        // generate_declaration tau_p
        vector_d tau_p(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_p: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(3,lp__);
        else
            mu_p = in__.vector_constrain(3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,3,lp__);
        else
            sigma = in__.vector_lb_constrain(0,3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho_p;
        (void) rho_p;  // dummy to suppress unused var warning
        if (jacobian__)
            rho_p = in__.vector_constrain(N,lp__);
        else
            rho_p = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda_p;
        (void) lambda_p;  // dummy to suppress unused var warning
        if (jacobian__)
            lambda_p = in__.vector_constrain(N,lp__);
        else
            lambda_p = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau_p;
        (void) tau_p;  // dummy to suppress unused var warning
        if (jacobian__)
            tau_p = in__.vector_constrain(N,lp__);
        else
            tau_p = in__.vector_constrain(N);


        // transformed parameters
        Eigen::Matrix<T__,Eigen::Dynamic,1>  rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, DUMMY_VAR__);
        stan::math::fill(rho,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda,DUMMY_VAR__);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(rho,i,"rho",1), (Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(rho_p,i,"rho_p",1)))) * 2));
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(lambda_p,i,"lambda_p",1)))) * 5));
            }
            stan::math::assign(tau, exp(add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),tau_p))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(rho(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(lambda(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(tau(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"rho",rho,0);
        check_less_or_equal(function__,"rho",rho,2);
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,5);
        check_greater_or_equal(function__,"tau",tau,0);

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1.0));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5.0));
            lp_accum__.add(normal_log<propto__>(rho_p, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(lambda_p, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(tau_p, 0, 1.0));
            for (int i = 1; i <= N; ++i) {

                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                        T__ evSafe;
                        (void) evSafe;  // dummy to suppress unused var warning
                        stan::math::initialize(evSafe, DUMMY_VAR__);
                        stan::math::fill(evSafe,DUMMY_VAR__);
                        T__ evGamble;
                        (void) evGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(evGamble, DUMMY_VAR__);
                        stan::math::fill(evGamble,DUMMY_VAR__);
                        T__ pGamble;
                        (void) pGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(pGamble, DUMMY_VAR__);
                        stan::math::fill(pGamble,DUMMY_VAR__);


                        stan::math::assign(evSafe, pow(get_base1(get_base1(cert,i,"cert",1),t,"cert",2),get_base1(rho,i,"rho",1)));
                        stan::math::assign(evGamble, (0.5 * (pow(get_base1(get_base1(gain,i,"gain",1),t,"gain",2),get_base1(rho,i,"rho",1)) - (get_base1(lambda,i,"lambda",1) * pow(get_base1(get_base1(loss,i,"loss",1),t,"loss",2),get_base1(rho,i,"rho",1))))));
                        stan::math::assign(pGamble, inv_logit((get_base1(tau,i,"tau",1) * (evGamble - evSafe))));
                        lp_accum__.add(bernoulli_log<propto__>(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2), pGamble));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("rho_p");
        names__.push_back("lambda_p");
        names__.push_back("tau_p");
        names__.push_back("rho");
        names__.push_back("lambda");
        names__.push_back("tau");
        names__.push_back("mu_rho");
        names__.push_back("mu_lambda");
        names__.push_back("mu_tau");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_ra_prospect_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d rho_p = in__.vector_constrain(N);
        vector_d lambda_p = in__.vector_constrain(N);
        vector_d tau_p = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_p[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector_d rho(static_cast<Eigen::VectorXd::Index>(N));
        (void) rho;  // dummy to suppress unused var warning
        stan::math::initialize(rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(rho,DUMMY_VAR__);
        vector_d lambda(static_cast<Eigen::VectorXd::Index>(N));
        (void) lambda;  // dummy to suppress unused var warning
        stan::math::initialize(lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lambda,DUMMY_VAR__);
        vector_d tau(static_cast<Eigen::VectorXd::Index>(N));
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(rho,i,"rho",1), (Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(rho_p,i,"rho_p",1)))) * 2));
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(lambda_p,i,"lambda_p",1)))) * 5));
            }
            stan::math::assign(tau, exp(add(get_base1(mu_p,3,"mu_p",1),multiply(get_base1(sigma,3,"sigma",1),tau_p))));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"rho",rho,0);
        check_less_or_equal(function__,"rho",rho,2);
        check_greater_or_equal(function__,"lambda",lambda,0);
        check_less_or_equal(function__,"lambda",lambda,5);
        check_greater_or_equal(function__,"tau",tau,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_rho(0.0);
        (void) mu_rho;  // dummy to suppress unused var warning
        stan::math::initialize(mu_rho, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_rho,DUMMY_VAR__);
        double mu_lambda(0.0);
        (void) mu_lambda;  // dummy to suppress unused var warning
        stan::math::initialize(mu_lambda, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_lambda,DUMMY_VAR__);
        double mu_tau(0.0);
        (void) mu_tau;  // dummy to suppress unused var warning
        stan::math::initialize(mu_tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_tau,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_rho, (Phi_approx(get_base1(mu_p,1,"mu_p",1)) * 2));
            stan::math::assign(mu_lambda, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 5));
            stan::math::assign(mu_tau, exp(get_base1(mu_p,3,"mu_p",1)));

            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {
                    {
                        double evSafe(0.0);
                        (void) evSafe;  // dummy to suppress unused var warning
                        stan::math::initialize(evSafe, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(evSafe,DUMMY_VAR__);
                        double evGamble(0.0);
                        (void) evGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(evGamble, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(evGamble,DUMMY_VAR__);
                        double pGamble(0.0);
                        (void) pGamble;  // dummy to suppress unused var warning
                        stan::math::initialize(pGamble, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(pGamble,DUMMY_VAR__);


                        stan::math::assign(evSafe, pow(get_base1(get_base1(cert,i,"cert",1),t,"cert",2),get_base1(rho,i,"rho",1)));
                        stan::math::assign(evGamble, (0.5 * (pow(get_base1(get_base1(gain,i,"gain",1),t,"gain",2),get_base1(rho,i,"rho",1)) - (get_base1(lambda,i,"lambda",1) * pow(fabs(get_base1(get_base1(loss,i,"loss",1),t,"loss",2)),get_base1(rho,i,"rho",1))))));
                        stan::math::assign(pGamble, inv_logit((get_base1(tau,i,"tau",1) * (evGamble - evSafe))));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_log(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2),pGamble)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_rho",mu_rho,0);
        check_less_or_equal(function__,"mu_rho",mu_rho,2);
        check_greater_or_equal(function__,"mu_lambda",mu_lambda,0);
        check_less_or_equal(function__,"mu_lambda",mu_lambda,5);
        check_greater_or_equal(function__,"mu_tau",mu_tau,0);

        // write generated quantities
        vars__.push_back(mu_rho);
        vars__.push_back(mu_lambda);
        vars__.push_back(mu_tau);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ra_prospect";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_rho";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_ug_bayes_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_ug_bayes : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > offer;
    vector<vector<int> > accept;
    double initV;
    double mu0;
    double k0;
    double sig20;
    double nu0;
public:
    model_ug_bayes(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_ug_bayes(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_ug_bayes_namespace::model_ug_bayes";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "offer", "double", context__.to_vec(N,T));
        validate_non_negative_index("offer", "N", N);
        validate_non_negative_index("offer", "T", T);
        offer = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("offer");
        pos__ = 0;
        size_t offer_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < offer_limit_1__; ++i_1__) {
            size_t offer_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < offer_limit_0__; ++i_0__) {
                offer[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "accept", "int", context__.to_vec(N,T));
        validate_non_negative_index("accept", "N", N);
        validate_non_negative_index("accept", "T", T);
        accept = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("accept");
        pos__ = 0;
        size_t accept_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < accept_limit_1__; ++i_1__) {
            size_t accept_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < accept_limit_0__; ++i_0__) {
                accept[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"accept[k0__][k1__]",accept[k0__][k1__],0);
                check_less_or_equal(function__,"accept[k0__][k1__]",accept[k0__][k1__],1);
            }
        }
        // initialize data variables
        initV = double(0);
        stan::math::fill(initV,DUMMY_VAR__);
        mu0 = double(0);
        stan::math::fill(mu0,DUMMY_VAR__);
        k0 = double(0);
        stan::math::fill(k0,DUMMY_VAR__);
        sig20 = double(0);
        stan::math::fill(sig20,DUMMY_VAR__);
        nu0 = double(0);
        stan::math::fill(nu0,DUMMY_VAR__);

        try {
            stan::math::assign(initV, 0.0);
            stan::math::assign(mu0, 10.0);
            stan::math::assign(k0, 4.0);
            stan::math::assign(sig20, 4.0);
            stan::math::assign(nu0, 10.0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 3;
        num_params_r__ += 3;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_ug_bayes() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(3));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        // generate_declaration alpha_pr
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("Beta_pr")))
            throw std::runtime_error("variable Beta_pr missing");
        vals_r__ = context__.vals_r("Beta_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "Beta_pr", "vector_d", context__.to_vec(N));
        // generate_declaration Beta_pr
        vector_d Beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            Beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(Beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable Beta_pr: ") + e.what());
        }

        if (!(context__.contains_r("tau_pr")))
            throw std::runtime_error("variable tau_pr missing");
        vals_r__ = context__.vals_r("tau_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau_pr", "vector_d", context__.to_vec(N));
        // generate_declaration tau_pr
        vector_d tau_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(3,lp__);
        else
            mu_p = in__.vector_constrain(3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,3,lp__);
        else
            sigma = in__.vector_lb_constrain(0,3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_pr;
        (void) alpha_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_pr = in__.vector_constrain(N,lp__);
        else
            alpha_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  Beta_pr;
        (void) Beta_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            Beta_pr = in__.vector_constrain(N,lp__);
        else
            Beta_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau_pr;
        (void) tau_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            tau_pr = in__.vector_constrain(N,lp__);
        else
            tau_pr = in__.vector_constrain(N);


        // transformed parameters
        vector<T__> alpha(N);
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha,DUMMY_VAR__);
        vector<T__> Beta(N);
        stan::math::initialize(Beta, DUMMY_VAR__);
        stan::math::fill(Beta,DUMMY_VAR__);
        vector<T__> tau(N);
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 20));
                stan::math::assign(get_base1_lhs(Beta,i,"Beta",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(Beta_pr,i,"Beta_pr",1)))) * 10));
                stan::math::assign(get_base1_lhs(tau,i,"tau",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(alpha[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(Beta[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: Beta" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(tau[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"alpha[k0__]",alpha[k0__],0);
            check_less_or_equal(function__,"alpha[k0__]",alpha[k0__],20);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Beta[k0__]",Beta[k0__],0);
            check_less_or_equal(function__,"Beta[k0__]",Beta[k0__],10);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"tau[k0__]",tau[k0__],0);
            check_less_or_equal(function__,"tau[k0__]",tau[k0__],10);
        }

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(Beta_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(tau_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    T__ util;
                    (void) util;  // dummy to suppress unused var warning
                    stan::math::initialize(util, DUMMY_VAR__);
                    stan::math::fill(util,DUMMY_VAR__);
                    T__ mu_old;
                    (void) mu_old;  // dummy to suppress unused var warning
                    stan::math::initialize(mu_old, DUMMY_VAR__);
                    stan::math::fill(mu_old,DUMMY_VAR__);
                    T__ mu_new;
                    (void) mu_new;  // dummy to suppress unused var warning
                    stan::math::initialize(mu_new, DUMMY_VAR__);
                    stan::math::fill(mu_new,DUMMY_VAR__);
                    T__ k_old;
                    (void) k_old;  // dummy to suppress unused var warning
                    stan::math::initialize(k_old, DUMMY_VAR__);
                    stan::math::fill(k_old,DUMMY_VAR__);
                    T__ k_new;
                    (void) k_new;  // dummy to suppress unused var warning
                    stan::math::initialize(k_new, DUMMY_VAR__);
                    stan::math::fill(k_new,DUMMY_VAR__);
                    T__ sig2_old;
                    (void) sig2_old;  // dummy to suppress unused var warning
                    stan::math::initialize(sig2_old, DUMMY_VAR__);
                    stan::math::fill(sig2_old,DUMMY_VAR__);
                    T__ sig2_new;
                    (void) sig2_new;  // dummy to suppress unused var warning
                    stan::math::initialize(sig2_new, DUMMY_VAR__);
                    stan::math::fill(sig2_new,DUMMY_VAR__);
                    T__ nu_old;
                    (void) nu_old;  // dummy to suppress unused var warning
                    stan::math::initialize(nu_old, DUMMY_VAR__);
                    stan::math::fill(nu_old,DUMMY_VAR__);
                    T__ nu_new;
                    (void) nu_new;  // dummy to suppress unused var warning
                    stan::math::initialize(nu_new, DUMMY_VAR__);
                    stan::math::fill(nu_new,DUMMY_VAR__);
                    T__ PE;
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, DUMMY_VAR__);
                    stan::math::fill(PE,DUMMY_VAR__);


                    stan::math::assign(mu_old, mu0);
                    stan::math::assign(k_old, k0);
                    stan::math::assign(sig2_old, sig20);
                    stan::math::assign(nu_old, nu0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(k_new, (k_old + 1));
                        stan::math::assign(nu_new, (nu_old + 1));
                        stan::math::assign(mu_new, (((k_old / k_new) * mu_old) + ((1 / k_new) * get_base1(get_base1(offer,i,"offer",1),t,"offer",2))));
                        stan::math::assign(sig2_new, (((nu_old / nu_new) * sig2_old) + (((1 / nu_new) * (k_old / k_new)) * pow((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_old),2))));
                        stan::math::assign(PE, (get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_old));
                        stan::math::assign(util, ((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - (get_base1(alpha,i,"alpha",1) * stan::math::fmax((mu_new - get_base1(get_base1(offer,i,"offer",1),t,"offer",2)),0.0))) - (get_base1(Beta,i,"Beta",1) * stan::math::fmax((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_new),0.0))));
                        lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(get_base1(accept,i,"accept",1),t,"accept",2), (util * get_base1(tau,i,"tau",1))));
                        stan::math::assign(mu_old, mu_new);
                        stan::math::assign(sig2_old, sig2_new);
                        stan::math::assign(k_old, k_new);
                        stan::math::assign(nu_old, nu_new);
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("alpha_pr");
        names__.push_back("Beta_pr");
        names__.push_back("tau_pr");
        names__.push_back("alpha");
        names__.push_back("Beta");
        names__.push_back("tau");
        names__.push_back("mu_alpha");
        names__.push_back("mu_Beta");
        names__.push_back("mu_tau");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_ug_bayes_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d Beta_pr = in__.vector_constrain(N);
        vector_d tau_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Beta_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector<double> alpha(N, 0.0);
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        vector<double> Beta(N, 0.0);
        stan::math::initialize(Beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(Beta,DUMMY_VAR__);
        vector<double> tau(N, 0.0);
        stan::math::initialize(tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 20));
                stan::math::assign(get_base1_lhs(Beta,i,"Beta",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(Beta_pr,i,"Beta_pr",1)))) * 10));
                stan::math::assign(get_base1_lhs(tau,i,"tau",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"alpha[k0__]",alpha[k0__],0);
            check_less_or_equal(function__,"alpha[k0__]",alpha[k0__],20);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Beta[k0__]",Beta[k0__],0);
            check_less_or_equal(function__,"Beta[k0__]",Beta[k0__],10);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"tau[k0__]",tau[k0__],0);
            check_less_or_equal(function__,"tau[k0__]",tau[k0__],10);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(Beta[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_alpha(0.0);
        (void) mu_alpha;  // dummy to suppress unused var warning
        stan::math::initialize(mu_alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_alpha,DUMMY_VAR__);
        double mu_Beta(0.0);
        (void) mu_Beta;  // dummy to suppress unused var warning
        stan::math::initialize(mu_Beta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_Beta,DUMMY_VAR__);
        double mu_tau(0.0);
        (void) mu_tau;  // dummy to suppress unused var warning
        stan::math::initialize(mu_tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_tau,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_alpha, (Phi_approx(get_base1(mu_p,1,"mu_p",1)) * 20));
            stan::math::assign(mu_Beta, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 10));
            stan::math::assign(mu_tau, (Phi_approx(get_base1(mu_p,3,"mu_p",1)) * 10));

            for (int i = 1; i <= N; ++i) {
                {
                    double util(0.0);
                    (void) util;  // dummy to suppress unused var warning
                    stan::math::initialize(util, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(util,DUMMY_VAR__);
                    double mu_old(0.0);
                    (void) mu_old;  // dummy to suppress unused var warning
                    stan::math::initialize(mu_old, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(mu_old,DUMMY_VAR__);
                    double mu_new(0.0);
                    (void) mu_new;  // dummy to suppress unused var warning
                    stan::math::initialize(mu_new, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(mu_new,DUMMY_VAR__);
                    double k_old(0.0);
                    (void) k_old;  // dummy to suppress unused var warning
                    stan::math::initialize(k_old, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(k_old,DUMMY_VAR__);
                    double k_new(0.0);
                    (void) k_new;  // dummy to suppress unused var warning
                    stan::math::initialize(k_new, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(k_new,DUMMY_VAR__);
                    double sig2_old(0.0);
                    (void) sig2_old;  // dummy to suppress unused var warning
                    stan::math::initialize(sig2_old, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(sig2_old,DUMMY_VAR__);
                    double sig2_new(0.0);
                    (void) sig2_new;  // dummy to suppress unused var warning
                    stan::math::initialize(sig2_new, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(sig2_new,DUMMY_VAR__);
                    double nu_old(0.0);
                    (void) nu_old;  // dummy to suppress unused var warning
                    stan::math::initialize(nu_old, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(nu_old,DUMMY_VAR__);
                    double nu_new(0.0);
                    (void) nu_new;  // dummy to suppress unused var warning
                    stan::math::initialize(nu_new, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(nu_new,DUMMY_VAR__);
                    double PE(0.0);
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(PE,DUMMY_VAR__);


                    stan::math::assign(mu_old, mu0);
                    stan::math::assign(k_old, k0);
                    stan::math::assign(sig2_old, sig20);
                    stan::math::assign(nu_old, nu0);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(k_new, (k_old + 1));
                        stan::math::assign(nu_new, (nu_old + 1));
                        stan::math::assign(mu_new, (((k_old / k_new) * mu_old) + ((1 / k_new) * get_base1(get_base1(offer,i,"offer",1),t,"offer",2))));
                        stan::math::assign(sig2_new, (((nu_old / nu_new) * sig2_old) + (((1 / nu_new) * (k_old / k_new)) * pow((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_old),2))));
                        stan::math::assign(PE, (get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_old));
                        stan::math::assign(util, ((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - (get_base1(alpha,i,"alpha",1) * stan::math::fmax((mu_new - get_base1(get_base1(offer,i,"offer",1),t,"offer",2)),0.0))) - (get_base1(Beta,i,"Beta",1) * stan::math::fmax((get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - mu_new),0.0))));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_logit_log(get_base1(get_base1(accept,i,"accept",1),t,"accept",2),(util * get_base1(tau,i,"tau",1)))));
                        stan::math::assign(mu_old, mu_new);
                        stan::math::assign(sig2_old, sig2_new);
                        stan::math::assign(k_old, k_new);
                        stan::math::assign(nu_old, nu_new);
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
        check_less_or_equal(function__,"mu_alpha",mu_alpha,20);
        check_greater_or_equal(function__,"mu_Beta",mu_Beta,0);
        check_less_or_equal(function__,"mu_Beta",mu_Beta,10);
        check_greater_or_equal(function__,"mu_tau",mu_tau,0);
        check_less_or_equal(function__,"mu_tau",mu_tau,10);

        // write generated quantities
        vars__.push_back(mu_alpha);
        vars__.push_back(mu_Beta);
        vars__.push_back(mu_tau);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ug_bayes";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_Beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




// Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace model_ug_delta_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_ug_delta : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > offer;
    vector<vector<int> > accept;
public:
    model_ug_delta(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_ug_delta(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_ug_delta_namespace::model_ug_delta";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "N", "int", context__.to_vec());
        N = int(0);
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        N = vals_i__[pos__++];
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
        validate_non_negative_index("Tsubj", "N", N);
        Tsubj = std::vector<int>(N,int(0));
        vals_i__ = context__.vals_i("Tsubj");
        pos__ = 0;
        size_t Tsubj_limit_0__ = N;
        for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
            Tsubj[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "offer", "double", context__.to_vec(N,T));
        validate_non_negative_index("offer", "N", N);
        validate_non_negative_index("offer", "T", T);
        offer = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
        vals_r__ = context__.vals_r("offer");
        pos__ = 0;
        size_t offer_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < offer_limit_1__; ++i_1__) {
            size_t offer_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < offer_limit_0__; ++i_0__) {
                offer[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "accept", "int", context__.to_vec(N,T));
        validate_non_negative_index("accept", "N", N);
        validate_non_negative_index("accept", "T", T);
        accept = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
        vals_i__ = context__.vals_i("accept");
        pos__ = 0;
        size_t accept_limit_1__ = T;
        for (size_t i_1__ = 0; i_1__ < accept_limit_1__; ++i_1__) {
            size_t accept_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < accept_limit_0__; ++i_0__) {
                accept[i_0__][i_1__] = vals_i__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"N",N,1);
        check_greater_or_equal(function__,"T",T,1);
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
            check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            for (int k1__ = 0; k1__ < T; ++k1__) {
                check_greater_or_equal(function__,"accept[k0__][k1__]",accept[k0__][k1__],0);
                check_less_or_equal(function__,"accept[k0__][k1__]",accept[k0__][k1__],1);
            }
        }
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        num_params_r__ += 3;
        num_params_r__ += 3;
        num_params_r__ += N;
        num_params_r__ += N;
        num_params_r__ += N;
    }

    ~model_ug_delta() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_p")))
            throw std::runtime_error("variable mu_p missing");
        vals_r__ = context__.vals_r("mu_p");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_p", "vector_d", context__.to_vec(3));
        // generate_declaration mu_p
        vector_d mu_p(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_p(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_p: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        // generate_declaration sigma
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("ep_pr")))
            throw std::runtime_error("variable ep_pr missing");
        vals_r__ = context__.vals_r("ep_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "ep_pr", "vector_d", context__.to_vec(N));
        // generate_declaration ep_pr
        vector_d ep_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            ep_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(ep_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ep_pr: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        // generate_declaration alpha_pr
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("tau_pr")))
            throw std::runtime_error("variable tau_pr missing");
        vals_r__ = context__.vals_r("tau_pr");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau_pr", "vector_d", context__.to_vec(N));
        // generate_declaration tau_pr
        vector_d tau_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_p;
        (void) mu_p;  // dummy to suppress unused var warning
        if (jacobian__)
            mu_p = in__.vector_constrain(3,lp__);
        else
            mu_p = in__.vector_constrain(3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma;
        (void) sigma;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma = in__.vector_lb_constrain(0,3,lp__);
        else
            sigma = in__.vector_lb_constrain(0,3);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  ep_pr;
        (void) ep_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            ep_pr = in__.vector_constrain(N,lp__);
        else
            ep_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_pr;
        (void) alpha_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_pr = in__.vector_constrain(N,lp__);
        else
            alpha_pr = in__.vector_constrain(N);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  tau_pr;
        (void) tau_pr;  // dummy to suppress unused var warning
        if (jacobian__)
            tau_pr = in__.vector_constrain(N,lp__);
        else
            tau_pr = in__.vector_constrain(N);


        // transformed parameters
        vector<T__> ep(N);
        stan::math::initialize(ep, DUMMY_VAR__);
        stan::math::fill(ep,DUMMY_VAR__);
        vector<T__> alpha(N);
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha,DUMMY_VAR__);
        vector<T__> tau(N);
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 20));
                stan::math::assign(get_base1_lhs(tau,i,"tau",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(ep[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: ep" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(alpha[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < N; ++i0__) {
            if (stan::math::is_uninitialized(tau[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"ep[k0__]",ep[k0__],0);
            check_less_or_equal(function__,"ep[k0__]",ep[k0__],1);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"alpha[k0__]",alpha[k0__],0);
            check_less_or_equal(function__,"alpha[k0__]",alpha[k0__],20);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"tau[k0__]",tau[k0__],0);
            check_less_or_equal(function__,"tau[k0__]",tau[k0__],10);
        }

        // model body
        try {

            lp_accum__.add(normal_log<propto__>(mu_p, 0, 1));
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            lp_accum__.add(normal_log<propto__>(ep_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1.0));
            lp_accum__.add(normal_log<propto__>(tau_pr, 0, 1.0));
            for (int i = 1; i <= N; ++i) {
                {
                    T__ f;
                    (void) f;  // dummy to suppress unused var warning
                    stan::math::initialize(f, DUMMY_VAR__);
                    stan::math::fill(f,DUMMY_VAR__);
                    T__ PE;
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, DUMMY_VAR__);
                    stan::math::fill(PE,DUMMY_VAR__);
                    T__ util;
                    (void) util;  // dummy to suppress unused var warning
                    stan::math::initialize(util, DUMMY_VAR__);
                    stan::math::fill(util,DUMMY_VAR__);


                    stan::math::assign(f, 10.0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(PE, (get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - f));
                        stan::math::assign(util, (get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - (get_base1(alpha,i,"alpha",1) * stan::math::fmax((f - get_base1(get_base1(offer,i,"offer",1),t,"offer",2)),0.0))));
                        lp_accum__.add(bernoulli_logit_log<propto__>(get_base1(get_base1(accept,i,"accept",1),t,"accept",2), (util * get_base1(tau,i,"tau",1))));
                        stan::math::assign(f, (f + (get_base1(ep,i,"ep",1) * PE)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_p");
        names__.push_back("sigma");
        names__.push_back("ep_pr");
        names__.push_back("alpha_pr");
        names__.push_back("tau_pr");
        names__.push_back("ep");
        names__.push_back("alpha");
        names__.push_back("tau");
        names__.push_back("mu_ep");
        names__.push_back("mu_tau");
        names__.push_back("mu_alpha");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_ug_delta_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        vector_d mu_p = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d ep_pr = in__.vector_constrain(N);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d tau_pr = in__.vector_constrain(N);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_pr[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector<double> ep(N, 0.0);
        stan::math::initialize(ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(ep,DUMMY_VAR__);
        vector<double> alpha(N, 0.0);
        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        vector<double> tau(N, 0.0);
        stan::math::initialize(tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(tau,DUMMY_VAR__);


        try {
            for (int i = 1; i <= N; ++i) {

                stan::math::assign(get_base1_lhs(ep,i,"ep",1), Phi_approx((get_base1(mu_p,1,"mu_p",1) + (get_base1(sigma,1,"sigma",1) * get_base1(ep_pr,i,"ep_pr",1)))));
                stan::math::assign(get_base1_lhs(alpha,i,"alpha",1), (Phi_approx((get_base1(mu_p,3,"mu_p",1) + (get_base1(sigma,3,"sigma",1) * get_base1(alpha_pr,i,"alpha_pr",1)))) * 20));
                stan::math::assign(get_base1_lhs(tau,i,"tau",1), (Phi_approx((get_base1(mu_p,2,"mu_p",1) + (get_base1(sigma,2,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * 10));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"ep[k0__]",ep[k0__],0);
            check_less_or_equal(function__,"ep[k0__]",ep[k0__],1);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"alpha[k0__]",alpha[k0__],0);
            check_less_or_equal(function__,"alpha[k0__]",alpha[k0__],20);
        }
        for (int k0__ = 0; k0__ < N; ++k0__) {
            check_greater_or_equal(function__,"tau[k0__]",tau[k0__],0);
            check_less_or_equal(function__,"tau[k0__]",tau[k0__],10);
        }

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(ep[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        double mu_ep(0.0);
        (void) mu_ep;  // dummy to suppress unused var warning
        stan::math::initialize(mu_ep, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_ep,DUMMY_VAR__);
        double mu_tau(0.0);
        (void) mu_tau;  // dummy to suppress unused var warning
        stan::math::initialize(mu_tau, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_tau,DUMMY_VAR__);
        double mu_alpha(0.0);
        (void) mu_alpha;  // dummy to suppress unused var warning
        stan::math::initialize(mu_alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_alpha,DUMMY_VAR__);
        vector<double> log_lik(N, 0.0);
        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            stan::math::assign(mu_ep, Phi_approx(get_base1(mu_p,1,"mu_p",1)));
            stan::math::assign(mu_tau, (Phi_approx(get_base1(mu_p,2,"mu_p",1)) * 10));
            stan::math::assign(mu_alpha, (Phi_approx(get_base1(mu_p,3,"mu_p",1)) * 20));

            for (int i = 1; i <= N; ++i) {
                {
                    double f(0.0);
                    (void) f;  // dummy to suppress unused var warning
                    stan::math::initialize(f, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(f,DUMMY_VAR__);
                    double PE(0.0);
                    (void) PE;  // dummy to suppress unused var warning
                    stan::math::initialize(PE, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(PE,DUMMY_VAR__);
                    double util(0.0);
                    (void) util;  // dummy to suppress unused var warning
                    stan::math::initialize(util, std::numeric_limits<double>::quiet_NaN());
                    stan::math::fill(util,DUMMY_VAR__);


                    stan::math::assign(f, 10.0);
                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), 0.0);
                    for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                        stan::math::assign(PE, (get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - f));
                        stan::math::assign(util, (get_base1(get_base1(offer,i,"offer",1),t,"offer",2) - (get_base1(alpha,i,"alpha",1) * stan::math::fmax((f - get_base1(get_base1(offer,i,"offer",1),t,"offer",2)),0.0))));
                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), (get_base1(log_lik,i,"log_lik",1) + bernoulli_logit_log(get_base1(get_base1(accept,i,"accept",1),t,"accept",2),(util * get_base1(tau,i,"tau",1)))));
                        stan::math::assign(f, (f + (get_base1(ep,i,"ep",1) * PE)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        check_greater_or_equal(function__,"mu_ep",mu_ep,0);
        check_less_or_equal(function__,"mu_ep",mu_ep,1);
        check_greater_or_equal(function__,"mu_tau",mu_tau,0);
        check_less_or_equal(function__,"mu_tau",mu_tau,10);
        check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
        check_less_or_equal(function__,"mu_alpha",mu_alpha,20);

        // write generated quantities
        vars__.push_back(mu_ep);
        vars__.push_back(mu_tau);
        vars__.push_back(mu_alpha);
        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ug_delta";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ep" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_ep";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

} // namespace




#endif
