% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.summary}
\alias{h2o.summary}
\alias{summary.H2OFrame}
\title{Summarizes the columns of an H2OFrame.}
\usage{
h2o.summary(object, factors = 6L, exact_quantiles = FALSE, ...)

\method{summary}{H2OFrame}(object, factors, exact_quantiles, ...)
}
\arguments{
\item{object}{An H2OFrame object.}

\item{factors}{The number of factors to return in the summary. Default is the top 6.}

\item{exact_quantiles}{Compute exact quantiles or use approximation. Default is to use approximation.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A table displaying the minimum, 1st quartile, median, mean, 3rd quartile and maximum for each
numeric column, and the levels and category counts of the levels in each categorical column.
}
\description{
A method for the \code{\link{summary}} generic. Summarizes the columns of an H2O data frame or subset of
columns and rows using vector notation (e.g. dataset[row, col]).
}
\details{
By default it uses approximated version of quantiles computation, however, user can modify
this behavior by setting up exact_quantiles argument to true.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path)
summary(prostate)
summary(prostate$GLEASON)
summary(prostate[,4:6])
summary(prostate, exact_quantiles=TRUE)
}
}
