% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.ls}
\alias{h2o.ls}
\title{List Keys on an H2O Cluster}
\usage{
h2o.ls(conn = h2o.getConnection())
}
\arguments{
\item{conn}{An \linkS4class{H2OConnection} object containing the IP address and port number of the H2O server.}
}
\value{
Returns a list of hex keys in the current H2O instance.
}
\description{
Accesses a list of object keys in the running instance of H2O.
}
\examples{
\donttest{
library(h2o)
localH2O <- h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(localH2O, path = prosPath)
h2o.ls(localH2O)
}
}

