% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwer.sel.R
\name{gwer.sel}
\alias{gwer.sel}
\title{Optimization of Bandwidth for Geographically Weighted Elliptical Regression}
\usage{
gwer.sel(formula, data = list(), coords, adapt = FALSE,
  gweight = gwr.Gauss, method = "cv", verbose = TRUE,
  longlat = NULL, family, RMSE = FALSE, weights,
  tol = .Machine$double.eps^0.25, show.error.messages = FALSE, ...)
}
\arguments{
\item{formula}{regression model formula as in \code{glm}.}

\item{data}{model data frame, or may be a SpatialPointsDataFrame or SpatialPolygonsDataFrame as defined in package \pkg{sp}.}

\item{coords}{matrix of coordinates of points representing the spatial positions of the observations.}

\item{adapt}{defines the type of bandwidth used. Either TRUE: find the proportion between 0 and 1 of observations to include in weighting scheme (k-nearest neighbours) or FALSE: find global bandwidth.}

\item{gweight}{geographical weighting function, at present \code{gwr.Gauss()} default, or \code{gwr.bisquare()}.}

\item{method}{default "cv" for drop-1 cross-validation, "aic" for AIC optimisation (depends on assumptions about AIC degrees of freedom) or "sv" for spatial validation.}

\item{verbose}{if TRUE (default), reports the progress of search for bandwidth.}

\item{longlat}{TRUE if point coordinates are longitude-latitude decimal degrees, in which case distances are measured in kilometers; if x is a SpatialPoints object, the value is taken from the object itself.}

\item{family}{a description of the error distribution to be used in the model (see \code{elliptical.family} for details of family functions).}

\item{RMSE}{default FALSE to correspond with CV scores in newer references (sum of squared CV errors), if TRUE the previous behaviour of scoring by LOO CV RMSE.}

\item{weights}{case weights used as in weighted least squares, beware of scaling issues. Only used with the cross-validation method, probably unsafe.}

\item{tol}{the desired accuracy to be passed to \code{optimize}.}

\item{show.error.messages}{default FALSE. may be set to TRUE to see error messages if \code{gwer.sel} returns without a value.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
returns the bandwidth optimization value.
}
\description{
The function finds a bandwidth for a given geographically weighted elliptical regression by optimzing a selected function. For cross-validation, this scores the root mean square prediction error for the geographically weighted elliptical regressions, choosing the bandwidth minimizing this quantity.
}
\examples{
data(columbus, package="spData")
gwer.bw <- gwer.sel(CRIME ~ INC, data=columbus, family = Normal(),
                 coords=cbind(columbus$X, columbus$Y))
\donttest{
data(columbus, package="spData")
gwer.bw <- gwer.sel(CRIME ~ INC, data=columbus, family = Student(df=4),
                 coords=cbind(columbus$X, columbus$Y))
}
}
\references{
Brunsdon, C., Fotheringham, A. S. and Charlton, M. E. (1996). 
Geographically weighted regression: a method for exploring spatial nonstationarity.
Geographical analysis, 28(4), 281-298. \url{https://doi.org/10.1111/j.1538-4632.1996.tb00936.x}

Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\seealso{
\code{\link{gwer}}, \code{\link{elliptical}}, \code{\link{family.elliptical}}
}
\keyword{elliptical}
\keyword{spatial}
