% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify}
\alias{modify}
\alias{modify_header}
\alias{modify_spanning_header}
\alias{remove_spanning_header}
\alias{show_header_names}
\title{Modify column headers and spanning headers}
\usage{
modify_header(x, ..., text_interpret = c("md", "html"), quiet, update)

modify_spanning_header(
  x,
  ...,
  text_interpret = c("md", "html"),
  level = 1L,
  quiet,
  update
)

remove_spanning_header(x, columns = everything(), level = 1L)

show_header_names(x, show_hidden = FALSE, include_example, quiet)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object}

\item{...}{\code{\link[rlang:dyn-dots]{dynamic-dots}}\cr
Used to assign updates to headers and spanning headers.

Use \code{modify_*(colname='new header')} to update a single column. Using a
formula will invoke tidyselect, e.g. \code{modify_*(all_stat_cols() ~ "**{level}**")}.
The dynamic dots allow syntax like \code{modify_header(x, !!!list(label = "Variable"))}.
See examples below.

Use the \code{show_header_names()} to see the column names that can be modified.}

\item{text_interpret}{(\code{string})\cr
String indicates whether text will be interpreted with
\code{\link[gt:md]{gt::md()}} or \code{\link[gt:html]{gt::html()}}. Must be \code{"md"} (default) or \code{"html"}.
Applies to tables printed with \code{{gt}}.}

\item{update, quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{level}{(\code{integer})\cr
An integer specifying which level to place the spanning header.}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Columns from which to remove spanning headers.}

\item{show_hidden}{(scalar \code{logical})\cr
Logical indicating whether to print hidden columns as well as printed columns.
Default is \code{FALSE}.}

\item{include_example}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
Updated gtsummary object
}
\description{
These functions assist with modifying the aesthetics/style of a table.
\itemize{
\item \code{modify_header()} update column headers
\item \code{modify_spanning_header()} update/add spanning headers
}

The functions often require users to know the underlying column names.
Run \code{show_header_names()} to print the column names to the console.
}
\section{\code{tbl_summary()}, \code{tbl_svysummary()}, and \code{tbl_cross()}}{

When assigning column headers and spanning headers,
you may use \code{{N}} to insert the number of observations.
\code{tbl_svysummary} objects additionally have \code{{N_unweighted}} available.

When there is a stratifying \verb{by=} argument present, the following fields are
additionally available to stratifying columns: \code{{level}}, \code{{n}}, and \code{{p}}
(\code{{n_unweighted}} and \code{{p_unweighted}} for \code{tbl_svysummary} objects)

Syntax follows \code{\link[glue:glue]{glue::glue()}}, e.g. \code{all_stat_cols() ~ "**{level}**, N = {n}"}.
}

\section{tbl_regression()}{

When assigning column headers for \code{tbl_regression} tables,
you may use \code{{N}} to insert the number of observations, and \code{{N_event}}
for the number of events (when applicable).
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("broom", "broom.helpers"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create summary table
tbl <- trial |>
  tbl_summary(by = trt, missing = "no", include = c("age", "grade", "trt")) |>
  add_p()

# print the column names that can be modified
show_header_names(tbl)

# Example 1 ----------------------------------
# updating column headers
tbl |>
  modify_header(label = "**Variable**", p.value = "**P**")

# Example 2 ----------------------------------
# updating headers add spanning header
tbl |>
  modify_header(all_stat_cols() ~ "**{level}**, N = {n} ({style_percent(p)}\%)") |>
  modify_spanning_header(all_stat_cols() ~ "**Treatment Received**")
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
