% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_difference.R
\name{add_difference}
\alias{add_difference}
\title{Add difference between groups}
\usage{
add_difference(
  x,
  test = NULL,
  group = NULL,
  adj.vars = NULL,
  test.args = NULL,
  conf.level = 0.95,
  include = everything(),
  pvalue_fun = NULL,
  estimate_fun = style_sigfig
)
}
\arguments{
\item{x}{\code{"tbl_summary"} object}

\item{test}{List of formulas specifying statistical tests to perform for each variable,
e.g. \code{list(all_continuous() ~ "t.test")}.
Common tests include \code{"t.test"} or \code{"ancova"} for continuous data, and
\code{"prop.test"} for dichotomous variables.
See \link{tests} for details and more tests.}

\item{group}{Column name (unquoted or quoted) of an ID or grouping variable.
The column can be used to calculate p-values with correlated data.
Default is \code{NULL}. See \link{tests} for methods that utilize the \verb{group=} argument.}

\item{adj.vars}{Variables to include in mean difference adjustment (e.g. in ANCOVA models)}

\item{test.args}{List of formulas containing additional arguments to pass to
tests that accept arguments. For example, add an argument for all t-tests,
use \code{test.args = all_tests("t.test") ~ list(var.equal = TRUE)}}

\item{conf.level}{Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{include}{Variables to include in output. Input may be a vector of
quoted variable names, unquoted variable names, or tidyselect select helper
functions. Default is \code{everything()}.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{estimate_fun}{Function to round and format difference. Default is \code{\link[=style_sigfig]{style_sigfig()}}}
}
\description{
\lifecycle{experimental}
Add the difference between two groups (typically mean difference),
along with the difference confidence interval and p-value.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_difference_ex1.png}{options: width=60\%}}

\if{html}{Example 2}

\if{html}{\figure{add_difference_ex2.png}{options: width=60\%}}
}

\examples{
# Example 1 ----------------------------------
add_difference_ex1 <-
  trial \%>\%
  select(trt, age, marker) \%>\%
  tbl_summary(by = trt,
              statistic = all_continuous() ~ "{mean} ({sd})",
              missing = "no") \%>\%
  add_n() \%>\%
  add_difference()

# Example 2 ----------------------------------
add_difference_ex2 <-
  trial \%>\%
  select(trt, response, death) \%>\%
  tbl_summary(by = trt,
              statistic = all_dichotomous() ~ "{p}\%",
              missing = "no") \%>\%
  modify_footnote(all_stat_cols() ~ NA) \%>\%
  add_n() \%>\%
  add_difference(estimate_fun = ~paste0(style_sigfig(. * 100), "\%"))
}
