% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_q.R
\name{add_q.fmt_table1}
\alias{add_q.fmt_table1}
\title{Add a column of q values to \code{fmt_table1} object to account for
multiple comparisons in Rmarkdown}
\usage{
\method{add_q}{fmt_table1}(x, method = "fdr", pvalue_fun = fmt_pvalue,
  ...)
}
\arguments{
\item{x}{\code{table1} object}

\item{method}{character argument.  Methods from
\code{stats::}\code{\link[stats]{p.adjust}} are accepted.  Default is \code{method = fdr}.}

\item{pvalue_fun}{function for rounding/formatting p-values.  Default is \code{\link{fmt_pvalue}}.}

\item{...}{further arguments passed to or from other methods}
}
\description{
The adjustments to the p-values is performed with
\code{stats::}\code{\link[stats]{p.adjust}}.  The default method for correction
is false discovery rate (\code{"fdr"})
}
\examples{
trial \%>\% fmt_table1(by = "trt") \%>\% add_comparison() \%>\% add_q()
}
