% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstudy.R
\name{gstudy}
\alias{gstudy}
\alias{gstudy.data.frame}
\alias{gstudy.multivariate}
\alias{gstudy.univariate}
\title{Conduct a Univariate or Multivariate Generalizability (G) Study}
\usage{
gstudy(data, ...)

\method{gstudy}{data.frame}(data, formula, colname.strata = NULL,
  colname.objects = NULL, keep.mer = F, ...)

\method{gstudy}{univariate}(data, formula, colname.strata = NULL,
  colname.objects = NULL, keep.mer = F, ...)

\method{gstudy}{multivariate}(data, formula, colname.strata = NULL,
  colname.objects = NULL, keep.mer = F, ...)
}
\arguments{
\item{data}{a data frame in long format with a column for item scores and columns for sources of variance}

\item{...}{additional arguments to be passed to \code{\link{lmer}}}

\item{formula}{a formula specifying the model to be estimated by \code{\link{lmer}}}

\item{colname.strata}{an optional string that specifies the name of the column containing strata (if conducting a multivariate G study)}

\item{colname.objects}{an optional string that specifies the name of the column containing objects of measurement for calculating observed-score covariance (if conducting a multivariate G study)}

\item{keep.mer}{a logical indicating whether or not to store the output from \code{\link{lmer}} as an attribute of the variance components data frame}
}
\value{
an object of class "\code{gstudy}" that lists variance components of class "\code{components}".  It will also list observed-score variance and covariance between strata if you specify the names of the columns identifying strata and objects of measurement.
}
\description{
\code{gstudy} estimates variance components attributable to objects of measurement (e.g., persons) and facets (e.g., items and raters), as well as unexplained variation.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: G study of a \code{data.frame} object

\item \code{univariate}: G study of a \code{univariate} object

\item \code{multivariate}: G study of a \code{multivariate} object
}}
\examples{
#Conduct a univariate G study.
#Compare to results on page 116 of Brennan (2001).
data(Brennan.3.2)
formula.Brennan.3.2 <- "Score ~ (1 | Person) + (1 | Task) + 
  (1 | Rater:Task) + (1 | Person:Task)"
gstudy(data = Brennan.3.2, formula = formula.Brennan.3.2)

#Conduct a multivariate G study.
#Compare to results on page 270 of Brennan (2001).
data(Rajaratnam.2)
formula.Rajaratnam.2 <- "Score ~ (1 | Person) + (1 | Item)"
gstudy(data = Rajaratnam.2, formula = formula.Rajaratnam.2, colname.strata = "Subtest", 
  colname.objects = "Person")
}
\references{
Brennan, R. L. (2001). \emph{Generalizability theory}. New York: Springer.

Rajaratnam, N., Cronbach, L. J., & Gleser, G. C. (1965). Generalizability of stratified-parallel tests. \emph{Psychometrika}, \emph{30}(1), 39-56.
}

