% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_validator.R
\name{download_validator}
\alias{download_validator}
\title{Download MobilityData's GTFS validator}
\usage{
download_validator(path, version = "latest", force = FALSE, quiet = TRUE)
}
\arguments{
\item{path}{A string. The directory where the validator should be saved to.}

\item{version}{A string. The version of the validator that should be
downloaded. Defaults to \code{"latest"}, but accepts version numbers as strings
(i.e. to download version v4.0.0 please enter \code{"4.0.0"}). Please check
\href{https://github.com/MobilityData/gtfs-validator/releases}{MobilityData/gtfs-validator releases} for the
full set of available versions.}

\item{force}{A logical. Whether to overwrite a previously downloaded
validator in \code{path}. Defaults to \code{FALSE}.}

\item{quiet}{A logical. Whether to hide log messages and progress bars.
Defaults to \code{TRUE}.}
}
\value{
Invisibly returns the normalized path to the downloaded validator.
}
\description{
Downloads MobilityData's command line tool to validate GTFS feeds.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
path <- tempdir()

download_validator(path)

# specifying a specific version
download_validator(path, version = "4.0.0")
\dontshow{\}) # examplesIf}
}
\seealso{
Other validation: 
\code{\link{validate_gtfs}()}
}
\concept{validation}
