% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtexr_arguments.R
\name{gtexr_arguments}
\alias{gtexr_arguments}
\title{gtexr arguments}
\usage{
gtexr_arguments(
  ageBrackets = NULL,
  aliquotIds = NULL,
  attributeSubset = NULL,
  autolysisScores = NULL,
  cellType = NULL,
  bp_window = NULL,
  chromosome = NULL,
  datasetId = NULL,
  dataTypes = NULL,
  draw = NULL,
  end = NULL,
  excludeDataArray = NULL,
  .featureId = NULL,
  filterMtGene = NULL,
  gencodeId = NULL,
  gencodeIds = NULL,
  gencodeVersion = NULL,
  geneId = NULL,
  geneIds = NULL,
  genomeBuild = NULL,
  hardyScales = NULL,
  hasExpressionData = NULL,
  hasGenotype = NULL,
  itemsPerPage = NULL,
  ischemicTime = NULL,
  ischemicTimeGroups = NULL,
  materialTypes = NULL,
  organizationName = NULL,
  page = NULL,
  pathCategory = NULL,
  phenotypeId = NULL,
  pos = NULL,
  project_id = NULL,
  rin = NULL,
  sampleId = NULL,
  sampleIds = NULL,
  searchTerm = NULL,
  sex = NULL,
  snpId = NULL,
  sortBy = NULL,
  sortDirection = NULL,
  start = NULL,
  subjectIds = NULL,
  tissueSampleIds = NULL,
  tissueSiteDetailId = NULL,
  tissueSiteDetailIds = NULL,
  uberonIds = NULL,
  variantId = NULL,
  variantIds = NULL
)
}
\arguments{
\item{ageBrackets}{The age bracket(s) of the donors of interest. Options:
"20-29", "30-39", "40-49", "50-59", "60-69", "70-79".}

\item{aliquotIds}{Character vector.}

\item{attributeSubset}{String. Examples include but are not limited to "sex", "ageBracket"}

\item{autolysisScores}{Character vector. Options: "None", "Mild", "Moderate",
"Severe".}

\item{cellType}{String. "Adipocytes", "Epithelial_cells", "Hepatocytes",
"Keratinocytes", "Myocytes", "Neurons", "Neutrophils".}

\item{bp_window}{Integer.}

\item{chromosome}{String. One of "chr1", "chr2", "chr3", "chr4", "chr5",
"chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13",
"chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21",
"chr22", "chrM", "chrX", "chrY".}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{dataTypes}{Character vector. Options: "RNASEQ", "WGS", "WES", "OMNI",
"EXCLUDE".}

\item{draw}{Integer.}

\item{end}{Integer.}

\item{excludeDataArray}{String. Options are TRUE or FALSE}

\item{.featureId}{String. A genomic feature e.g. GENCODE ID, RSID or
GTEx Variant ID.}

\item{filterMtGene}{Logical. Exclude mitochondrial genes.}

\item{gencodeId}{String. A Versioned GENCODE ID of a gene, e.g.
"ENSG00000065613.9".}

\item{gencodeIds}{A character vector of Versioned GENCODE IDs, e.g.
c("ENSG00000132693.12", "ENSG00000203782.5").}

\item{gencodeVersion}{String (default = "v26"). GENCODE annotation release.
Either "v26" or "v19".}

\item{geneId}{String. A gene symbol, a gencode ID, or an Ensemble ID.}

\item{geneIds}{A character vector of gene symbols, versioned gencodeIds, or
unversioned gencodeIds.}

\item{genomeBuild}{String. Options: "GRCh38/hg38", "GRCh37/hg19". Default =
"GRCh38/hg38".}

\item{hardyScales}{Character vector. A list of Hardy Scale(s) of interest.
Options: "Ventilator case", "Fast death - violent", "Fast death - natural
causes", "Intermediate death", "Slow death".}

\item{hasExpressionData}{Logical.}

\item{hasGenotype}{Logical.}

\item{itemsPerPage}{Integer (default = 250).}

\item{ischemicTime}{Integer.}

\item{ischemicTimeGroups}{Character vector. Options:
"<= 0", "1 - 300", "301 - 600", "601 - 900", "901 - 1200", "1201 - 1500", "> 1500".}

\item{materialTypes}{String, vector. Options: "Cells:Cell Line Viable",
"DNA:DNA Genomic", "DNA:DNA Somatic", "RNA:Total RNA", "Tissue:PAXgene
Preserved", "Tissue:PAXgene Preserved Paraffin-embedded", "Tissue:Fresh
Frozen Tissue".}

\item{organizationName}{String. Options: "GTEx Consortium" "Kid's First".}

\item{page}{Integer (default = 0).}

\item{pathCategory}{Character vector. Options: "adenoma", "amylacea",
"atelectasis", "atherosclerosis", "atherosis", "atrophy", "calcification",
"cirrhosis", "clean_specimens", "congestion", "corpora_albicantia", "cyst",
"desquamation", "diabetic", "dysplasia", "edema", "emphysema",
"esophagitis", "fibrosis", "gastritis", "glomerulosclerosis", "goiter",
"gynecomastoid", "hashimoto", "heart_failure_cells", "hemorrhage",
"hepatitis", "hyalinization", "hypereosinophilia", "hyperplasia",
"hypertrophy", "hypoxic", "infarction", "inflammation", "ischemic_changes",
"macrophages", "mastopathy", "metaplasia", "monckeberg", "necrosis",
"nephritis", "nephrosclerosis", "no_abnormalities", "nodularity",
"pancreatitis", "pigment", "pneumonia", "post_menopausal", "prostatitis",
"saponification", "scarring", "sclerotic", "solar_elastosis",
"spermatogenesis", "steatosis", "sweat_glands", "tma".}

\item{phenotypeId}{String. See
\href{https://www.gtexportal.org/home/faq#splicingPhenotypeId}{GTEx portal FAQs}
for further details.}

\item{pos}{Integer, vector.}

\item{project_id}{String. Options: "gtex", "adult-gtex", "egtex".}

\item{rin}{Integer vector.}

\item{sampleId}{String. \verb{^GTEX-[A-Z0-9]\{5\}-[0-9]\{4\}-SM-[A-Z0-9]\{5\}$}}

\item{sampleIds}{Character vector. GTEx sample ID.}

\item{searchTerm}{String.}

\item{sex}{String. Options: "male", "female".}

\item{snpId}{String}

\item{sortBy}{String. Options: "sampleId", "ischemicTime", "aliquotId",
"tissueSampleId", "hardyScale", "pathologyNotes", "ageBracket",
"tissueSiteDetailId", "sex".}

\item{sortDirection}{String. Options: "asc", "desc". Default = "asc".}

\item{start}{Integer.}

\item{subjectIds}{Character vector. GTEx subject ID.}

\item{tissueSampleIds}{Array of strings. A list of Tissue Sample ID(s).}

\item{tissueSiteDetailId}{String. The ID of the tissue of interest. Can be a
GTEx specific ID (e.g. "Whole_Blood"; use \code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}}
to see valid values) or an Ontology ID.}

\item{tissueSiteDetailIds}{Character vector of IDs for tissues of interest.
Can be GTEx specific IDs (e.g. "Whole_Blood"; use
\code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values) or Ontology IDs.}

\item{uberonIds}{Character vector of Uberon IDs (e.g. "UBERON:EFO_0000572";
use \code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values).}

\item{variantId}{String. A gtex variant ID.}

\item{variantIds}{Character vector. Gtex variant IDs.}
}
\value{
Returns \code{NULL} invisibly. Used for documentation only.
}
\description{
Internal function that documents all arguments for exported gtexr functions
that wrap GTEx Portal API endpoints (using roxygen \verb{@inheritParams} tag).
}
\keyword{internal}
