% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtsave_extra.R
\name{gtsave_extra}
\alias{gtsave_extra}
\title{Use webshot2 to save a gt table as a PNG}
\usage{
gtsave_extra(data, filename, path = NULL, ..., zoom = 2, expand = 5)
}
\arguments{
\item{data}{HTML content to be saved temporarily to disk}

\item{filename}{The name of the file, should end in \code{.png}}

\item{path}{An optional path}

\item{...}{Additional arguments to \code{webshot2::webshot()}}

\item{zoom}{A number specifying the zoom factor. A zoom factor of 2 will result in twice as many pixels vertically and horizontally. Note that using 2 is not exactly the same as taking a screenshot on a HiDPI (Retina) device: it is like increasing the zoom to 200 doubling the height and width of the browser window.}

\item{expand}{A numeric vector specifying how many pixels to expand the clipping rectangle by. If one number, the rectangle will be expanded by that many pixels on all sides. If four numbers, they specify the top, right, bottom, and left, in that order.}
}
\value{
Prints the HTML content to the RStudio viewer and saves a \code{.png} file to disk
}
\description{
Takes existing HTML content, typically additional HTML including a gt table as a PNG via the \code{{webshot2}} package.
}
\section{Function ID}{

2-14
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
