% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vec.R
\name{vec_fmt_index}
\alias{vec_fmt_index}
\title{Format a vector as indexed characters}
\usage{
vec_fmt_index(
  x,
  case = c("upper", "lower"),
  index_algo = c("repeat", "excel"),
  pattern = "{x}",
  locale = NULL,
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{x}{\emph{The input vector}

\code{vector(numeric|integer)} // \strong{required}

This is the input vector that will undergo transformation to a character
vector of the same length. Values within the vector will be formatted.}

\item{case}{\emph{Use uppercase or lowercase letters}

\verb{singl-kw:[upper|lower]} // \emph{default:} \code{"upper"}

Should the resulting index characters be rendered as uppercase (\code{"upper"})
or lowercase (\code{"lower"}) letters? By default, this is set to \code{"upper"}.}

\item{index_algo}{\emph{Indexing algorithm}

\verb{singl-kw:[repeat|excel]} // \emph{default:} \code{"repeat"}

The indexing algorithm handles the recycling of the index character set. By
default, the \code{"repeat"} option is used where characters are doubled,
tripled, and so on, when moving past the character set limit. The
alternative is the \code{"excel"} option, where Excel-based column naming is
adapted and used here (e.g., \verb{[..., Y, Z, AA, AB, ...]}).}

\item{pattern}{\emph{Specification of the formatting pattern}

\verb{scalar<character>} // \emph{default:} \code{"{x}"}

A formatting pattern that allows for decoration of the formatted value. The
formatted value is represented by the \code{{x}} (which can be used multiple
times, if needed) and all other characters will be interpreted as string
literals.}

\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be used for formatting values
according to the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). We can call \code{\link[=info_locales]{info_locales()}} for
a useful reference for all of the locales that are supported.}

\item{output}{\emph{Output format}

\verb{singl-kw:[auto|plain|html|latex|rtf|word]} // \emph{default:} \code{"auto"}

The output style of the resulting character vector. This can either be
\code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"}, or
\code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the \code{"auto"}
option will choose the correct \code{output} value}
}
\value{
A character vector.
}
\description{
With numeric values in a vector, we can transform those to index values,
usually based on letters. These characters can be derived from a specified
locale and they are intended for ordering (often leaving out characters with
diacritical marks).
}
\section{Examples}{


Let's create a numeric vector for the next few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{num_vals <- c(1, 4, 5, 8, 12, 20, 26, 34, 0, -5, 1.3, NA)
}\if{html}{\out{</div>}}

Using \code{vec_fmt_index()} with the default options will create a character
vector with values rendered as index numerals. Zero values will be rendered
as \code{""} (i.e., empty strings), any \code{NA} values remain as \code{NA} values, and
negative values will be automatically made positive. The rendering context
will be autodetected unless specified in the \code{output} argument (here, it is
of the \code{"plain"} output type).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_index(num_vals)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "A" "D" "E" "H" "L" "T" "Z" "HH" "" "E" "A" "NA"
}\if{html}{\out{</div>}}

We can also use \code{vec_fmt_index()} with the \code{case = "lower"} option to create
a character vector with values rendered as lowercase Roman numerals.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_index(num_vals, case = "lower")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "a" "d" "e" "h" "l" "t" "z" "hh" "" "e" "a" "NA"
}\if{html}{\out{</div>}}

If we are formatting for a different locale, we could supply the locale ID
and let \strong{gt} obtain a locale-specific set of index values:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_index(1:10, locale = "so")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "B" "C" "D" "F" "G" "H" "J" "K" "L" "M"
}\if{html}{\out{</div>}}

As a last example, one can wrap the values in a pattern with the \code{pattern}
argument. Note here that \code{NA} values won't have the pattern applied.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_index(num_vals, case = "lower", pattern = "\{x\}.")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "a." "d." "e." "h." "l." "t." "z." "hh." "." "e." "a." "NA"
}\if{html}{\out{</div>}}
}

\section{Function ID}{

15-10
}

\section{Function Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\seealso{
The variant function intended for formatting \strong{gt} table data:
\code{\link[=fmt_index]{fmt_index()}}.

Other vector formatting functions: 
\code{\link{vec_fmt_bytes}()},
\code{\link{vec_fmt_currency}()},
\code{\link{vec_fmt_date}()},
\code{\link{vec_fmt_datetime}()},
\code{\link{vec_fmt_duration}()},
\code{\link{vec_fmt_engineering}()},
\code{\link{vec_fmt_fraction}()},
\code{\link{vec_fmt_integer}()},
\code{\link{vec_fmt_markdown}()},
\code{\link{vec_fmt_number}()},
\code{\link{vec_fmt_partsper}()},
\code{\link{vec_fmt_percent}()},
\code{\link{vec_fmt_roman}()},
\code{\link{vec_fmt_scientific}()},
\code{\link{vec_fmt_spelled_num}()},
\code{\link{vec_fmt_time}()}
}
\concept{vector formatting functions}
