% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_interactive}
\alias{opt_interactive}
\title{Option to put interactive elements in an HTML table}
\usage{
opt_interactive(
  data,
  active = TRUE,
  use_pagination = TRUE,
  use_pagination_info = TRUE,
  use_sorting = TRUE,
  use_search = FALSE,
  use_filters = FALSE,
  use_resizers = FALSE,
  use_highlight = FALSE,
  use_compact_mode = FALSE,
  use_text_wrapping = TRUE,
  use_page_size_select = FALSE,
  page_size_default = 10,
  page_size_values = c(10, 25, 50, 100),
  pagination_type = c("numbers", "jump", "simple")
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{active}{The \code{active} option will either enable or disable interactive
features for an HTML table. The individual features of an interactive HTML
table are controlled by the other options.}

\item{use_pagination}{This is the option for using pagination controls (below
the table body). By default, this is \code{TRUE} and it will allow the use to
page through table content.}

\item{use_pagination_info}{If \code{use_pagination} is \code{TRUE} then the
\code{use_pagination_info} option can be used to display informational text
regarding the current page view (this is set to \code{TRUE} by default).}

\item{use_sorting}{This option provides controls for sorting column values.
By default, this is \code{TRUE}.}

\item{use_search}{The \code{use_search} option places a search field for globally
filtering rows to the requested content. By default, this is \code{FALSE}.}

\item{use_filters}{The \code{use_filters} option places search fields below each
column header and allows for filtering by column. By default, this is
\code{FALSE}.}

\item{use_resizers}{This option allows for the interactive resizing of
columns. By default, this is \code{FALSE}.}

\item{use_highlight}{The \code{use_highlight} option highlights individual rows
upon hover. By default, this is \code{FALSE}.}

\item{use_compact_mode}{To reduce vertical padding and thus make the table
consume less vertical space the \code{use_compact_mode} option can be used. By
default, this is \code{FALSE}.}

\item{use_text_wrapping}{The \code{use_text_wrapping} option controls whether
text wrapping occurs throughout the table. This is \code{TRUE} by default and
with that text will be wrapped to multiple lines. If \code{FALSE}, text will be
truncated to a single line.}

\item{use_page_size_select, page_size_default, page_size_values}{The
\code{use_page_size_select} option lets us display a dropdown menu for the
number of rows to show per page of data. By default, this is the vector
\code{c(10, 25, 50, 100)} which corresponds to options for \code{10}, \code{25}, \code{50}, and
\code{100} rows of data per page. To modify these page-size options, provide a
numeric vector to \code{page_size_values}. The default page size (initially set
as \code{10}) can be modified with \code{page_size_default} and this works whether or
not \code{use_page_size_select} is set to \code{TRUE}.}

\item{pagination_type}{When using pagination the \code{pagination_type} option
lets us select between one of three options for the layout of pagination
controls. The default is \code{"numbers"}, where a series of page-number buttons
is presented along with 'previous' and 'next' buttons. The \code{"jump"} option
provides an input field with a stepper for the page number. With
\code{"simple"}, only the 'previous' and 'next' buttons are displayed.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
By default, a \strong{gt} table rendered as HTML will essentially be a 'static'
table. However, we can make it 'interactive' and configure those interactive
HTML options through the \code{opt_interactive()} function. Making an HTML table
interactive entails the enabling of controls for pagination, global search,
filtering, sorting, and more.

This function serves as a shortcut for setting the following options in
\code{\link[=tab_options]{tab_options()}}:
\itemize{
\item \code{ihtml.active}
\item \code{ihtml.use_pagination}
\item \code{ihtml.use_pagination_info}
\item \code{ihtml.use_sorting}
\item \code{ihtml.use_search}
\item \code{ihtml.use_filters}
\item \code{ihtml.use_resizers}
\item \code{ihtml.use_highlight}
\item \code{ihtml.use_compact_mode}
\item \code{ihtml.use_page_size_select}
\item \code{ihtml.page_size_default}
\item \code{ihtml.page_size_values}
\item \code{ihtml.pagination_type}
}
}
\section{Examples}{


Use the \code{\link{towny}} dataset to create a \strong{gt} table with a header and a source
note. Next, we add interactive HTML features through \code{opt_interactive()}.
It'll just be the default set of interactive options.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{towny |>
  dplyr::select(name, census_div, starts_with("population")) |>
  gt() |>
  fmt_integer() |>
  cols_label_with(fn = function(x) sub("population_", "", x)) |>
  cols_width(
    name ~ px(200),
    census_div ~ px(200)
  ) |>
  tab_header(
    title = "Populations of Municipalities",
    subtitle = "Census values from 1996 to 2021."
  ) |>
  tab_source_note(source_note = md("Data taken from the `towny` dataset.")) |>
  opt_interactive()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_interactive_1.png" alt="This image of a table was generated from the first code example in the `opt_interactive()` help file." style="width:100\%;">
}}

Interactive tables can have styled body cells. Here, we use the \code{\link{gtcars}}
dataset to create an interactive \strong{gt} table. Using \code{\link[=tab_style]{tab_style()}} and
\code{\link[=data_color]{data_color()}} we can flexibly style body cells throughout the table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars |>
  gt() |>
  cols_width(everything() ~ px(130)) |>
  tab_style(
    style = cell_fill(color = "gray95"),
    locations = cells_body(columns = c(mfr, model))
  ) |>
  data_color(
    columns = c(starts_with("hp"), starts_with("trq")),
    method = "numeric",
    palette = "viridis"
  ) |>
  cols_hide(columns = trim) |>
  opt_interactive()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_interactive_2.png" alt="This image of a table was generated from the second code example in the `opt_interactive()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-2
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_footnote_spec}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_stylize}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
