% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{as_rtf}
\alias{as_rtf}
\title{Output a \strong{gt} object as RTF}
\usage{
as_rtf(data, page_numbering = c("none", "footer", "header"))
}
\arguments{
\item{data}{A table object that is created using the \code{gt()} function.}

\item{page_numbering}{An option to include page numbering in the RTF
document. The page numbering text can either be in the document \code{"footer"}
or \code{"header"}. By default, page numbering is not active (\code{"none"}).}
}
\description{
Get the RTF content from a \code{gt_tbl} object as as a single-element character
vector. This object can be used with \code{writeLines()} to generate a valid .rtf
file that can be opened by RTF readers.
}
\section{Function ID}{

13-4
}

\examples{
if (interactive()) {

# Use `gtcars` to create a gt table;
# add a header and then export as
# RTF code
tab_rtf <-
  gtcars \%>\%
  dplyr::select(mfr, model) \%>\%
  dplyr::slice(1:2) \%>\%
  gt() \%>\%
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  ) \%>\%
  as_rtf()

}

}
\seealso{
Other Export Functions: 
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{Export Functions}
