% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_transform.R
\name{text_transform}
\alias{text_transform}
\title{Perform targeted text transformation with a function}
\usage{
text_transform(data, locations, fn)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{locations}{The cell or set of cells to be associated with the text
transformation. Only the \code{\link[=cells_body]{cells_body()}}, \code{\link[=cells_stub]{cells_stub()}}, and
\code{\link[=cells_column_labels]{cells_column_labels()}} helper functions can be used here. We can enclose
several of these calls within a \code{list()} if we wish to make the
transformation happen at different locations.}

\item{fn}{The function to use for text transformation.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Perform targeted text transformation with a function
}
\section{Figures}{

\if{html}{\figure{man_text_transform_1.png}{options: width=100\%}}
}

\section{Function ID}{

3-12
}

\examples{
# Use `exibble` to create a gt table;
# transform the formatted text in the
# `num` and `currency` columns using
# a function within `text_transform()`,
# where `x` is a formatted vector of
# column values
tab_1 <-
  exibble \%>\%
  dplyr::select(num, char, currency) \%>\%
  dplyr::slice(1:4) \%>\%
  gt() \%>\%
  fmt_number(columns = num) \%>\%
  fmt_currency(columns = currency) \%>\%
  text_transform(
    locations = cells_body(
      columns = num
    ),
    fn = function(x) {
      paste0(
        x, " (",
        dplyr::case_when(
          x > 20   ~ "large",
          x <= 20  ~ "small"),
        ")")
    }
  )

}
\seealso{
Other Format Data: 
\code{\link{data_color}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_missing}()},
\code{\link{fmt_number}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{fmt}()}
}
\concept{Format Data}
