% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_merge_range}
\alias{cols_merge_range}
\title{Merge two columns to a value range column}
\usage{
cols_merge_range(
  data,
  col_begin,
  col_end,
  rows = everything(),
  autohide = TRUE,
  sep = NULL,
  locale = NULL
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{col_begin}{\emph{Column to target for beginning of range}

\verb{<column-targeting expression>} // \strong{required}

The column that contains values for the start of the range. While select
helper functions such as \code{\link[=starts_with]{starts_with()}} and \code{\link[=ends_with]{ends_with()}} can be used for
column targeting, it's recommended that a single column name be used. This
is to ensure that exactly one column is provided here.}

\item{col_end}{\emph{Column to target for end of range}

\verb{<column-targeting expression>} // \strong{required}

The column that contains values for the end of the range. While select
helper functions such as \code{\link[=starts_with]{starts_with()}} and \code{\link[=ends_with]{ends_with()}} can be used for
column targeting, it's recommended that a single column name be used. This
is to ensure that exactly one column is provided here.}

\item{rows}{\emph{Rows to target}

\verb{<row-targeting expression>} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
participate in the merging process. The default \code{\link[=everything]{everything()}} results in
all rows in \code{columns} being formatted. Alternatively, we can supply a
vector of row captions within \code{\link[=c]{c()}}, a vector of row indices, or a select
helper function. Examples of select helper functions include
\code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions to filter
down to the rows we need (e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{autohide}{\emph{Automatic hiding of the \code{col_end} column}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

An option to automatically hide the column specified as
\code{col_end}. Any columns with their state changed to hidden will behave
the same as before, they just won't be displayed in the finalized table.}

\item{sep}{\emph{Separator text for ranges}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The separator text that indicates the values are ranged. If a \code{sep} value
is not provided then the range separator specific to the \code{locale} provided
will be used (if a locale isn't specified then an en dash will be used).
You can specify the use of an en dash with \code{"--"}; a triple-hyphen sequence
(\code{"---"}) will be transformed to an em dash. Should you want hyphens to be
taken literally, the \code{sep} value can be supplied within the base \code{\link[=I]{I()}}
function.}

\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be used for applying a \code{sep} pattern
specific to a locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). We can use the \code{\link[=info_locales]{info_locales()}}
function as a useful reference for all of the locales that are supported. A
locale ID can be also set in the initial \code{\link[=gt]{gt()}} function call (where it
would be used automatically by any function with a \code{locale} argument) but a
\code{locale} value provided here will override that global locale.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{cols_merge_range()} function is a specialized variant of the
\code{\link[=cols_merge]{cols_merge()}} function. It operates by taking a two columns that constitute
a range of values (\code{col_begin} and \code{col_end}) and merges them into a single
column. What results is a column containing both values separated by a long
dash (e.g., \verb{12.0 — 20.0}). The column specified in \code{col_end} is dropped from
the output table.
}
\section{Comparison with other column-merging functions}{


This function could be somewhat replicated using \code{\link[=cols_merge]{cols_merge()}}, however,
\code{cols_merge_range()} employs the following specialized operations for \code{NA}
handling:
\enumerate{
\item \code{NA}s in \code{col_begin} (but not \code{col_end}) result in a display of only
\item \code{NA}s in \code{col_end} (but not \code{col_begin}) result in a display of only
the \code{col_begin} values only for the merged column (this is the converse of
the previous)
\item \code{NA}s both in \code{col_begin} and \code{col_end} result in missing values for
the merged column
}

Any resulting \code{NA} values in the \code{col_begin} column following the merge
operation can be easily formatted using the \code{\link[=sub_missing]{sub_missing()}} function.
Separate calls of \code{\link[=sub_missing]{sub_missing()}} can be used for the \code{col_begin} and
\code{col_end} columns for finer control of the replacement values.

This function is part of a set of four column-merging functions. The other
three are the general \code{\link[=cols_merge]{cols_merge()}} function and the specialized
\code{\link[=cols_merge_uncert]{cols_merge_uncert()}} and \code{\link[=cols_merge_n_pct]{cols_merge_n_pct()}} functions. These functions
operate similarly, where the non-target columns can be optionally hidden from
the output table through the \code{hide_columns} or \code{autohide} options.
}

\section{Examples}{


Let's use a subset of the \code{\link{gtcars}} dataset to create a \strong{gt} table,
keeping only the \code{model}, \code{mpg_c}, and \code{mpg_h} columns. Merge the \code{"mpg*"}
columns together as a single range column (which is labeled as MPG, in
italics) using the \code{cols_merge_range()} function. After the merging process,
the column label for the \code{mpg_c} column is updated with \code{\link[=cols_label]{cols_label()}} to
better describe the content.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars |>
  dplyr::select(model, starts_with("mpg")) |>
  dplyr::slice(1:8) |>
  gt() |>
  cols_merge_range(
    col_begin = mpg_c,
    col_end = mpg_h
  ) |>
  cols_label(mpg_c = md("*MPG*"))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_merge_range_1.png" alt="This image of a table was generated from the first code example in the `cols_merge_range()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

5-16
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other column modification functions: 
\code{\link{cols_add}()},
\code{\link{cols_align_decimal}()},
\code{\link{cols_align}()},
\code{\link{cols_hide}()},
\code{\link{cols_label_with}()},
\code{\link{cols_label}()},
\code{\link{cols_merge_n_pct}()},
\code{\link{cols_merge_uncert}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_end}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_move}()},
\code{\link{cols_nanoplot}()},
\code{\link{cols_unhide}()},
\code{\link{cols_units}()},
\code{\link{cols_width}()}
}
\concept{column modification functions}
