% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_melting_ice_equilibrium_SA_CT_ratio_poly}
\alias{gsw_melting_ice_equilibrium_SA_CT_ratio_poly}
\title{Calculate d(SA)/d(CT) for Ice Melting in near-freezing Seawater (Polynomial version)}
\usage{
gsw_melting_ice_equilibrium_SA_CT_ratio_poly(SA, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
ratio of change in \code{SA} to change in \code{CT} [ g/kg/degC ].
}
\description{
Calculate d(SA)/d(CT) for Ice Melting in near-freezing Seawater (Polynomial version)
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(   34.7118,  34.8915,  35.0256,  34.8472,  34.7366, 34.7324)
p <- c(         10,       50,      125,      250,      600,    1000)
r <- gsw_melting_ice_equilibrium_SA_CT_ratio_poly(SA, p)
expect_equal(r, c(0.420209444587263, 0.422511664682796, 0.424345538275708,
                0.422475965003649, 0.422023755182266, 0.423038080717229))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_melting_ice_equilibrium_SA_CT_ratio_poly.html}
}
