% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_rho}
\alias{gsw_rho}
\title{In-situ density (48-term equation)}
\usage{
gsw_rho(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
in-situ density [ kg/m^3 ]
}
\description{
In-situ density (48-term equation)
}
\examples{
gsw_rho(34.7118, 28.8099, 10) # 1021.8404465661
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_rho.html}
}
\seealso{
\code{\link{gsw_rho_t_exact}} is similar to this, but using in-situ temperature. SA and CT may be computed from UNESCO quantities using \code{\link{gsw_SA_from_SP}} and \code{\link{gsw_CT_from_t}}. For potential density anomalies, use \code{\link{gsw_sigma0}} and related functions.
}

