% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SA_from_SP}
\alias{gsw_SA_from_SP}
\title{Convert from practical salinity to absolute salinity}
\usage{
gsw_SA_from_SP(SP, p, longitude, latitude)
}
\arguments{
\item{SP}{Practical Salinity (PSS-78) [ unitless ]}

\item{p}{sea pressure [ dbar ]}

\item{longitude}{longitude in decimal degrees [ 0 to 360 or -180 to 180]}

\item{latitude}{latitude in decimal degrees [ -90 to 90 ]}
}
\value{
Absolute Salinity [ g/kg ]
}
\description{
Calculate Absolute Salinity from Practical Salinity, pressure,
longitude, and latitude.
}
\details{
If SP is a matrix and if its dimensions correspond to the
lengths of longitude and latitude, then the latter are
converted to analogous matrices with \code{\link{expand.grid}}.
}
\examples{
gsw_SA_from_SP(34.5487, 10, 188, 4) # 34.711778344814114
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SA_from_SP.html}
}
\seealso{
\code{\link{gsw_SP_from_SA}} does the reverse.
}

