% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meyeraux.R
\name{meyeraux}
\alias{meyeraux}
\title{Meyer wavelet auxiliary function}
\usage{
meyeraux(x)
}
\arguments{
\item{x}{Input array, specified as a real scalar, vector, matrix, or
multidimensional array.}
}
\value{
Output array, returned as a real-valued scalar, vector, matrix, or
  multidimensional array of the same size as x.
}
\description{
Compute the Meyer wavelet auxiliary function.
}
\details{
The code \code{y = meyeraux(x)} returns values of the auxiliary function used
for Meyer wavelet generation evaluated at the elements of \code{x}. The input
\code{x} is a vector or matrix of real values. The function is \deqn{y =
35x^{4} - 84x^{5} + 70x^{6} - 20x^{7}.} \code{x} and \code{y} have the same
dimensions. The range of \code{meyeraux} is the closed interval c(0, 1).
}
\examples{

x <- seq(0, 1, length.out = 100)
y <- meyeraux(x)
plot(x, y, type="l", main = "Meyer wavelet auxiliary function",
     xlab = "", ylab = "")

}
\author{
Sylvain Pelissier, \email{sylvain.pelissier@gmail.com}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
