% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_design_combo.R
\name{gs_design_combo}
\alias{gs_design_combo}
\title{Group sequential design using MaxCombo test under non-proportional hazards}
\usage{
gs_design_combo(
  enroll_rate = define_enroll_rate(duration = 12, rate = 500/12),
  fail_rate = define_fail_rate(duration = c(4, 100), fail_rate = log(2)/15, hr = c(1,
    0.6), dropout_rate = 0.001),
  fh_test = rbind(data.frame(rho = 0, gamma = 0, tau = -1, test = 1, analysis = 1:3,
    analysis_time = c(12, 24, 36)), data.frame(rho = c(0, 0.5), gamma = 0.5, tau = -1,
    test = 2:3, analysis = 3, analysis_time = 36)),
  ratio = 1,
  alpha = 0.025,
  beta = 0.2,
  binding = FALSE,
  upper = gs_b,
  upar = c(3, 2, 1),
  lower = gs_b,
  lpar = c(-1, 0, 1),
  algorithm = mvtnorm::GenzBretz(maxpts = 1e+05, abseps = 1e-05),
  n_upper_bound = 1000,
  ...
)
}
\arguments{
\item{enroll_rate}{Enrollment rates defined by \code{define_enroll_rate()}.}

\item{fail_rate}{Failure and dropout rates defined by \code{define_fail_rate()}.}

\item{fh_test}{A data frame to summarize the test in each analysis.
See examples for its data structure.}

\item{ratio}{Experimental:Control randomization ratio.}

\item{alpha}{One-sided Type I error.}

\item{beta}{Type II error.}

\item{binding}{Indicator of whether futility bound is binding;
default of \code{FALSE} is recommended.}

\item{upper}{Function to compute upper bound.
\itemize{
\item \code{gs_spending_bound()}: alpha-spending efficacy bounds.
\item \code{gs_b()}: fixed efficacy bounds.
}}

\item{upar}{Parameters passed to \code{upper}.
\itemize{
\item If \code{upper = gs_b}, then \code{upar} is a numerical vector specifying the fixed efficacy bounds per analysis.
\item If \code{upper = gs_spending_bound}, then \code{upar} is a list including
\itemize{
\item \code{sf} for the spending function family.
\item \code{total_spend} for total alpha spend.
\item \code{param} for the parameter of the spending function.
\item \code{timing} specifies spending time if different from information-based spending; see details.
}
}}

\item{lower}{Function to compute lower bound, which can be set up similarly as \code{upper}.
See \href{https://merck.github.io/gsDesign2/articles/story-seven-test-types.html}{this vignette}.}

\item{lpar}{Parameters passed to \code{lower}, which can be set up similarly as \code{upar.}}

\item{algorithm}{ an object of class \code{\link[mvtnorm]{GenzBretz}},
                    \code{\link[mvtnorm]{Miwa}} or \code{\link[mvtnorm]{TVPACK}}
                    specifying both the algorithm to be used as well as
                    the associated hyper parameters.}

\item{n_upper_bound}{A numeric value of upper limit of sample size.}

\item{...}{Additional parameters passed to \link[mvtnorm:pmvnorm]{mvtnorm::pmvnorm}.}
}
\value{
A list with input parameters, enrollment rate, analysis, and bound.
}
\description{
Group sequential design using MaxCombo test under non-proportional hazards
}
\examples{
# The example is slow to run
library(dplyr)
library(mvtnorm)
library(gsDesign)

enroll_rate <- define_enroll_rate(
  duration = 12,
  rate = 500 / 12
)

fail_rate <- define_fail_rate(
  duration = c(4, 100),
  fail_rate = log(2) / 15, # median survival 15 month
  hr = c(1, .6),
  dropout_rate = 0.001
)

fh_test <- rbind(
  data.frame(
    rho = 0, gamma = 0, tau = -1,
    test = 1, analysis = 1:3, analysis_time = c(12, 24, 36)
  ),
  data.frame(
    rho = c(0, 0.5), gamma = 0.5, tau = -1,
    test = 2:3, analysis = 3, analysis_time = 36
  )
)

x <- gsSurv(
  k = 3,
  test.type = 4,
  alpha = 0.025,
  beta = 0.2,
  astar = 0,
  timing = 1,
  sfu = sfLDOF,
  sfupar = 0,
  sfl = sfLDOF,
  sflpar = 0,
  lambdaC = 0.1,
  hr = 0.6,
  hr0 = 1,
  eta = 0.01,
  gamma = 10,
  R = 12,
  S = NULL,
  T = 36,
  minfup = 24,
  ratio = 1
)

# Example 1 ----
# User-defined boundary
\donttest{
gs_design_combo(
  enroll_rate,
  fail_rate,
  fh_test,
  alpha = 0.025, beta = 0.2,
  ratio = 1,
  binding = FALSE,
  upar = x$upper$bound,
  lpar = x$lower$bound
)
}
# Example 2 ----
\donttest{
# Boundary derived by spending function
gs_design_combo(
  enroll_rate,
  fail_rate,
  fh_test,
  alpha = 0.025,
  beta = 0.2,
  ratio = 1,
  binding = FALSE,
  upper = gs_spending_combo,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025), # alpha spending
  lower = gs_spending_combo,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.2), # beta spending
)
}
}
