% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_wlr.R
\name{gs_create_arm}
\alias{gs_create_arm}
\title{Create npsurvSS arm object}
\usage{
gs_create_arm(enroll_rate, fail_rate, ratio, total_time = 1e+06)
}
\arguments{
\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{ratio}{Experimental:Control randomization ratio.}

\item{total_time}{Total analysis time.}
}
\value{
A list of the two arms.
}
\description{
Create npsurvSS arm object
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if there is only one stratum.
   \item Calculate the accrual duration.
   \item calculate the accrual intervals.
   \item Calculate the accrual parameter as the proportion of enrollment rate*duration.
   \item Set cure proportion to zero.
   \item set survival intervals and shape.
   \item Set fail rate in fail_rate to the Weibull scale parameter for the survival distribution in the arm 0.
   \item Set the multiplication of hazard ratio and fail rate to the Weibull scale parameter
   for the survival distribution in the arm 1.
   \item Set the shape parameter to one as the exponential distribution for
   shape parameter for the loss to follow-up distribution
   \item Set the scale parameter to one as the scale parameter for the loss to follow-up
    distribution since the exponential distribution is supported only
   \item Create arm 0 using \code{gsDesign2:::create_arm()} using the parameters for arm 0.
   \item Create arm 1 using \code{gsDesign2:::create_arm()} using the parameters for arm 1.
   \item Set the class of the two arms.
   \item Return a list of the two arms.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
enroll_rate <- define_enroll_rate(
  duration = c(2, 2, 10),
  rate = c(3, 6, 9)
)

fail_rate <- define_fail_rate(
  duration = c(3, 100),
  fail_rate = log(2) / c(9, 18),
  hr = c(.9, .6),
  dropout_rate = .001
)

gs_create_arm(enroll_rate, fail_rate, ratio = 1)
}
