% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_b.R
\name{gs_b}
\alias{gs_b}
\title{Default boundary generation}
\usage{
gs_b(par = NULL, k = NULL, ...)
}
\arguments{
\item{par}{For \code{gs_b()}, this is just Z-values for the boundaries;
can include infinite values.}

\item{k}{Is \code{NULL} (default), return \code{par}, else return \code{par[k]}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Returns the vector input \code{par} if \code{k} is \code{NULL}, otherwise, \code{par[k]}.
}
\description{
\code{gs_b()} is the simplest version of a function to be used with the
\code{upper} and \code{lower} arguments in \code{gs_prob()},
\code{gs_power_nph()} and \code{gs_design_nph()};
it simply returns the vector input in the input vector \code{Z} or,
if \code{k} is specified, \verb{par[k]j} is returned.
Note that if bounds need to change with changing information at analyses,
\code{gs_b()} should not be used.
For instance, for spending function bounds use.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if the input k is null as default.
   \itemize{
     \item If the input k is null as default, return the whole vector of
     Z-values of the boundaries.
     \item If the input k is not null, return the corresponding boundary
     in the vector of Z-values.
     }
   \item Return a vector of boundaries.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
# Simple: enter a vector of length 3 for bound
gs_b(par = 4:2)

# 2nd element of par
gs_b(par = 4:2, k = 2)

# Generate an efficacy bound using a spending function
# Use Lan-DeMets spending approximation of O'Brien-Fleming bound
# as 50\%, 75\% and 100\% of final spending
# Information fraction
IF <- c(.5, .75, 1)
gs_b(par = gsDesign::gsDesign(
  alpha = .025, k = length(IF),
  test.type = 1, sfu = gsDesign::sfLDOF,
  timing = IF
)$upper$bound)
}
