% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{fW}
\alias{fW}
\title{Water stress}
\usage{
fW(W, PET)
}
\arguments{
\item{W}{Water stress given as the ratio of water reserves to water
holding capacity.}

\item{PET}{Potential evapotranspiration in mm per day.}
}
\value{
A value in the range (0, 1), acting as a multiplicative factor to
plant growth.
}
\description{
Threshold function representing growth limitation due to water stress.
}
\details{
After equation (6) in McCall et al. (2003).#'
}
\examples{
fW(0.5, 7)
fW(0.5, 5)
fW(0.5, 3)

}
\references{
\insertRef{mccall2003PastureGrowthModel}{growR}
}
