% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grob_object_functions.R
\name{grob_image}
\alias{grob_image}
\title{Grob Image}
\usage{
grob_image(x)
}
\arguments{
\item{x}{Either a \code{ggplot} object, a file path to .png image or a URL
to a .png image.}
}
\value{
An R6 object of the grob image class.
}
\description{
Initialize a grob image object, to be used within \code{\link{grob_col}}.
}
\examples{

gg = data.frame(x = c(5, 14, 6, 10), y = c(3, 30, 17, 7)) \%>\%
  ggplot2::ggplot(mapping = ggplot2::aes(x = x, y = y)) +
  ggplot2::geom_line(color = 'red') 
  
gg \%>\%
  grob_image() \%>\%
  view_grob()

}
