% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_cpc.R
\name{sample_cpc}
\alias{sample_cpc}
\title{Sample Cost Per Click}
\usage{
sample_cpc(input_df, priors, n_samples = 50000)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str), sum_clicks (dbl), sum_cost (dbl).}

\item{priors}{Optional list of priors {k0, theta0} for Gamma.
Default \eqn{Gamma(1, 250)} will be use otherwise.}

\item{n_samples}{Optional integer value. Defaults to 50,000 samples.}
}
\value{
input_df with 2 new nested columns `gamma_params` and `samples`
}
\description{
Adds 2 new nested columns to the input_df: `gamma_params` and `samples`
     `gamma_params` in each row should be a tibble of length 2 (\eqn{k}
        and \eqn{\theta} parameters)
    `samples` in each row should be a tibble of length `n_samples`
}
\details{
See update_rules vignette for a mathematical representation.
\deqn{cpc_i ~ Exponential(\lambda)}
\deqn{\lambda ~ Gamma(k, \theta)}
Average CPC is sampled from a Gamma distribution with an Exponential likelihood
of an individual cost.
}
