% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_n_persons_x_times_many_n}
\alias{sim_n_persons_x_times_many_n}
\title{Simulate for different n}
\usage{
sim_n_persons_x_times_many_n(prob, n = seq(10, 80, by = 10), a = 7,
  ap = rep(1/length(a), length(a)), times = 100, progress = "text")
}
\arguments{
\item{prob}{Probability to draw a construct from a certain category. Length
of vector determines number of categories.}

\item{n}{Number of persons, i.e. grids to sample.}

\item{a}{Number of constructs to be sampled.}

\item{ap}{Probabilities for each number of attributes to be sampled.}

\item{times}{Number of times to repeat each simulation.}

\item{progress}{Type of progress bar shown during simulation.}
}
\value{
A result dataframe.
}
\description{
Creates simulation results for different n. Runs
\code{\link{sim_n_persons_x_times}} for different n.
}
\examples{
\dontrun{
r <- sim_n_persons_x_times_many_n(dexp(1:30, .05), a = 7, times = 100)
r <- sim_n_persons_x_times_many_n(dexp(1:30, .05), a = 5:7, ap = 1:3, times = 100)
}
}
\seealso{
Other Simulations: \code{\link{sim_n_persons_x_times}},
  \code{\link{sim_n_persons}}, \code{\link{sim_one_person}}
}

