% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern_square.R
\docType{data}
\name{pattern_square}
\alias{pattern_square}
\alias{names_square}
\title{Square pattern matrix}
\format{
An object of class \code{character} of length 6.
}
\usage{
pattern_square(type = "diagonal", subtype = NULL, nrow = 5L, ncol = 5L)

names_square
}
\arguments{
\item{type}{Either "diagonal" (default), "diagonal_skew", "horizontal", "vertical",
or any \code{type} in \code{names_weave}.  See Details.}

\item{subtype}{See Details.  For "diagonal", "diagonal_skew", "horizontal", or "vertical"
an integer of the desired number of colors (or other graphical elements).}

\item{nrow}{Number of rows (height).}

\item{ncol}{Number of columns (width).}
}
\value{
A matrix of integer values indicating where the each color
(or other graphical element) should be drawn on a rectangular grid.
Indices \verb{[1,1]} of the matrix corresponds to the bottom-left of the grid
while indices \verb{[1,ncol]} corresponds to the bottom-right of the grid.
This matrix has a "pattern_square" subclass which supports a special \code{print()} method.
}
\description{
\code{pattern_square()} returns an integer matrix indicating where each
color (or other graphical element) should be drawn on a rectangular grid
for a specified square pattern type and subtype.
\code{names_square} lists the currently supported square \code{type}s (excluding those in \code{names_weave}).
}
\details{
\describe{
\item{"horizontal", "vertical"}{"horizontal" and "vertical" simply cycle through the colors
either horizontally or vertically.
Use \code{subtype} to indicate the (integer) number of colors (or other graphical elements).
"horizontal" will produce horizontal stripes of color whereas "vertical" will produce vertical stripes.}
\item{"diagonal", "diagonal_skew"}{"diagonal" and "diagonal_skew" simply cycle through the colors
both horizontally and vertically.
Use \code{subtype} to indicate the (integer) number of colors (or other graphical elements).
If two colors are requested this provides the standard two-color checkerboard pattern.
If there are more than three colors than "diagonal" will have colored diagonals
going from top left to bottom right while "diagonal_skew" will have them
going form bottom left to top right.}
\item{"square"}{"square" attempts a uniform coloring using "square_tiling" before falling
falling back on "diagonal".  If \code{subtype} is \code{1L}, \code{2L}, \code{3L}, or \code{4L} uses "square_tiling"
else uses "diagonal".}
\item{"square_tiling"}{"square_tiling" supports
uniform coloring for (non-staggered) square tilings.
Use \code{subtype} to either indicate the (integer) number of colors
or a string with four integers such as \code{"1231"}
(will fill in a 2x2 matrix by row which will then be tiled).
Supports up to a max of four colors.}
\item{any pattern from \code{names_weave}}{
We simply convert the logical matrix returned by \code{\link[=pattern_weave]{pattern_weave()}} into an
integer matrix by having any \code{TRUE} set to \code{1L} and \code{FALSE} set to \code{2L}.
Hence the various weave patterns only support (up to) two-color patterns.
See \code{\link[=pattern_weave]{pattern_weave()}} for more details about supported \code{type} and \code{subtype}.}
}
}
\examples{
 # supported square names
 print(names_square)

 # (main) diagonal has colors going from top left to bottom right
 diagonal <- pattern_square("diagonal", 4L, nrow = 7L, ncol = 9L)
 print(diagonal)

 # skew diagonal has colors going from bottom left to top right
 skew <- pattern_square("diagonal_skew", 4L, nrow = 7L, ncol = 9L)
 print(skew)

 horizontal <- pattern_square("horizontal", 4L, nrow = 8L, ncol = 8L)
 print(horizontal)

 vertical <- pattern_square("vertical", 4L, nrow = 8L, ncol = 8L)
 print(vertical)

 # uniform coloring using 4 colors
 color4 <- pattern_square("square_tiling", 4L, nrow = 7L, ncol = 9L)
 print(color4)

 # uniform coloring using 3 colors
 color3 <- pattern_square("square_tiling", 3L, nrow = 7L, ncol = 9L)
 print(color3)

 # also supports the various 'weave' patterns
 zigzag <- pattern_square("twill_zigzag", nrow = 15L, ncol = 9L)
 print(zigzag)

}
\seealso{
\code{\link[=grid.pattern_regular_polygon]{grid.pattern_regular_polygon()}} for drawing to a graphics device
polygons in multiple color/size/shape patterns.
\code{\link[=pattern_weave]{pattern_weave()}} for more information on "weave" patterns.
}
\keyword{datasets}
