\name{rectprismmag}
\alias{rectprismmag}
\docType{package}
\title{
rectprismmag
}
\description{
Calculates the magnetic effect of 3-D rectangular prisms.
Calculates anomalies of \code{N} prisms at \code{M} observation stations.

Stations cannot be positioned inside a prism, or on its edges or faces.
Stations cannot be positioned directly below the corners of a prism.

Coordinates of stations and prisms are assumed to share a common coordinate system.

Returns total field magnetic anomaly in nanoteslas (nT).

N.B. Demagnetization effects are ignored in this subroutine.
}
\usage{
rectprismmag(xstation, ystation, zstation, xmin, xmax, ymin, ymax,
             zdeep, zshallow, suscvolsi, nrmstr, nrmincl, nrmdecl,
             fieldtotal, fieldincl, fielddecl, bycell=FALSE)	
}
\arguments{
  \item{xstation}{vector of length \code{M} with the x-coordinates of each station, in km, positive east;}
  \item{ystation}{vector of length \code{M} with the y-coordinates of each station, in km, positive north;}
  \item{zstation}{vector of length \code{M} with the z-coordinates of each station, in km, positive up;}
  \item{xmin}{vector of length \code{N} with the minimum x-coordinates of each prism, in km, positive east;}
  \item{xmax}{vector of length \code{N} with the maximum x-coordinates of each prism, in km, positive east;}
  \item{ymin}{vector of length \code{N} with the minimum y-coordinates of each prism, in km, positive north;}
  \item{ymax}{vector of length \code{N} with the maximum y-coordinates of each prism, in km, positive north;}
  \item{zdeep}{vector of length \code{N} with the bottom z-coordinates of each prism, in km, positive up;}
  \item{zshallow}{vector of length \code{N} with the top z-coordinates of each prism, in km, positive up;}
  \item{suscvolsi}{vector of length \code{N} with the volume susceptibility (unitless);}
  \item{nrmstr}{vector of length \code{N} with the remanent magnetization of each prism, in Amperes per meter (A/m);}
  \item{nrmincl}{vector of length \code{N} with the inclination angle of the remanent magnetization for each prism, in degrees, positive below horizontal;}
  \item{nrmdecl}{vector of length \code{N} with the declination angle of the remanent magnetization for each prism, in degrees, positive east of true north;}
  \item{fieldtotal}{vector of length \code{N} with the Earth's field intensity at each prism, in nanoteslas (nT);}
  \item{fieldincl}{vector of length \code{N} with the Earth's field inclination at each prism, in degrees, positive below horizontal;}
  \item{fielddecl}{vector of length \code{N} with the Earth's field declination at each prism, in degrees, positive east of true north;}
  \item{bycell}{returns \code{M}-by-\code{N} matrix with anomaly values generated by individual prisms (default FALSE).}
}
\value{
Returns a matrix of length \code{M} rows.

If \code{bycell=FALSE}, there will be \code{M} rows and 1 column, and the
element in the \code{i}-th row represents the total magnetic anomaly generated
by all \code{N} prisms as observed at the \code{i}-th station.

If \code{bycell=TRUE}, the matrix will have \code{M} rows and \code{N} columns,
with the element \code{[i,j]} representing the anomaly value generated by the
\code{j}-th prism as observed at the \code{i}-th station.
}
\references{
\itemize{
\item Plouff, D., 1975, Derivation of formulas and FORTRAN programs to compute magnetic anomalies of prisms, National Technical Information Service No. PB-243-525, U.S. Department of Commerce, Springfield, VA.  \cr\href{https://ntrl.ntis.gov/NTRL/dashboard/searchResults/titleDetail/PB243525.xhtml}{https://ntrl.ntis.gov/NTRL/dashboard/searchResults/titleDetail/PB243525.xhtml}.
}
}
\seealso{
\command{\link{rectprismgrav}},
\code{\link[=gravmagsubs-package]{gravmagsubs}}.
}
\examples{
\donttest{
#########################################################
## magnetic anomaly of single prism at a single point  ##

# location of the point where the magnetic anomaly will be calculated
magstation <- data.frame(x=0, y=0, z=0)

# the rectangular prism is defined by its six edges
prism1 <- data.frame(xmin=-5, xmax=5,
                     ymin=-5, ymax=5,
                     zmin=-10, zmax=-5)

susc <- 5       # susceptiblity (SI)
mstr <- 0       # remanent magnetization (A/m)
mincl <- 0      # remanent inclination (deg)
mdecl <- 0      # remanent declination (deg)
ftotal <- 48800 # Earth's field intensity (nT)
fincl <- 60     # field inclination (deg)
fdecl <- 12     # field declination (deg)

maganom <- rectprismmag(magstation$x, magstation$y, magstation$z,
                        prism1$xmin, prism1$xmax,
                        prism1$ymin, prism1$ymax,
                        prism1$zmin, prism1$zmax, susc,
                        mstr, mincl, mdecl,
                        ftotal, fincl, fdecl)

#########################################################
}
}
