% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_inflator.R
\name{generic_inflator}
\alias{generic_inflator}
\title{Generic inflator}
\usage{
generic_inflator(vars, h, fy.year.of.sample.file = "2012-13",
  nonzero = FALSE, estimator = "mean", pred_interval = 80)
}
\arguments{
\item{vars}{A character vector of those variables within \code{.sample_file} for which forecasts are desired.}

\item{h}{An integer, how many years ahead should the inflator be targeted.}

\item{fy.year.of.sample.file}{A string representing the financial year of \code{.sample_file}.}

\item{nonzero}{Should the forecast be taken on all values, or just nonzero values?}

\item{estimator}{What forecast element should be used: the point estimate (\code{"mean"}), or the \code{upper} or \code{lower} endpoint of a prediction interval?}

\item{pred_interval}{If \code{estimator} is \code{upper} or \code{lower}, what prediction interval are these the end points of?}
}
\value{
A data table of two columns: \code{variable} containing \code{vars} and \code{inflator} equal to the inflator to be applied to that variable to inflate it ahead \code{h} years.
}
\description{
Used to inflate variables in the sample file when there is no clear existing index.
}
