% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagen-methods.R
\name{datagen}
\alias{datagen}
\alias{datagen.mgcv.smooth}
\alias{datagen.fs.interaction}
\alias{datagen.gam}
\alias{datagen.gamm}
\alias{datagen.list}
\title{Generate data over the range of variables used in smooths}
\usage{
datagen(x, ...)

\method{datagen}{mgcv.smooth}(x, n = 100, data, ...)

\method{datagen}{fs.interaction}(x, n = 100, data, ...)

\method{datagen}{gam}(x, smooth = NULL, n = 200, ...)

\method{datagen}{gamm}(x, ...)

\method{datagen}{list}(x, ...)
}
\arguments{
\item{x}{an object for which new data is required. Currently objects of
classes \code{"gam"}, and \code{"gamm"} are supported, as are smooths from \strong{mgcv}
inheriting from class \code{"mgcv.smooth"}.}

\item{...}{arguments passed to methods}

\item{n}{numeric; the number of data values to generate per term in each
smooth.}

\item{data}{data frame; for \code{"mgcv.smooth"} objects, the data used to fit
the GAM need to be supplied.}
}
\value{
A data frame of new values spread over the range of the
observed values.
}
\description{
For each smooth in a GAM, generate new data over the range of the variables
involved in a smooth.
}
\author{
Gavin L. Simpson
}
\keyword{internal}
