% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_LKJ.R
\name{cgeneric_LKJ}
\alias{cgeneric_LKJ}
\title{Build an \code{cgeneric} model for
the LKG prior on correlation matrix.}
\usage{
cgeneric_LKJ(
  n,
  eta,
  sigma.prior.reference = rep(1, n),
  sigma.prior.probability = rep(NA, n),
  ...
)
}
\arguments{
\item{n}{integer to define the size of the matrix}

\item{eta}{numeric greater than 1, the parameter}

\item{sigma.prior.reference}{numeric vector with length \code{n},
\code{n} is the number of nodes (variables) in the graph, as the
reference standard deviation to define the PC prior for each
marginal variance parameters. If missing, the model will be
assumed for a correlation. If a length \code{n} vector is given
and \code{sigma.prior.reference} is missing, it will be used as
known square root of the variances.}

\item{sigma.prior.probability}{numeric vector with length \code{n}
to set the probability statement of the PC prior for each
marginal variance parameters. The probability statement is
P(sigma < \code{sigma.prior.reference}) = p. If missing, all the
marginal variances are considered as known, as described in
\code{sigma.prior.reference}.
If a vector is given and a probability is NA, 0 or 1, the
corresponding \code{sigma.prior.reference} will be used as fixed.}

\item{...}{additional arguments passed to \code{\link[INLAtools:cgeneric-class]{INLAtools::cgeneric()}}.}
}
\value{
a \code{cgeneric} object, see \code{\link[INLAtools:cgeneric-class]{INLAtools::cgeneric()}} for details.
}
\description{
Build an \code{cgeneric} model for
the LKG prior on correlation matrix.
}
\details{
It uses the Cannonical Partial Correlation (CPC),
see \code{\link[=basepcor]{basepcor()}} for details.
}
\examples{
## a cgeneric model for the LKJ prior
## for theta from the CPC parametrization
cglkj <- cgeneric(
    model = "LKJ", n = 3, eta = 2,
    useINLAprecomp = FALSE)##!is.na(packageCheck("INLA", "25.12.16")))

## correlation matrix, p = 3
cc <- matrix(c(1,.8,-.625, 0.8,1,-.5, -0.625,-.5,1), 3)

## CPC parametrization: C(theta)
(bb <- basecor(cc))
th <- bb$theta

## p(theta | eta)
prior(cglkj, theta = th)

## precision inverse
solve(prec(cglkj, theta = th))
solve(prec(cglkj, theta = c(0,0,0)))
solve(prec(cglkj, theta = c(1,1,1)))


}
\seealso{
\code{\link[=dLKJ]{dLKJ()}} and \code{\link[=basepcor]{basepcor()}}
}
