% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genind_to_structure.R
\name{genind_to_structure}
\alias{genind_to_structure}
\title{Convert a genind object into a STRUCTURE file}
\usage{
genind_to_structure(x, output = "")
}
\arguments{
\item{x}{An object of class \code{genind}
from package \pkg{adegenet}.}

\item{output}{A character string of the form 
\code{output = "path_to_file/file_name.txt"}. Then, the function
will write a text file named 'file_name.txt' in the directory corresponding
to 'path_to_file'. Without 'path_to_file', the text file is written in the
current working directory. The text file has the format required by STRUCTURE
software.}
}
\value{
If \code{output} is the path and/or the file name of a text file, 
then nothing is returned in R environment but a text file is created with 
the specified file name, either in the current working directory or in the
specified folder.
}
\description{
The function converts an object of class \code{genind} into
a STRUCTURE file.
It is designed to be used with diploid microsatellite data with
alleles coded with 2 or 3 digits or SNPs genind objects.
}
\section{Warning}{

\subsection{Allele coding}{
This function can handle genetic data with different allele coding: 2 or 3
digit coding for microsatellite data or 2 digit coding for SNPs (A,C,T,G
become respectively 01, 02, 03, 04).
}
\subsection{Individuals order}{
When individuals in input data are not ordered by populations, individuals
from the same population can be separated by individuals from other
populations. It can be problematic when calculating then pairwise distance
matrices. Therefore, in such a case, individuals are ordered by populations
and populations ordered in alphabetic order.
}
}

\examples{
data(data_ex_genind)
x <- data_ex_genind
genind_to_structure(x,
                    output = tempfile(fileext = ".txt"))
}
\author{
P. Savary
}
\keyword{internal}
